/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit.TestWorkspace;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;

public class EARArtifactEditTest
extends TestCase {
    private IProject earProject;
    private String earModuleName;

    public EARArtifactEditTest() {
        if (TestWorkspace.init()) {
            this.earProject = TestWorkspace.getTargetProject("EARArtifactEditTest");
            this.earModuleName = "EARArtifactModule";
        } else {
            EARArtifactEditTest.fail();
        }
    }

    public void testGetJ2EEVersion() {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
            int version = edit.getJ2EEVersion();
            Integer integer = new Integer(version);
            EARArtifactEditTest.assertTrue((boolean)integer.equals("1.4"));
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetJ2EEModuleReferences() {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
            IVirtualReference[] j2eeModuleRefs = edit.getJ2EEModuleReferences();
            EARArtifactEditTest.assertTrue((j2eeModuleRefs.length > 0 ? 1 : 0) != 0);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetDeploymentDescriptorResource() {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
            String uri = edit.getDeploymentDescriptorResource().getURI().toString();
            EARArtifactEditTest.assertTrue((boolean)uri.equals("platform:/resource/EARArtifactModule/EARArtifactModule/META-INF/application.xml"));
        }
        catch (Throwable throwable) {
            if (edit != null) {
                edit.dispose();
            }
            EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
            throw throwable;
        }
        if (edit != null) {
            edit.dispose();
        }
        EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
    }

    public void testCreateModelRoot() {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForWrite((IProject)this.earProject);
            EObject object = edit.createModelRoot();
            EARArtifactEditTest.assertNotNull((Object)object);
        }
        catch (Throwable throwable) {
            if (edit != null) {
                edit.dispose();
            }
            EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
            throw throwable;
        }
        if (edit != null) {
            edit.dispose();
        }
        EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
    }

    public void testCreateModelRootint() {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
            EObject object = edit.createModelRoot(14);
            EARArtifactEditTest.assertNotNull((Object)object);
        }
        catch (Throwable throwable) {
            if (edit != null) {
                edit.dispose();
            }
            EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
            throw throwable;
        }
        if (edit != null) {
            edit.dispose();
        }
        EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
    }

    public void testEARArtifactEditComponentHandleboolean() {
        StructureEdit moduleCore = null;
        EARArtifactEdit edit = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.earProject);
            moduleCore.getComponent();
            edit = new EARArtifactEdit(this.earProject, true);
            EARArtifactEditTest.assertNotNull((Object)edit);
        }
        finally {
            if (moduleCore != null) {
                moduleCore.dispose();
                edit.dispose();
            }
        }
    }

    public void testEARArtifactEditArtifactEditModel() {
        EARArtifactEdit edit = new EARArtifactEdit(this.getArtifactEditModelforRead());
        EARArtifactEditTest.assertNotNull((Object)edit);
        edit.dispose();
    }

    public void testGetEARArtifactEditForReadComponentHandle() {
        StructureEdit moduleCore = null;
        EARArtifactEdit edit = null;
        try {
            moduleCore = StructureEdit.getStructureEditForRead((IProject)this.earProject);
            moduleCore.getComponent();
            edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
            EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
        finally {
            if (moduleCore != null) {
                moduleCore.dispose();
                edit.dispose();
            }
        }
    }

    public void testGetEARArtifactEditForWriteComponentHandle() {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForWrite((IProject)this.earProject);
        }
        catch (Throwable throwable) {
            if (edit != null) {
                edit.dispose();
            }
            EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
            throw throwable;
        }
        if (edit != null) {
            edit.dispose();
        }
        EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
    }

    public void testGetEARArtifactEditForReadWorkbenchComponent() {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
            EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetEARArtifactEditForWriteWorkbenchComponent() {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForWrite((IProject)this.earProject);
        }
        catch (Throwable throwable) {
            if (edit != null) {
                edit.dispose();
            }
            EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
            throw throwable;
        }
        if (edit != null) {
            edit.dispose();
        }
        EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
    }

    public void testIsValidEARModule() {
        IVirtualComponent component = null;
        try {
            component = ComponentCore.createComponent((IProject)this.earProject, (String)this.earModuleName);
            EARArtifactEdit.isValidEARModule((IVirtualComponent)component);
        }
        catch (UnresolveableURIException e) {
            e.printStackTrace();
        }
        boolean isValid = ArtifactEdit.isValidEditableModule((IVirtualComponent)component);
        EARArtifactEditTest.assertTrue((boolean)isValid);
    }

    public void testIsValidEAREditableModule() {
        IVirtualComponent component = null;
        try {
            component = ComponentCore.createComponent((IProject)this.earProject, (String)this.earModuleName);
            EARArtifactEdit.isValidEARModule((IVirtualComponent)component);
        }
        catch (UnresolveableURIException e) {
            e.printStackTrace();
        }
        boolean isValid = ArtifactEdit.isValidEditableModule((IVirtualComponent)component);
        EARArtifactEditTest.assertTrue((boolean)isValid);
    }

    public void testGetApplicationXmiResource() {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
            String uri = edit.getApplicationXmiResource().getURI().toString();
            EARArtifactEditTest.assertTrue((boolean)uri.equals("platform:/resource/EARArtifactModule/EARArtifactModule/META-INF/application.xml"));
        }
        catch (Throwable throwable) {
            if (edit != null) {
                edit.dispose();
            }
            EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
            throw throwable;
        }
        if (edit != null) {
            edit.dispose();
        }
        EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
    }

    public void testGetApplication() {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
            edit.createModelRoot();
            Application obj = edit.getApplication();
            EARArtifactEditTest.assertNotNull((Object)obj);
        }
        catch (Throwable throwable) {
            if (edit != null) {
                edit.dispose();
            }
            EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
            throw throwable;
        }
        if (edit != null) {
            edit.dispose();
        }
        EARArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
    }

    public void testAddApplicationIfNecessary() {
        block8: {
            EARArtifactEdit edit = null;
            try {
                try {
                    edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
                }
                catch (Exception exception) {
                    if (edit != null) {
                        edit.dispose();
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (edit != null) {
                    edit.dispose();
                }
                throw throwable;
            }
            if (edit != null) {
                edit.dispose();
            }
        }
        this.pass();
    }

    public void testUriExists() {
        EARArtifactEdit edit = null;
        try {
            try {
                edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
                edit.uriExists(TestWorkspace.EJB_MODULE_URI.toString());
            }
            catch (Exception exception) {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetWorkbenchUtilModules() {
        EARArtifactEdit edit = null;
        try {
            try {
                edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
                edit.getUtilityModuleReferences();
            }
            catch (Exception exception) {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetWorkbenchJ2EEModules() {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
            edit.getJ2EEModuleReferences();
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void pass() {
        EARArtifactEditTest.assertTrue((boolean)true);
    }

    public ArtifactEditModel getArtifactEditModelforRead() {
        EMFWorkbenchContext context = new EMFWorkbenchContext(this.earProject);
        return new ArtifactEditModel(this.toString(), context, true, TestWorkspace.APP_CLIENT_MODULE_URI);
    }

    public EnterpriseArtifactEdit getArtifactEditForRead() {
        return new EARArtifactEdit(this.getArtifactEditModelforRead());
    }
}

