/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit.TestWorkspace;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;

public class EJBArtifactEditTest
extends TestCase {
    private IProject ejbProject;
    private String ejbModuleName;

    public EJBArtifactEditTest() {
        if (TestWorkspace.init()) {
            this.ejbProject = TestWorkspace.getTargetProject("EJBArtifactEditTest");
            this.ejbModuleName = "EJBArtifactEditModule";
        } else {
            EJBArtifactEditTest.fail();
        }
    }

    public void testGetJ2EEVersion() {
        EJBArtifactEdit edit = null;
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.ejbProject);
            String version = new Integer(edit.getJ2EEVersion()).toString();
            EJBArtifactEditTest.assertTrue((boolean)version.equals("2.1"));
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetDeploymentDescriptorResource() {
        EJBArtifactEdit edit = null;
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.ejbProject);
            String uri = edit.getDeploymentDescriptorResource().getURI().toString();
            EJBArtifactEditTest.assertTrue((boolean)uri.equals("platform:/resource/EARArtifactEditTest/EARArtifactModule/META-INF/application.xml"));
        }
        catch (Throwable throwable) {
            if (edit != null) {
                edit.dispose();
            }
            EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
            throw throwable;
        }
        if (edit != null) {
            edit.dispose();
        }
        EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
    }

    public void testGetDeploymentDescriptorRoot() {
        block8: {
            EJBArtifactEdit edit = null;
            try {
                try {
                    edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.ejbProject);
                    edit.getDeploymentDescriptorRoot();
                }
                catch (Exception exception) {
                    if (edit != null) {
                        edit.dispose();
                    }
                    EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (edit != null) {
                    edit.dispose();
                }
                EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                throw throwable;
            }
            if (edit != null) {
                edit.dispose();
            }
            EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
    }

    public void testCreateModelRoot() {
        block8: {
            EJBArtifactEdit edit = null;
            try {
                try {
                    edit = EJBArtifactEdit.getEJBArtifactEditForWrite((IProject)this.ejbProject);
                    edit.createModelRoot();
                }
                catch (Exception exception) {
                    if (edit != null) {
                        edit.dispose();
                    }
                    EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (edit != null) {
                    edit.dispose();
                }
                EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                throw throwable;
            }
            if (edit != null) {
                edit.dispose();
            }
            EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
    }

    public void testCreateModelRootint() {
        block8: {
            EJBArtifactEdit edit = null;
            try {
                try {
                    edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.ejbProject);
                    edit.createModelRoot(14);
                }
                catch (Exception exception) {
                    if (edit != null) {
                        edit.dispose();
                    }
                    EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (edit != null) {
                    edit.dispose();
                }
                EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                throw throwable;
            }
            if (edit != null) {
                edit.dispose();
            }
            EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
    }

    public void testEJBArtifactEditComponentHandleboolean() {
        EJBArtifactEdit edit = null;
        try {
            edit = new EJBArtifactEdit(this.ejbProject, true);
            EJBArtifactEditTest.assertNotNull((Object)edit);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testEJBArtifactEditArtifactEditModel() {
        EJBArtifactEdit edit = new EJBArtifactEdit(this.getArtifactEditModelforRead());
        EJBArtifactEditTest.assertNotNull((Object)edit);
        edit.dispose();
    }

    public void testGetEJBJarXmiResource() {
        block8: {
            EJBArtifactEdit edit = null;
            try {
                try {
                    edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.ejbProject);
                    edit.getEJBJarXmiResource().toString();
                }
                catch (Exception exception) {
                    if (edit != null) {
                        edit.dispose();
                    }
                    EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (edit != null) {
                    edit.dispose();
                }
                EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                throw throwable;
            }
            if (edit != null) {
                edit.dispose();
            }
            EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
    }

    public void testHasEJBClientJARProject() {
        EJBArtifactEdit edit = null;
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.ejbProject);
            edit.hasEJBClientJARProject();
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testCreateNewModule() {
        EJBArtifactEdit edit = null;
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.ejbProject);
            Module module = edit.createNewModule();
            EJBArtifactEditTest.assertNotNull((Object)module);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetEJBClientJarModule() {
        EJBArtifactEdit edit = null;
        try {
            try {
                edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.ejbProject);
                edit.getEJBClientJarModule();
            }
            catch (Exception exception) {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetEJBJar() {
        EJBArtifactEdit edit = null;
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.ejbProject);
            EJBJar jar = edit.getEJBJar();
            EJBArtifactEditTest.assertNotNull((Object)jar);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetDeploymenyDescriptorType() {
        EJBArtifactEdit edit = null;
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.ejbProject);
            int type = edit.getDeploymentDescriptorType();
            EJBArtifactEditTest.assertTrue((type >= 0 ? 1 : 0) != 0);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAddEJBJarIfNecessary() {
        new EJBArtifactEdit(this.getArtifactEditModelforRead()){

            protected void addEJBJarIfNecessary(XMLResource aResource) {
                super.addEJBJarIfNecessary(aResource);
            }

            public void test() {
                this.addEJBJarIfNecessary(null);
            }
        };
    }

    public void testGetEJBArtifactEditForReadComponentHandle() {
        EJBArtifactEdit edit = null;
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.ejbProject);
            EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetEJBArtifactEditForWriteComponentHandle() {
        EJBArtifactEdit edit = null;
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForWrite((IProject)this.ejbProject);
        }
        catch (Throwable throwable) {
            if (edit != null) {
                edit.dispose();
            }
            EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
            throw throwable;
        }
        if (edit != null) {
            edit.dispose();
        }
        EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
    }

    public void testGetEJBArtifactEditForReadWorkbenchComponent() {
        EJBArtifactEdit edit = null;
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.ejbProject);
            EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetEJBArtifactEditForWriteWorkbenchComponent() {
        EJBArtifactEdit edit = null;
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForWrite((IProject)this.ejbProject);
        }
        catch (Throwable throwable) {
            if (edit != null) {
                edit.dispose();
            }
            EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
            throw throwable;
        }
        if (edit != null) {
            edit.dispose();
        }
        EJBArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
    }

    public void testIsValidEJBModule() {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.ejbProject, (String)this.ejbModuleName);
        boolean valid = ArtifactEdit.isValidEditableModule((IVirtualComponent)component);
        EJBArtifactEditTest.assertTrue((boolean)valid);
    }

    public ArtifactEditModel getArtifactEditModelforRead() {
        EMFWorkbenchContext context = new EMFWorkbenchContext(this.ejbProject);
        return new ArtifactEditModel(this.toString(), context, true, TestWorkspace.APP_CLIENT_MODULE_URI);
    }

    public EnterpriseArtifactEdit getArtifactEditForRead() {
        return new EJBArtifactEdit(this.getArtifactEditModelforRead());
    }

    public void pass() {
        EJBArtifactEditTest.assertTrue((boolean)true);
    }
}

