/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jst.jee.model.internal.common.ManyToOneRelation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyToOneRelationTest
extends TestCase {
    private ManyToOneRelation<String, Integer> fixture;

    private ManyToOneRelation<String, Integer> getFixture() {
        return this.fixture;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ManyToOneRelationTest.class);
        return suite;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.fixture = new ManyToOneRelation();
    }

    public void testGetTarget() {
        this.getFixture().connect((Object)"str1", (Object)new Integer(1));
        ManyToOneRelationTest.assertEquals((Object)new Integer(1), (Object)this.getFixture().getTarget((Object)"str1"));
    }

    public void testConnectToNewTarget() {
        this.getFixture().connect((Object)"str1", (Object)new Integer(1));
        this.getFixture().connect((Object)"str1", (Object)new Integer(2));
        ManyToOneRelationTest.assertFalse((boolean)this.getFixture().containsTarget((Object)new Integer(1)));
        ManyToOneRelationTest.assertTrue((boolean)this.getFixture().containsTarget((Object)new Integer(2)));
    }

    public void testGetSources() {
        this.getFixture().connect((Object)"str1", (Object)new Integer(1));
        this.getFixture().connect((Object)"str2", (Object)new Integer(1));
        ManyToOneRelationTest.assertTrue((boolean)this.getFixture().getSources((Object)new Integer(1)).contains("str1"));
        ManyToOneRelationTest.assertTrue((boolean)this.getFixture().getSources((Object)new Integer(1)).contains("str2"));
    }

    public void testGetFilesManyFiles() {
        this.getFixture().connect((Object)"str1", (Object)new Integer(1));
        this.getFixture().connect((Object)"str2", (Object)new Integer(2));
        ManyToOneRelationTest.assertTrue((boolean)this.getFixture().getSources((Object)new Integer(1)).contains("str1"));
        ManyToOneRelationTest.assertTrue((boolean)this.getFixture().getSources((Object)new Integer(2)).contains("str2"));
    }

    public void testGetModelObjectManyFiles() {
        this.getFixture().connect((Object)"str1", (Object)new Integer(1));
        this.getFixture().connect((Object)"str2", (Object)new Integer(1));
        ManyToOneRelationTest.assertEquals((Object)new Integer(1), (Object)this.getFixture().getTarget((Object)"str1"));
        ManyToOneRelationTest.assertEquals((Object)new Integer(1), (Object)this.getFixture().getTarget((Object)"str2"));
    }

    public void testContainsFile() {
        this.getFixture().connect((Object)"str1", (Object)new Integer(1));
        this.getFixture().connect((Object)"str2", (Object)new Integer(2));
        ManyToOneRelationTest.assertTrue((boolean)this.getFixture().containsSource((Object)"str1"));
        ManyToOneRelationTest.assertTrue((boolean)this.getFixture().containsSource((Object)"str2"));
        ManyToOneRelationTest.assertFalse((boolean)this.getFixture().containsSource(null));
    }

    public void testTwoFilesTwoObjects() {
        this.getFixture().connect((Object)"str1", (Object)new Integer(1));
        this.getFixture().connect((Object)"str2", (Object)new Integer(2));
        ManyToOneRelationTest.assertEquals((Object)new Integer(1), (Object)this.getFixture().getTarget((Object)"str1"));
        ManyToOneRelationTest.assertEquals((Object)new Integer(2), (Object)this.getFixture().getTarget((Object)"str2"));
        ManyToOneRelationTest.assertTrue((boolean)this.getFixture().containsTarget((Object)new Integer(1)));
        ManyToOneRelationTest.assertTrue((boolean)this.getFixture().containsTarget((Object)new Integer(2)));
    }

    public void testDisconnectFile() {
        this.getFixture().connect((Object)"str1", (Object)new Integer(1));
        this.getFixture().connect((Object)"str2", (Object)new Integer(1));
        ManyToOneRelationTest.assertEquals((Object)new Integer(1), (Object)this.getFixture().getTarget((Object)"str1"));
        ManyToOneRelationTest.assertEquals((Object)new Integer(1), (Object)this.getFixture().getTarget((Object)"str2"));
        this.getFixture().disconnectSource((Object)"str1");
        ManyToOneRelationTest.assertFalse((boolean)this.getFixture().containsSource((Object)"str1"));
        ManyToOneRelationTest.assertNull((Object)this.getFixture().getTarget((Object)"str1"));
        ManyToOneRelationTest.assertEquals((Object)new Integer(1), (Object)new Integer(this.getFixture().getSources((Object)new Integer(1)).size()));
        ManyToOneRelationTest.assertTrue((boolean)this.getFixture().getSources((Object)new Integer(1)).contains("str2"));
    }

    public void testDisconnectModelObject() {
        this.getFixture().connect((Object)"str1", (Object)new Integer(1));
        this.getFixture().connect((Object)"str11", (Object)new Integer(1));
        this.getFixture().connect((Object)"str2", (Object)new Integer(2));
        ManyToOneRelationTest.assertEquals((Object)new Integer(1), (Object)new Integer(this.getFixture().getSources((Object)new Integer(2)).size()));
        ManyToOneRelationTest.assertEquals((Object)new Integer(2), (Object)new Integer(this.getFixture().getSources((Object)new Integer(1)).size()));
        this.getFixture().disconnect((Object)new Integer(1));
        ManyToOneRelationTest.assertFalse((boolean)this.getFixture().containsTarget((Object)new Integer(1)));
        ManyToOneRelationTest.assertFalse((boolean)this.getFixture().containsSource((Object)"str1"));
        ManyToOneRelationTest.assertFalse((boolean)this.getFixture().containsSource((Object)"str11"));
        ManyToOneRelationTest.assertTrue((boolean)this.getFixture().containsSource((Object)"str2"));
        ManyToOneRelationTest.assertTrue((boolean)this.getFixture().containsTarget((Object)new Integer(2)));
    }
}

