/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.headless.tests.savestrategy;

import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.etools.common.test.apitools.ProjectUnzipUtil;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentSaveStrategyImpl;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;

public abstract class SaveStrategyTest
extends TestCase {
    public static String fileSep = System.getProperty("file.separator");
    protected String projectName = this.getProjectName();
    protected IProject project;
    protected IVirtualComponent vComp;

    public void setUp() {
        try {
            ProjectUtility.deleteAllProjects();
            this.project = null;
            if (this.createProject()) {
                this.project = ProjectUtilities.getProject((String)this.projectName);
            }
            this.vComp = ComponentCore.createComponent((IProject)this.project);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean createProject() {
        IPath localZipPath = this.getFlexProjectSeed();
        ProjectUnzipUtil util = new ProjectUnzipUtil(localZipPath, new String[]{this.projectName});
        return util.createProjects();
    }

    private IPath getFlexProjectSeed() {
        String file = "TestData" + fileSep + "SaveStrategyTests" + fileSep + this.getFlexProjectSeedName();
        Path zipFilePath = new Path(file);
        URL url = HeadlessTestsPlugin.getDefault().find((IPath)zipFilePath);
        try {
            url = Platform.asLocalURL((URL)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Path(url.getPath());
    }

    protected void importArchive(String archiveName) throws Exception {
        String uri = this.getUri(archiveName);
        Archive moduleFile = null;
        try {
            moduleFile = this.openModuleFile(this.getArchiveOptions(), uri);
            ComponentSaveStrategyImpl aStrategy = this.createSaveStrategy(this.vComp);
            aStrategy.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            moduleFile.save((SaveStrategy)aStrategy);
        }
        finally {
            if (moduleFile != null) {
                moduleFile.close();
            }
        }
    }

    protected abstract ComponentSaveStrategyImpl createSaveStrategy(IVirtualComponent var1);

    protected abstract Archive openModuleFile(ArchiveOptions var1, String var2) throws OpenFailureException;

    protected String getUri(String warName) {
        String file = String.valueOf(this.getRootArchiveFolderName()) + fileSep + warName;
        String uri = SaveStrategyTest.getFullTestDataPath(file);
        return uri;
    }

    protected static String getFullTestDataPath(String dataPath) {
        try {
            return ProjectUtility.getFullFileName((Plugin)HeadlessTestsPlugin.getDefault(), (String)dataPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    protected final ArchiveOptions getArchiveOptions() {
        ArchiveOptions opts = new ArchiveOptions();
        opts.setIsReadOnly(true);
        return opts;
    }

    public abstract String getProjectName();

    public abstract String getFlexProjectSeedName();

    public abstract String getRootArchiveFolderName();
}

