/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class JSPTranslatorPersister
implements IResourceChangeListener {
    public static final boolean ACTIVATED = Boolean.valueOf(System.getProperty("persistJSPTranslations", "true"));
    private static final IPath PERSIST_LOCATION = JSPCorePlugin.getDefault().getStateLocation().append("translators");
    private static final CRC32 CHECKSUM_CALC = new CRC32();
    private static final JSPTranslatorPersister INSTANCE = new JSPTranslatorPersister();
    private IResourceDeltaVisitor fResourceDeltaVisitor = new JSPResourceVisitor();
    protected PersisterJob fPersisterJob = new PersisterJob();
    static /* synthetic */ Class class$0;

    private JSPTranslatorPersister() {
    }

    public static JSPTranslatorPersister getDefault() {
        return ACTIVATED ? INSTANCE : null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 2: 
            case 4: {
                this.fPersisterJob.stop();
                break;
            }
            case 1: {
                this.fPersisterJob.start();
                IResourceDelta delta = event.getDelta();
                if (delta == null || !delta.getFullPath().toString().equals("/")) break;
                try {
                    delta.accept(this.fResourceDeltaVisitor, false);
                    break;
                }
                catch (CoreException e) {
                    Logger.logException("Processing resource change event delta failed, persisted JSPTranslators may not have been updated.", e);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static JSPTranslator getPersistedTranslator(IStructuredModel model) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [6 : 195->198)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static String getPersistedTranslatorFilePath(String jspFilePath) {
        CHECKSUM_CALC.reset();
        CHECKSUM_CALC.update(jspFilePath.getBytes());
        String persistedTranslatorFileName = String.valueOf(Long.toString(CHECKSUM_CALC.getValue())) + ".translator";
        IPath location = PERSIST_LOCATION;
        File folder = new File(location.toOSString());
        if (!folder.isDirectory()) {
            try {
                folder.mkdir();
            }
            catch (SecurityException securityException) {}
        }
        location = location.addTrailingSeparator();
        location = location.append(persistedTranslatorFileName);
        return location.toOSString();
    }

    private class JSPResourceVisitor
    implements IResourceDeltaVisitor {
        protected JSPResourceVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this.isJSPResource(delta.getResource())) {
                switch (delta.getKind()) {
                    case 1: 
                    case 4: {
                        if ((delta.getFlags() & 0x1000) != 0) {
                            File from = this.getPersistedFile(delta.getMovedFromPath());
                            File to = this.getPersistedFile(delta.getFullPath());
                            JSPTranslatorPersister.this.fPersisterJob.addAction(new ISafeRunnable(this, from, to){
                                final /* synthetic */ JSPResourceVisitor this$1;
                                private final /* synthetic */ File val$from;
                                private final /* synthetic */ File val$to;
                                {
                                    this.this$1 = jSPResourceVisitor;
                                    this.val$from = file;
                                    this.val$to = file2;
                                }

                                public void run() throws Exception {
                                    this.this$1.renamePersistedTranslator(this.val$from, this.val$to);
                                }

                                public void handleException(Throwable exception) {
                                }
                            });
                            break;
                        }
                        String filePath = JSPTranslatorPersister.getPersistedTranslatorFilePath(delta.getFullPath().toPortableString());
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getFullPath());
                        JSPTranslatorPersister.this.fPersisterJob.addAction(new ISafeRunnable(this, file, filePath){
                            final /* synthetic */ JSPResourceVisitor this$1;
                            private final /* synthetic */ IFile val$file;
                            private final /* synthetic */ String val$filePath;
                            {
                                this.this$1 = jSPResourceVisitor;
                                this.val$file = iFile;
                                this.val$filePath = string;
                            }

                            public void run() throws Exception {
                                JSPTranslator translator = this.this$1.getJSPTranslator(this.val$file);
                                if (translator != null) {
                                    this.this$1.persistTranslator(translator, this.val$filePath);
                                }
                            }

                            public void handleException(Throwable exception) {
                            }
                        });
                        break;
                    }
                    case 2: {
                        if ((delta.getFlags() & 0x2000) != 0) break;
                        File file = this.getPersistedFile(delta.getFullPath());
                        JSPTranslatorPersister.this.fPersisterJob.addAction(new ISafeRunnable(this, file){
                            final /* synthetic */ JSPResourceVisitor this$1;
                            private final /* synthetic */ File val$file;
                            {
                                this.this$1 = jSPResourceVisitor;
                                this.val$file = file;
                            }

                            public void run() throws Exception {
                                this.this$1.deletePersistedTranslator(this.val$file);
                            }

                            public void handleException(Throwable exception) {
                            }
                        });
                    }
                }
            }
            return true;
        }

        private boolean isJSPResource(IResource resource) {
            IFile file;
            boolean isJSP = false;
            if (resource.getFullPath().segmentCount() >= 2 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(resource.getFullPath())).getType() == 1) {
                IContentType contentTypeJSP = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSP);
                isJSP = contentTypeJSP.isAssociatedWith(file.getName());
            }
            return isJSP;
        }

        /*
         * Exception decompiling
         */
        protected JSPTranslator getJSPTranslator(IFile jspFile) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 199->202)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void persistTranslator(JSPTranslator translator, String filePath) {
            try {
                FileOutputStream fos = new FileOutputStream(filePath);
                ObjectOutputStream out = new ObjectOutputStream(fos);
                out.writeObject(translator);
                out.close();
            }
            catch (IOException e) {
                Logger.logException("Was unable to externalize JSPTranslator " + translator + " to " + filePath, e);
            }
        }

        protected void deletePersistedTranslator(File file) {
            file.delete();
        }

        protected void renamePersistedTranslator(File from, File to) {
            from.renameTo(to);
        }

        private File getPersistedFile(IPath path) {
            return new File(JSPTranslatorPersister.getPersistedTranslatorFilePath(path.toPortableString()));
        }
    }

    private class PersisterJob
    extends Job {
        private static final int DELAY = 500;
        private LinkedList fActions;
        private boolean fIsStopped;

        protected PersisterJob() {
            super(JSPCoreMessages.Persisting_JSP_Translations);
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(30);
            this.fActions = new LinkedList();
            this.fIsStopped = false;
        }

        protected synchronized void start() {
            this.fIsStopped = false;
            if (this.getState() == 1) {
                this.wakeUp(500L);
            } else {
                this.schedule(500L);
            }
        }

        protected synchronized void stop() {
            this.sleep();
            this.fIsStopped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addAction(ISafeRunnable action) {
            LinkedList linkedList = this.fActions;
            synchronized (linkedList) {
                this.fActions.addLast(action);
            }
            if (!this.fIsStopped) {
                this.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (!(this.fIsStopped || monitor.isCanceled() || this.fActions.isEmpty())) {
                ISafeRunnable action;
                LinkedList linkedList = this.fActions;
                synchronized (linkedList) {
                    action = (ISafeRunnable)this.fActions.removeFirst();
                }
                SafeRunner.run((ISafeRunnable)action);
            }
            return Status.OK_STATUS;
        }
    }
}

