/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.PatternStrings;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.PatternQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public class JavaSearchPage
extends DialogPage
implements ISearchPage {
    private static final int TYPE = 0;
    private static final int METHOD = 1;
    private static final int CONSTRUCTOR = 3;
    private static final int FIELD = 4;
    private static final int VAR = 12;
    private static final int FUNCTION = 13;
    private static final int DECLARATIONS = 0;
    private static final int REFERENCES = 2;
    private static final int ALL_OCCURRENCES = 3;
    private static final int READ_ACCESSES = 4;
    private static final int WRITE_ACCESSES = 5;
    public static final String PARTICIPANT_EXTENSION_POINT = "org.eclipse.wst.jsdt.ui.queryParticipants";
    public static final String EXTENSION_POINT_ID = "org.eclipse.wst.jsdt.ui.JavaSearchPage";
    private static final int HISTORY_SIZE = 12;
    private static final String PAGE_NAME = "JavaSearchPage";
    private static final String STORE_CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String STORE_INCLUDE_MASK = "INCLUDE_MASK";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private final List fPreviousSearchPatterns = new ArrayList();
    private SearchPatternData fInitialData;
    private IJavaScriptElement fJavaElement;
    private boolean fFirstTime = true;
    private IDialogSettings fDialogSettings;
    private boolean fIsCaseSensitive;
    private Combo fPattern;
    private ISearchPageContainer fContainer;
    private Button fCaseSensitive;
    private Button[] fSearchFor;
    private Button[] fLimitTo;
    private Button[] fIncludeMasks;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public boolean performAction() {
        return this.performNewSearch();
    }

    private boolean performNewSearch() {
        SearchPatternData data = this.getPatternData();
        IJavaScriptSearchScope scope = null;
        String scopeDescription = "";
        int searchFor = data.getSearchFor();
        int limitTo = data.getLimitTo();
        int includeMask = data.getIncludeMask();
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                scopeDescription = factory.getWorkspaceScopeDescription(includeMask);
                scope = factory.createWorkspaceScope(includeMask);
                break;
            }
            case 1: {
                IJavaScriptElement[] javaElements = factory.getJavaElements(this.getContainer().getSelection());
                scope = factory.createJavaSearchScope(javaElements, includeMask);
                scopeDescription = factory.getSelectionScopeDescription(javaElements, includeMask);
                break;
            }
            case 3: {
                String[] projectNames = this.getContainer().getSelectedProjectNames();
                scope = factory.createJavaProjectSearchScope(projectNames, includeMask);
                scopeDescription = factory.getProjectScopeDescription(projectNames, includeMask);
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                if (workingSets == null || workingSets.length < 1) {
                    return false;
                }
                scopeDescription = factory.getWorkingSetScopeDescription(workingSets, includeMask);
                scope = factory.createJavaSearchScope(workingSets, includeMask);
                SearchUtil.updateLRUWorkingSets(workingSets);
            }
        }
        QuerySpecification querySpec = null;
        if (data.getJavaElement() != null && this.getPattern().equals(this.fInitialData.getPattern())) {
            if (limitTo == 2) {
                SearchUtil.warnIfBinaryConstant(data.getJavaElement(), this.getShell());
            }
            querySpec = new ElementQuerySpecification(data.getJavaElement(), limitTo, scope, scopeDescription);
        } else {
            querySpec = new PatternQuerySpecification(data.getPattern(), searchFor, data.isCaseSensitive(), data.getLimitTo(), scope, scopeDescription);
            data.setJavaElement(null);
        }
        JavaSearchQuery textSearchJob = new JavaSearchQuery(querySpec);
        NewSearchUI.runQueryInBackground((ISearchQuery)textSearchJob);
        return true;
    }

    private int getLimitTo() {
        int i = 0;
        while (i < this.fLimitTo.length) {
            Button button = this.fLimitTo[i];
            if (button.getSelection()) {
                return this.getIntData(button);
            }
            ++i;
        }
        return -1;
    }

    private int setLimitTo(int searchFor, int limitTo) {
        if (searchFor != 4 && searchFor != 12 && (limitTo == 4 || limitTo == 5)) {
            limitTo = 2;
        }
        int i = 0;
        while (i < this.fLimitTo.length) {
            Button button;
            int val = this.getIntData(button = this.fLimitTo[i]);
            button.setSelection(limitTo == val);
            switch (val) {
                case 0: 
                case 2: 
                case 3: {
                    button.setEnabled(true);
                    break;
                }
                case 4: 
                case 5: {
                    button.setEnabled(searchFor == 4 || searchFor == 12);
                }
            }
            ++i;
        }
        return limitTo;
    }

    private int getIncludeMask() {
        int mask = 0;
        int i = 0;
        while (i < this.fIncludeMasks.length) {
            Button button = this.fIncludeMasks[i];
            if (button.getSelection()) {
                mask |= this.getIntData(button);
            }
            ++i;
        }
        return mask;
    }

    private void setIncludeMask(int includeMask, int limitTo) {
        int i = 0;
        while (i < this.fIncludeMasks.length) {
            Button button;
            button.setSelection((includeMask & this.getIntData(button = this.fIncludeMasks[i])) != 0);
            ++i;
        }
    }

    private String[] getPreviousSearchPatterns() {
        int patternCount = this.fPreviousSearchPatterns.size();
        String[] patterns = new String[patternCount];
        int i = 0;
        while (i < patternCount) {
            patterns[i] = ((SearchPatternData)this.fPreviousSearchPatterns.get(i)).getPattern();
            ++i;
        }
        return patterns;
    }

    private int getSearchFor() {
        int i = 0;
        while (i < this.fSearchFor.length) {
            Button button = this.fSearchFor[i];
            if (button.getSelection()) {
                return this.getIntData(button);
            }
            ++i;
        }
        Assert.isTrue((boolean)false, (String)"shouldNeverHappen");
        return -1;
    }

    private void setSearchFor(int searchFor) {
        int i = 0;
        while (i < this.fSearchFor.length) {
            Button button;
            button.setSelection(searchFor == this.getIntData(button = this.fSearchFor[i]));
            ++i;
        }
    }

    private int getIntData(Button button) {
        return (Integer)button.getData();
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    private SearchPatternData findInPrevious(String pattern) {
        Iterator iter = this.fPreviousSearchPatterns.iterator();
        while (iter.hasNext()) {
            SearchPatternData element = (SearchPatternData)iter.next();
            if (!pattern.equals(element.getPattern())) continue;
            return element;
        }
        return null;
    }

    private SearchPatternData getPatternData() {
        String pattern = this.getPattern();
        SearchPatternData match = this.findInPrevious(pattern);
        if (match != null) {
            this.fPreviousSearchPatterns.remove(match);
        }
        match = new SearchPatternData(this.getSearchFor(), this.getLimitTo(), pattern, this.fCaseSensitive.getSelection(), this.fJavaElement, this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets(), this.getIncludeMask());
        this.fPreviousSearchPatterns.add(0, match);
        return match;
    }

    public void setVisible(boolean visible) {
        if (visible && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                this.initSelections();
            }
            this.fPattern.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    public boolean isValid() {
        return true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        Control expressionComposite = this.createExpression(result);
        expressionComposite.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label separator = new Label(result, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        Control searchFor = this.createSearchFor(result);
        searchFor.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Control limitTo = this.createLimitTo(result);
        limitTo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Control includeMask = this.createIncludeMask(result);
        includeMask.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        SelectionAdapter javaElementInitializer = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (JavaSearchPage.this.getSearchFor() == JavaSearchPage.this.fInitialData.getSearchFor()) {
                    JavaSearchPage.this.fJavaElement = JavaSearchPage.this.fInitialData.getJavaElement();
                } else {
                    JavaSearchPage.this.fJavaElement = null;
                }
                int limitToVal = JavaSearchPage.this.setLimitTo(JavaSearchPage.this.getSearchFor(), JavaSearchPage.this.getLimitTo());
                JavaSearchPage.this.setIncludeMask(JavaSearchPage.this.getIncludeMask(), limitToVal);
                JavaSearchPage.this.doPatternModified();
            }
        };
        int i = 0;
        while (i < this.fSearchFor.length) {
            this.fSearchFor[i].addSelectionListener((SelectionListener)javaElementInitializer);
            ++i;
        }
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)result, "org.eclipse.wst.jsdt.ui.java_search_page_context");
    }

    private Control createExpression(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 16384);
        label.setText(SearchMessages.SearchPage_expression_label);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.fPattern = new Combo(result, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaSearchPage.this.handlePatternSelected();
                JavaSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaSearchPage.this.doPatternModified();
                JavaSearchPage.this.updateOKStatus();
            }
        });
        TextFieldNavigationHandler.install(this.fPattern);
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPattern.setLayoutData((Object)data);
        this.fCaseSensitive = new Button(result, 32);
        this.fCaseSensitive.setText(SearchMessages.SearchPage_expression_caseSensitive);
        this.fCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaSearchPage.this.fIsCaseSensitive = JavaSearchPage.this.fCaseSensitive.getSelection();
            }
        });
        this.fCaseSensitive.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return result;
    }

    final void updateOKStatus() {
        boolean isValid = this.isValidSearchPattern();
        this.getContainer().setPerformActionEnabled(isValid);
    }

    private boolean isValidSearchPattern() {
        if (this.getPattern().length() == 0) {
            return false;
        }
        if (this.fJavaElement != null) {
            return true;
        }
        return SearchPattern.createPattern((String)this.getPattern(), (int)this.getSearchFor(), (int)this.getLimitTo(), (int)0) != null;
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private void doPatternModified() {
        if (this.fInitialData != null && this.getPattern().equals(this.fInitialData.getPattern()) && this.fInitialData.getJavaElement() != null && this.fInitialData.getSearchFor() == this.getSearchFor()) {
            this.fCaseSensitive.setEnabled(false);
            this.fCaseSensitive.setSelection(true);
            this.fJavaElement = this.fInitialData.getJavaElement();
        } else {
            this.fCaseSensitive.setEnabled(true);
            this.fCaseSensitive.setSelection(this.fIsCaseSensitive);
            this.fJavaElement = null;
        }
    }

    private void handlePatternSelected() {
        int selectionIndex = this.fPattern.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.fPreviousSearchPatterns.size()) {
            return;
        }
        SearchPatternData initialData = (SearchPatternData)this.fPreviousSearchPatterns.get(selectionIndex);
        this.setSearchFor(initialData.getSearchFor());
        int limitToVal = this.setLimitTo(initialData.getSearchFor(), initialData.getLimitTo());
        this.setIncludeMask(initialData.getIncludeMask(), limitToVal);
        this.fPattern.setText(initialData.getPattern());
        this.fIsCaseSensitive = initialData.isCaseSensitive();
        this.fJavaElement = initialData.getJavaElement();
        this.fCaseSensitive.setEnabled(this.fJavaElement == null);
        this.fCaseSensitive.setSelection(initialData.isCaseSensitive());
        if (initialData.getWorkingSets() != null) {
            this.getContainer().setSelectedWorkingSets(initialData.getWorkingSets());
        } else {
            this.getContainer().setSelectedScope(initialData.getScope());
        }
        this.fInitialData = initialData;
    }

    private Control createSearchFor(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(SearchMessages.SearchPage_searchFor_label);
        result.setLayout((Layout)new GridLayout(2, true));
        this.fSearchFor = new Button[]{this.createButton((Composite)result, 16, SearchMessages.SearchPage_searchFor_function, 13, true), this.createButton((Composite)result, 16, SearchMessages.SearchPage_searchFor_var, 12, false), this.createButton((Composite)result, 16, SearchMessages.SearchPage_searchFor_method, 1, false), this.createButton((Composite)result, 16, SearchMessages.SearchPage_searchFor_field, 4, false), this.createButton((Composite)result, 16, SearchMessages.SearchPage_searchFor_type, 0, false), this.createButton((Composite)result, 16, SearchMessages.SearchPage_searchFor_constructor, 3, false)};
        Label filler = new Label((Composite)result, 0);
        filler.setVisible(false);
        filler.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return result;
    }

    private Control createLimitTo(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(SearchMessages.SearchPage_limitTo_label);
        result.setLayout((Layout)new GridLayout(2, true));
        this.fLimitTo = new Button[]{this.createButton((Composite)result, 16, SearchMessages.SearchPage_limitTo_declarations, 0, false), this.createButton((Composite)result, 16, SearchMessages.SearchPage_limitTo_references, 2, true), this.createButton((Composite)result, 16, SearchMessages.SearchPage_limitTo_allOccurrences, 3, false), this.createButton((Composite)result, 16, SearchMessages.SearchPage_limitTo_readReferences, 4, false), this.createButton((Composite)result, 16, SearchMessages.SearchPage_limitTo_writeReferences, 5, false)};
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaSearchPage.this.updateUseJRE();
            }
        };
        int i = 0;
        while (i < this.fLimitTo.length) {
            this.fLimitTo[i].addSelectionListener((SelectionListener)listener);
            ++i;
        }
        return result;
    }

    private Control createIncludeMask(Composite parent) {
        Group result = new Group(parent, 0);
        result.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        result.setText(SearchMessages.SearchPage_searchIn_label);
        result.setLayout((Layout)new GridLayout(4, false));
        this.fIncludeMasks = new Button[]{this.createButton((Composite)result, 32, SearchMessages.SearchPage_searchIn_sources, 1, true), this.createButton((Composite)result, 32, SearchMessages.SearchPage_searchIn_projects, 8, true), this.createButton((Composite)result, 32, SearchMessages.SearchPage_searchIn_jre, 4, false), this.createButton((Composite)result, 32, SearchMessages.SearchPage_searchIn_libraries, 2, true)};
        return result;
    }

    private Button createButton(Composite parent, int style, String text, int data, boolean isSelected) {
        Button button = new Button(parent, style);
        button.setText(text);
        button.setData((Object)new Integer(data));
        button.setLayoutData((Object)new GridData());
        button.setSelection(isSelected);
        return button;
    }

    private void initSelections() {
        ISelection sel = this.getContainer().getSelection();
        SearchPatternData initData = null;
        if (sel instanceof IStructuredSelection) {
            initData = this.tryStructuredSelection((IStructuredSelection)sel);
        } else if (sel instanceof ITextSelection) {
            IEditorPart activePart = this.getActiveEditor();
            if (activePart instanceof JavaEditor) {
                try {
                    IJavaScriptElement[] elements = SelectionConverter.codeResolve((JavaEditor)activePart);
                    if (elements != null && elements.length > 0) {
                        initData = this.determineInitValuesFrom(elements[0]);
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
            if (initData == null) {
                initData = this.trySimpleTextSelection((ITextSelection)sel);
            }
        }
        if (initData == null) {
            initData = this.getDefaultInitValues();
        }
        this.fInitialData = initData;
        this.fJavaElement = initData.getJavaElement();
        this.fCaseSensitive.setSelection(initData.isCaseSensitive());
        this.fCaseSensitive.setEnabled(this.fJavaElement == null);
        this.setSearchFor(initData.getSearchFor());
        int limitToVal = this.setLimitTo(initData.getSearchFor(), initData.getLimitTo());
        this.setIncludeMask(initData.getIncludeMask(), limitToVal);
        this.fPattern.setText(initData.getPattern());
    }

    private void updateUseJRE() {
        this.setIncludeMask(this.getIncludeMask(), this.getLimitTo());
    }

    private static boolean forceIncludeAll(int limitTo, IJavaScriptElement elem) {
        return elem != null && limitTo == 0;
    }

    private SearchPatternData tryStructuredSelection(IStructuredSelection selection) {
        if (selection == null || selection.size() > 1) {
            return null;
        }
        Object o = selection.getFirstElement();
        SearchPatternData res = null;
        if (o instanceof IJavaScriptElement) {
            res = this.determineInitValuesFrom((IJavaScriptElement)o);
        } else if (o instanceof IAdaptable) {
            IJavaScriptElement element;
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaScriptElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((element = (IJavaScriptElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                res = this.determineInitValuesFrom(element);
            }
        }
        if (res == null && o instanceof IAdaptable) {
            IWorkbenchAdapter adapter;
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return new SearchPatternData(12, 2, this.fIsCaseSensitive, adapter.getLabel(o), null, this.getLastIncludeMask());
            }
        }
        return res;
    }

    static final boolean isSearchableType(IJavaScriptElement element) {
        switch (element.getElementType()) {
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private SearchPatternData determineInitValuesFrom(IJavaScriptElement element) {
        block12: {
            try {
                int includeMask = this.getLastIncludeMask();
                switch (element.getElementType()) {
                    case 7: {
                        return new SearchPatternData(0, 2, true, PatternStrings.getTypeSignature((IType)element), element, includeMask);
                    }
                    case 5: {
                        IType mainType = ((IJavaScriptUnit)element).findPrimaryType();
                        if (mainType != null) {
                            return new SearchPatternData(0, 2, true, PatternStrings.getTypeSignature(mainType), (IJavaScriptElement)mainType, includeMask);
                        }
                        break;
                    }
                    case 6: {
                        IType mainType = ((IClassFile)element).getType();
                        if (mainType.exists()) {
                            return new SearchPatternData(0, 2, true, PatternStrings.getTypeSignature(mainType), (IJavaScriptElement)mainType, includeMask);
                        }
                        break;
                    }
                    case 8: {
                        IField field = (IField)element;
                        return new SearchPatternData(field.getParent().getElementType() == 7 ? 4 : 12, 2, true, PatternStrings.getFieldSignature(field), element, includeMask);
                    }
                    case 9: {
                        int searchFor;
                        IFunction method = (IFunction)element;
                        int n = searchFor = method.isConstructor() ? 3 : 1;
                        if (method.getParent().getElementType() != 7) {
                            searchFor = 13;
                        }
                        return new SearchPatternData(searchFor, 2, true, PatternStrings.getMethodSignature(method), element, includeMask);
                    }
                }
            }
            catch (JavaScriptModelException e) {
                if (e.isDoesNotExist()) break block12;
                ExceptionHandler.handle((CoreException)((Object)e), SearchMessages.Search_Error_javaElementAccess_title, SearchMessages.Search_Error_javaElementAccess_message);
            }
        }
        return null;
    }

    private SearchPatternData trySimpleTextSelection(ITextSelection selection) {
        String selectedText = selection.getText();
        if (selectedText != null && selectedText.length() > 0) {
            int i = 0;
            while (i < selectedText.length() && !IndentManipulation.isLineDelimiterChar((char)selectedText.charAt(i))) {
                ++i;
            }
            if (i > 0) {
                return new SearchPatternData(0, 2, this.fIsCaseSensitive, selectedText.substring(0, i), null, 15);
            }
        }
        return null;
    }

    private SearchPatternData getDefaultInitValues() {
        if (!this.fPreviousSearchPatterns.isEmpty()) {
            return (SearchPatternData)this.fPreviousSearchPatterns.get(0);
        }
        return new SearchPatternData(0, 2, this.fIsCaseSensitive, "", null, this.getLastIncludeMask());
    }

    private int getLastIncludeMask() {
        try {
            return this.getDialogSettings().getInt(STORE_INCLUDE_MASK);
        }
        catch (NumberFormatException numberFormatException) {
            return 11;
        }
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = JavaScriptPlugin.getActivePage();
        if (activePage != null) {
            return activePage.getActiveEditor();
        }
        return null;
    }

    private IDialogSettings getDialogSettings() {
        if (this.fDialogSettings == null) {
            this.fDialogSettings = JavaScriptPlugin.getDefault().getDialogSettingsSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fIsCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
        try {
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                SearchPatternData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = SearchPatternData.create(histSettings)) != null) {
                    this.fPreviousSearchPatterns.add(data);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
        s.put(STORE_INCLUDE_MASK, this.getIncludeMask());
        int historySize = Math.min(this.fPreviousSearchPatterns.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            SearchPatternData data = (SearchPatternData)this.fPreviousSearchPatterns.get(i);
            data.store(histSettings);
            ++i;
        }
    }

    private static class SearchPatternData {
        private int searchFor;
        private int limitTo;
        private String pattern;
        private boolean isCaseSensitive;
        private IJavaScriptElement javaElement;
        private int includeMask;
        private int scope;
        private IWorkingSet[] workingSets;

        public SearchPatternData(int searchFor, int limitTo, boolean isCaseSensitive, String pattern, IJavaScriptElement element, int includeMask) {
            this(searchFor, limitTo, pattern, isCaseSensitive, element, 0, null, includeMask);
        }

        public SearchPatternData(int searchFor, int limitTo, String pattern, boolean isCaseSensitive, IJavaScriptElement element, int scope, IWorkingSet[] workingSets, int includeMask) {
            this.searchFor = searchFor;
            this.limitTo = limitTo;
            this.pattern = pattern;
            this.isCaseSensitive = isCaseSensitive;
            this.scope = scope;
            this.workingSets = workingSets;
            this.includeMask = includeMask;
            this.setJavaElement(element);
        }

        public void setJavaElement(IJavaScriptElement javaElement) {
            this.javaElement = javaElement;
        }

        public boolean isCaseSensitive() {
            return this.isCaseSensitive;
        }

        public IJavaScriptElement getJavaElement() {
            return this.javaElement;
        }

        public int getLimitTo() {
            return this.limitTo;
        }

        public String getPattern() {
            return this.pattern;
        }

        public int getScope() {
            return this.scope;
        }

        public int getSearchFor() {
            return this.searchFor;
        }

        public IWorkingSet[] getWorkingSets() {
            return this.workingSets;
        }

        public int getIncludeMask() {
            return this.includeMask;
        }

        public void store(IDialogSettings settings) {
            settings.put("searchFor", this.searchFor);
            settings.put("scope", this.scope);
            settings.put("pattern", this.pattern);
            settings.put("limitTo", this.limitTo);
            settings.put("javaElement", this.javaElement != null ? this.javaElement.getHandleIdentifier() : "");
            settings.put("isCaseSensitive", this.isCaseSensitive);
            if (this.workingSets != null) {
                String[] wsIds = new String[this.workingSets.length];
                int i = 0;
                while (i < this.workingSets.length) {
                    wsIds[i] = this.workingSets[i].getName();
                    ++i;
                }
                settings.put("workingSets", wsIds);
            } else {
                settings.put("workingSets", new String[0]);
            }
            settings.put("includeMask", this.includeMask);
        }

        public static SearchPatternData create(IDialogSettings settings) {
            IJavaScriptElement restored;
            String pattern = settings.get("pattern");
            if (pattern.length() == 0) {
                return null;
            }
            IJavaScriptElement elem = null;
            String handleId = settings.get("javaElement");
            if (handleId != null && handleId.length() > 0 && (restored = JavaScriptCore.create((String)handleId)) != null && JavaSearchPage.isSearchableType(restored) && restored.exists()) {
                elem = restored;
            }
            String[] wsIds = settings.getArray("workingSets");
            IWorkingSet[] workingSets = null;
            if (wsIds != null && wsIds.length > 0) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                workingSets = new IWorkingSet[wsIds.length];
                int i = 0;
                while (workingSets != null && i < wsIds.length) {
                    workingSets[i] = workingSetManager.getWorkingSet(wsIds[i]);
                    if (workingSets[i] == null) {
                        workingSets = null;
                    }
                    ++i;
                }
            }
            try {
                int includeMask;
                int searchFor = settings.getInt("searchFor");
                int scope = settings.getInt("scope");
                int limitTo = settings.getInt("limitTo");
                boolean isCaseSensitive = settings.getBoolean("isCaseSensitive");
                if (settings.get("includeMask") != null) {
                    includeMask = settings.getInt("includeMask");
                } else {
                    includeMask = 11;
                    if (settings.get("includeJRE") == null ? JavaSearchPage.forceIncludeAll(limitTo, elem) : settings.getBoolean("includeJRE")) {
                        includeMask = 15;
                    }
                }
                return new SearchPatternData(searchFor, limitTo, pattern, isCaseSensitive, elem, scope, workingSets, includeMask);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }
}

