/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpointParticipant;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLoadBreakpoint;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.StackFrame;
import org.eclipse.wst.jsdt.debug.core.jsdi.ThreadReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.Event;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventSet;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.StepEvent;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.SuspendEvent;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequestManager;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.StepRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.SuspendRequest;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptThread;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptValue;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptExceptionBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptLoadBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.model.IJavaScriptEventListener;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugElement;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptStackFrame;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptValue;
import org.eclipse.wst.jsdt.debug.internal.core.model.ModelMessages;

public class JavaScriptThread
extends JavaScriptDebugElement
implements IJavaScriptThread,
IJavaScriptEventListener {
    static final IStackFrame[] NO_STACK_FRAMES = new IStackFrame[0];
    static final IBreakpoint[] NO_BREAKPOINTS = new IBreakpoint[0];
    private static final int UNKNOWN = 0;
    private static final int SUSPENDED = 1;
    private static final int RUNNING = 2;
    private static final int TERMINATED = 4;
    private static final boolean DEBUG = false;
    private List frames = null;
    private ArrayList breakpoints = new ArrayList(4);
    private int state = 0;
    private final ThreadReference thread;
    private volatile boolean suspending = false;
    private StepHandler pendingstep = null;
    private SuspendRequest suspendreq = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public JavaScriptThread(JavaScriptDebugTarget target, ThreadReference thread) {
        super(target);
        Assert.isNotNull((Object)thread);
        this.thread = thread;
        this.state = thread.isSuspended() ? 1 : 2;
        this.suspendreq = target.getEventRequestManager().createSuspendRequest(this.thread);
        this.suspendreq.setEnabled(true);
        this.addJSDIEventListener(this, this.suspendreq);
    }

    private synchronized String statusText() {
        switch (this.state) {
            case 1: {
                if (this.breakpoints.size() > 0) {
                    try {
                        JavaScriptBreakpoint breakpoint = (JavaScriptBreakpoint)this.breakpoints.get(0);
                        if (breakpoint instanceof JavaScriptLoadBreakpoint) {
                            String name = breakpoint.getScriptPath();
                            if ("".equals(name)) {
                                name = this.getSourceName();
                            }
                            return NLS.bind((String)ModelMessages.JSDIThread_suspended_loading_script, (Object)name);
                        }
                        if (breakpoint instanceof JavaScriptExceptionBreakpoint) {
                            return NLS.bind((String)ModelMessages.JavaScriptThread_suspended_on_exception, (Object)breakpoint.getMarker().getAttribute("org.eclipse.wst.jsdt.debug.core.exception_message"));
                        }
                        if (breakpoint instanceof IJavaScriptLineBreakpoint) {
                            IJavaScriptLineBreakpoint bp = (IJavaScriptLineBreakpoint)((Object)breakpoint);
                            return NLS.bind((String)ModelMessages.breakpoint_at_line_location, (Object[])new String[]{Integer.toString(bp.getLineNumber()), this.getSourceName()});
                        }
                    }
                    catch (CoreException ce) {
                        JavaScriptDebugPlugin.log(ce);
                    }
                }
                return ModelMessages.thread_suspended;
            }
            case 2: {
                if (this.pendingstep != null) {
                    return ModelMessages.thread_stepping;
                }
                return ModelMessages.thread_running;
            }
            case 4: {
                return ModelMessages.thread_terminated;
            }
            case 0: {
                return ModelMessages.thread_zombie;
            }
        }
        return ModelMessages.thread_state_unknown;
    }

    String getSourceName() throws DebugException {
        IJavaScriptStackFrame frame = (IJavaScriptStackFrame)this.getTopStackFrame();
        if (frame != null) {
            return frame.getSourceName();
        }
        return ModelMessages.JavaScriptThread_evaluated_script;
    }

    public synchronized IBreakpoint[] getBreakpoints() {
        if (this.breakpoints.isEmpty()) {
            return NO_BREAKPOINTS;
        }
        return this.breakpoints.toArray(new IBreakpoint[this.breakpoints.size()]);
    }

    public String getName() throws DebugException {
        return NLS.bind((String)ModelMessages.JSDIThread_thread_title, (Object[])new String[]{this.thread.name(), this.statusText()});
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public synchronized IStackFrame[] getStackFrames() throws DebugException {
        if (!this.isSuspended() || !this.thread.isSuspended()) {
            return NO_STACK_FRAMES;
        }
        if (this.frames == null) {
            this.frames = new ArrayList();
            List threadFrames = this.thread.frames();
            Iterator iterator = threadFrames.iterator();
            while (iterator.hasNext()) {
                StackFrame stackFrame = (StackFrame)iterator.next();
                JavaScriptStackFrame jsdiStackFrame = new JavaScriptStackFrame(this, stackFrame);
                this.frames.add(jsdiStackFrame);
            }
        }
        return this.frames.toArray(new IStackFrame[this.frames.size()]);
    }

    private void clearFrames() {
        if (this.frames != null) {
            this.frames.clear();
            this.frames = null;
        }
    }

    private void clearBreakpoints() {
        this.breakpoints.clear();
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] stackFrames = this.getStackFrames();
        if (stackFrames != null && stackFrames.length > 0) {
            return stackFrames[0];
        }
        return null;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public synchronized boolean canResume() {
        return this.state == 1;
    }

    public synchronized boolean canSuspend() {
        return this.state == 2;
    }

    public synchronized boolean isSuspended() {
        return this.state == 1;
    }

    public synchronized void resume() throws DebugException {
        if (this.getDebugTarget().isSuspended()) {
            this.getDebugTarget().resume();
        } else {
            this.resume(true);
        }
    }

    public synchronized void targetResume() {
        this.resume(false);
    }

    private void resume(boolean fireevent) {
        if (this.canResume()) {
            if (this.pendingstep != null) {
                this.pendingstep.abort();
            }
            this.resumeUnderlyingThread();
            this.markResumed();
            if (fireevent) {
                this.fireResumeEvent(32);
            }
        }
    }

    public synchronized void suspend() throws DebugException {
        if (this.canSuspend()) {
            this.suspendUnderlyingThread();
        }
    }

    void resumeUnderlyingThread() {
        try {
            this.thread.resume();
        }
        catch (Exception exception) {
            try {
                this.disconnect();
            }
            catch (DebugException debugException) {}
        }
    }

    void suspendUnderlyingThread() {
        if (this.suspending) {
            return;
        }
        if (this.isSuspended()) {
            this.fireSuspendEvent(32);
            return;
        }
        this.suspending = true;
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        JavaScriptThread.this.thread.suspend();
                        long stop = System.currentTimeMillis() + 30000L;
                        boolean suspended = JavaScriptThread.this.thread.isSuspended();
                        while (System.currentTimeMillis() < stop && !suspended) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                            if (!(suspended = JavaScriptThread.this.thread.isSuspended())) continue;
                        }
                        if (!suspended) {
                            Status status = new Status(4, "org.eclipse.wst.jsdt.debug.core", 100, NLS.bind((String)ModelMessages.thread_timed_out_trying_to_suspend, (Object[])new String[]{new Integer(30000).toString()}), null);
                            JavaScriptDebugPlugin.log((IStatus)status);
                        }
                        JavaScriptThread.this.markSuspended();
                        JavaScriptThread.this.fireSuspendEvent(32);
                    }
                    catch (RuntimeException runtimeException) {}
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    JavaScriptThread.this.suspending = false;
                    throw throwable;
                }
                {
                    Object var5_6 = null;
                }
                JavaScriptThread.this.suspending = false;
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void suspendForException(JavaScriptExceptionBreakpoint breakpoint) {
        this.addBreakpoint(breakpoint);
        this.markSuspended();
        this.fireSuspendEvent(16);
    }

    public boolean suspendForBreakpoint(IJavaScriptBreakpoint breakpoint, boolean vote) {
        IJavaScriptBreakpointParticipant[] participants = JavaScriptDebugPlugin.getParticipantManager().getParticipants(breakpoint);
        int suspend = 0;
        int i = 0;
        while (i < participants.length) {
            suspend |= participants[i].breakpointHit(this, breakpoint);
            ++i;
        }
        if ((suspend & 1) > 0 || suspend == 0) {
            this.addBreakpoint(breakpoint);
            if (this.pendingstep != null) {
                this.pendingstep.abort();
            }
            return true;
        }
        return false;
    }

    public void suspendForBreakpointComplete(IJavaScriptBreakpoint breakpoint, boolean suspend, EventSet eventSet) {
        if (suspend) {
            try {
                if (breakpoint.getSuspendPolicy() == 1) {
                    this.markSuspended();
                } else {
                    this.getDebugTarget().suspend();
                }
                this.fireSuspendEvent(16);
            }
            catch (CoreException ce) {
                JavaScriptDebugPlugin.log(ce);
            }
        }
    }

    public int suspendForScriptLoad(IJavaScriptBreakpoint breakpoint, ScriptReference script, boolean vote) {
        IJavaScriptBreakpointParticipant[] participants = JavaScriptDebugPlugin.getParticipantManager().getParticipants(breakpoint);
        int suspend = 0;
        int i = 0;
        while (i < participants.length) {
            suspend |= participants[i].scriptLoaded(this, script, breakpoint);
            ++i;
        }
        return suspend;
    }

    public void suspendForScriptLoadComplete(IJavaScriptBreakpoint breakpoint, ScriptReference script, boolean suspend, EventSet eventSet) {
        this.suspendForBreakpointComplete(breakpoint, suspend, eventSet);
    }

    public synchronized boolean addBreakpoint(IJavaScriptBreakpoint breakpoint) {
        return this.breakpoints.add(breakpoint);
    }

    public synchronized boolean removeBreakpoint(IJavaScriptBreakpoint breakpoint) {
        return this.breakpoints.remove(breakpoint);
    }

    synchronized void markSuspended() {
        this.state = 1;
    }

    synchronized void markResumed() {
        this.state = 2;
        this.clearFrames();
        this.clearBreakpoints();
    }

    synchronized void markTerminated() {
        this.state = 4;
    }

    public synchronized boolean canStepInto() {
        return this.canStep() || this.atScriptLoadBreakpoint();
    }

    private boolean atScriptLoadBreakpoint() {
        if (this.breakpoints != null && this.breakpoints.size() > 0) {
            return this.breakpoints.get(0) instanceof IJavaScriptLoadBreakpoint;
        }
        return false;
    }

    public synchronized boolean canStepOver() {
        return this.canStep();
    }

    public synchronized boolean canStepReturn() {
        return this.canStep();
    }

    private boolean canStep() {
        try {
            return this.isSuspended() && !this.isStepping() && this.getTopStackFrame() != null;
        }
        catch (DebugException de) {
            JavaScriptDebugPlugin.log(de);
            return false;
        }
    }

    public synchronized boolean isStepping() {
        return this.pendingstep != null;
    }

    public synchronized void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        StepHandler handler = new StepHandler();
        handler.step(1, 1);
    }

    public synchronized void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        StepHandler handler = new StepHandler();
        handler.step(2, 2);
    }

    public synchronized void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        StepHandler handler = new StepHandler();
        handler.step(3, 4);
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public synchronized boolean isTerminated() {
        return this.state == 4;
    }

    public synchronized void terminate() throws DebugException {
        this.state = 4;
        this.getJavaScriptDebugTarget().terminate();
        this.getJavaScriptDebugTarget().getEventRequestManager().deleteEventRequest(this.suspendreq);
        this.removeJSDIEventListener(this, this.suspendreq);
    }

    void terminated() {
        this.markTerminated();
        this.fireTerminateEvent();
    }

    public boolean matches(ThreadReference thread) {
        return this.thread == thread;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.debug.core.model.IThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2 == adapter) {
            return this;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.debug.core.model.IStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3 == adapter) {
            try {
                return this.getTopStackFrame();
            }
            catch (DebugException e) {
                JavaScriptDebugPlugin.log(e);
            }
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.debug.core.model.IJavaScriptThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == adapter) {
            return this;
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4 == adapter) {
            try {
                return this.getTopStackFrame();
            }
            catch (DebugException e) {
                JavaScriptDebugPlugin.log(e);
            }
        }
        return super.getAdapter(adapter);
    }

    public IJavaScriptValue evaluate(String expression) {
        try {
            IStackFrame frame = this.getTopStackFrame();
            if (frame instanceof JavaScriptStackFrame) {
                return new JavaScriptValue(this.getJavaScriptDebugTarget(), ((JavaScriptStackFrame)frame).getUnderlyingStackFrame().evaluate(expression));
            }
        }
        catch (DebugException debugException) {}
        return new JavaScriptValue(this.getJavaScriptDebugTarget(), this.getVM().mirrorOfNull());
    }

    public int getFrameCount() {
        if (this.isSuspended()) {
            return this.thread.frameCount();
        }
        return 0;
    }

    public boolean handleEvent(Event event, JavaScriptDebugTarget target, boolean suspendVote, EventSet eventSet) {
        if (event instanceof SuspendEvent && this.canSuspend()) {
            this.markSuspended();
            this.fireSuspendEvent(2);
            return true;
        }
        return false;
    }

    public void eventSetComplete(Event event, JavaScriptDebugTarget target, boolean suspend, EventSet eventSet) {
    }

    class StepHandler
    implements IJavaScriptEventListener {
        private StepRequest request = null;

        StepHandler() {
        }

        public void step(int kind, int detail) {
            JavaScriptThread.this.pendingstep = this;
            this.request = this.createStepRequest(this, kind);
            JavaScriptThread.this.resumeUnderlyingThread();
            JavaScriptThread.this.markResumed();
            JavaScriptThread.this.fireResumeEvent(detail);
        }

        private StepRequest createStepRequest(IJavaScriptEventListener listener, int step) {
            EventRequestManager requestManager = JavaScriptThread.this.getVM().eventRequestManager();
            StepRequest stepRequest = requestManager.createStepRequest(JavaScriptThread.this.thread, step);
            stepRequest.setEnabled(true);
            JavaScriptThread.this.getJavaScriptDebugTarget().addJSDIEventListener(listener, stepRequest);
            return stepRequest;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void abort() {
            try {
                if (this.request != null) {
                    this.deleteRequest(this, this.request);
                    this.request = null;
                }
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                JavaScriptThread.this.pendingstep = null;
                throw throwable;
            }
            {
                Object var1_3 = null;
            }
            JavaScriptThread.this.pendingstep = null;
        }

        public boolean handleEvent(Event event, JavaScriptDebugTarget target, boolean suspendVote, EventSet eventSet) {
            StepEvent stepEvent = (StepEvent)event;
            return stepEvent.thread() != JavaScriptThread.this.thread;
        }

        public void eventSetComplete(Event event, JavaScriptDebugTarget target, boolean suspend, EventSet eventSet) {
            StepEvent stepEvent = (StepEvent)event;
            this.stepEnd(this, stepEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stepEnd(IJavaScriptEventListener listener, StepEvent event) {
            ThreadReference threadReference = event.thread();
            if (threadReference == JavaScriptThread.this.thread) {
                JavaScriptThread javaScriptThread = JavaScriptThread.this;
                synchronized (javaScriptThread) {
                    JavaScriptThread.this.pendingstep = null;
                    if (this.request == event.request()) {
                        this.deleteRequest(listener, event.request());
                        this.request = null;
                    }
                    JavaScriptThread.this.markSuspended();
                    JavaScriptThread.this.fireSuspendEvent(8);
                }
            }
        }

        private void deleteRequest(IJavaScriptEventListener listener, EventRequest request) {
            JavaScriptThread.this.getJavaScriptDebugTarget().removeJSDIEventListener(listener, request);
            EventRequestManager requestManager = JavaScriptThread.this.getVM().eventRequestManager();
            requestManager.deleteEventRequest(request);
        }
    }
}

