/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.IProblemChangedListener;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;

public class JavaEditorErrorTickUpdater
implements IProblemChangedListener {
    private JavaEditor fJavaEditor;
    private JavaUILabelProvider fLabelProvider;
    static /* synthetic */ Class class$0;

    public JavaEditorErrorTickUpdater(JavaEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fJavaEditor = editor;
        this.fLabelProvider = new JavaUILabelProvider(0L, 2);
        this.fLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        JavaScriptPlugin.getDefault().getProblemMarkerManager().addListener(this);
    }

    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (!isMarkerChange) {
            return;
        }
        IEditorInput input = this.fJavaEditor.getEditorInput();
        if (input != null) {
            IJavaScriptElement jelement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaScriptElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((jelement = (IJavaScriptElement)input.getAdapter((Class)clazz)) != null) {
                IResource resource = jelement.getResource();
                int i = 0;
                while (i < changedResources.length) {
                    if (changedResources[i].equals((Object)resource)) {
                        this.updateEditorImage(jelement);
                    }
                    ++i;
                }
            }
        }
    }

    public void updateEditorImage(IJavaScriptElement jelement) {
        Image titleImage = this.fJavaEditor.getTitleImage();
        if (titleImage == null) {
            return;
        }
        Image newImage = jelement instanceof IJavaScriptUnit && !jelement.getJavaScriptProject().isOnIncludepath(jelement) ? this.fLabelProvider.getImage(jelement.getResource()) : this.fLabelProvider.getImage(jelement);
        if (titleImage != newImage) {
            this.postImageChange(newImage);
        }
    }

    private void postImageChange(final Image newImage) {
        Shell shell = this.fJavaEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    JavaEditorErrorTickUpdater.this.fJavaEditor.updatedTitleImage(newImage);
                }
            });
        }
    }

    public void dispose() {
        this.fLabelProvider.dispose();
        JavaScriptPlugin.getDefault().getProblemMarkerManager().removeListener(this);
    }
}

