/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf;

import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.internal.emf.plugin.EcoreUtilitiesPlugin;
import org.eclipse.wst.common.internal.emf.utilities.ResourceIsLoadingAdapter;

public class ResourceSynchronizedIsLoadingAdapter
extends ResourceIsLoadingAdapter {
    private final ILock loadingLock = Job.getJobManager().newLock();
    private static final long DELAY = 300000L;

    public ResourceSynchronizedIsLoadingAdapter() {
        if (this.loadingLock != null) {
            this.loadingLock.acquire();
        }
    }

    public void waitForResourceToLoad() {
        if (this.loadingLock == null) {
            return;
        }
        boolean lockAcquired = false;
        try {
            try {
                if (this.loadingLock != null && !(lockAcquired = this.loadingLock.acquire(300000L))) {
                    this.logWarning();
                }
            }
            catch (InterruptedException interruptedException) {
                if (lockAcquired) {
                    this.loadingLock.release();
                }
            }
        }
        finally {
            if (lockAcquired) {
                this.loadingLock.release();
            }
        }
    }

    private void logWarning() {
        Notifier target = this.getTarget();
        if (target == null || !(target instanceof Resource)) {
            Resource resource = (Resource)target;
            EcoreUtilitiesPlugin.logError("[WARNING] Could not acquire Semaphore Lock for Resource: \"" + resource.getURI() + "\" in " + ((Object)((Object)this)).getClass());
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification.getNotifier() != null && this.isSetLoadedResourceNotification(notification)) {
            if (this.loadingLock != null) {
                this.loadingLock.release();
            }
            this.removeIsLoadingSupport();
        }
    }

    public void forceRelease() {
        if (this.loadingLock != null && this.loadingLock.getDepth() > 0) {
            this.loadingLock.release();
        }
    }
}

