/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.internal.Base;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingCopyHelper {
    protected Base base;
    protected boolean isDirty;
    private transient List<PropertyChangeListener> propertyListeners;

    public WorkingCopyHelper(Base base) {
        this.base = base;
    }

    public void setAttribute(String attributeName, int value) {
        int current = this.base.getAttribute(attributeName, 0);
        if (this.base.isAttributeSet(attributeName) && current == value) {
            return;
        }
        this.isDirty = true;
        this.base.map.put(attributeName, Integer.toString(value));
        this.firePropertyChangeEvent(attributeName, new Integer(current), new Integer(value));
    }

    public void setAttribute(String attributeName, boolean value) {
        boolean current = this.base.getAttribute(attributeName, false);
        if (this.base.isAttributeSet(attributeName) && current == value) {
            return;
        }
        this.isDirty = true;
        this.base.map.put(attributeName, Boolean.toString(value));
        this.firePropertyChangeEvent(attributeName, new Boolean(current), new Boolean(value));
    }

    public void setAttribute(String attributeName, String value) {
        String current = this.base.getAttribute(attributeName, (String)null);
        if (this.base.isAttributeSet(attributeName) && current != null && current.equals(value)) {
            return;
        }
        this.isDirty = true;
        if (value == null) {
            this.base.map.remove(attributeName);
        } else {
            this.base.map.put(attributeName, value);
        }
        this.firePropertyChangeEvent(attributeName, current, value);
    }

    public void setAttribute(String attributeName, List<String> value) {
        List<String> current = this.base.getAttribute(attributeName, (List<String>)null);
        if (this.base.isAttributeSet(attributeName) && current != null && current.equals(value)) {
            return;
        }
        this.isDirty = true;
        if (value == null) {
            this.base.map.remove(attributeName);
        } else {
            this.base.map.put(attributeName, value);
        }
        this.firePropertyChangeEvent(attributeName, current, value);
    }

    public void setAttribute(String attributeName, Map value) {
        Map current = this.base.getAttribute(attributeName, (Map)null);
        if (this.base.isAttributeSet(attributeName) && current != null && current.equals(value)) {
            return;
        }
        this.isDirty = true;
        if (value == null) {
            this.base.map.remove(attributeName);
        } else {
            this.base.map.put(attributeName, value);
        }
        this.firePropertyChangeEvent(attributeName, current, value);
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public void setLocked(boolean b) {
        this.setAttribute("locked", b);
    }

    public void setPrivate(boolean b) {
        this.setAttribute("private", b);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void validateTimestamp(int timestamp) throws CoreException {
        if (this.base.getTimestamp() != timestamp) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 1, Messages.errorWorkingCopyTimestamp, null));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new ArrayList<PropertyChangeListener>(2);
        }
        this.propertyListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(listener);
        }
    }

    public void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        try {
            Iterator<PropertyChangeListener> iterator = this.propertyListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    PropertyChangeListener listener = iterator.next();
                    listener.propertyChange(event);
                }
                catch (Exception e) {
                    Trace.trace(3, "Error firing property change event", e);
                }
            }
        }
        catch (Exception e) {
            Trace.trace(3, "Error in property event", e);
        }
    }

    protected void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }
}

