/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.PromoteTempToFieldRefactoring;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.PromoteTempWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ConvertLocalToFieldAction
extends SelectionDispatchAction {
    private final JavaEditor fEditor;

    public ConvertLocalToFieldAction(JavaEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.ConvertLocalToField_label);
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.promote_temp_to_field_action");
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isPromoteTempAvailable(selection));
        }
        catch (JavaScriptModelException javaScriptModelException) {
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        try {
            IJavaScriptUnit cunit = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
            PromoteTempToFieldRefactoring refactoring = new PromoteTempToFieldRefactoring(cunit, selection.getOffset(), selection.getLength());
            new RefactoringStarter().activate(refactoring, new PromoteTempWizard(refactoring), this.getShell(), RefactoringMessages.ConvertLocalToField_title, 5);
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.ConvertLocalToField_title, RefactoringMessages.NewTextRefactoringAction_exception);
        }
    }
}

