/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.server.ui.internal.ImageResource;

public class DefaultServerImageDescriptor
extends CompositeImageDescriptor {
    private Image fBaseImage;
    private Point fSize;
    private Image overlay;

    public DefaultServerImageDescriptor(Image baseImage) {
        this(baseImage, ImageResource.getImage("defaultServerOverlay"));
    }

    public DefaultServerImageDescriptor(Image baseImage, Image overlay) {
        this.setBaseImage(baseImage);
        this.overlay = overlay;
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.getBaseImage().getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefaultServerImageDescriptor)) {
            return false;
        }
        DefaultServerImageDescriptor other = (DefaultServerImageDescriptor)((Object)object);
        return this.getBaseImage().equals((Object)other.getBaseImage());
    }

    public int hashCode() {
        return this.getBaseImage().hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getBaseImage().getImageData();
        if (bg == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        ImageData data = this.overlay.getImageData();
        int x = this.getSize().x - data.width;
        this.drawImage(data, x, 0);
    }

    protected Image getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(Image baseImage) {
        this.fBaseImage = baseImage;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

