/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.Comparator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPDatabaseObject;
import org.eclipse.jpt.db.internal.DTPDatabaseObjectWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.utility.internal.iterables.TransformationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DTPSchemaContainerWrapper
extends DTPDatabaseObjectWrapper
implements SchemaContainer {
    private DTPSchemaWrapper[] schemata;

    DTPSchemaContainerWrapper(DTPDatabaseObject parent, Object dtpSchemaContainer) {
        super(parent, dtpSchemaContainer);
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
    }

    abstract List<org.eclipse.datatools.modelbase.sql.schema.Schema> getDTPSchemata();

    abstract DTPSchemaWrapper getSchema(org.eclipse.datatools.modelbase.sql.schema.Schema var1);

    DTPSchemaWrapper getSchema_(org.eclipse.datatools.modelbase.sql.schema.Schema dtpSchema) {
        DTPSchemaWrapper[] dTPSchemaWrapperArray = this.getSchemaArray();
        int n = dTPSchemaWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSchemaWrapper schema = dTPSchemaWrapperArray[n2];
            if (schema.wraps(dtpSchema)) {
                return schema;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid DTP schema: " + dtpSchema);
    }

    abstract DTPTableWrapper getTable(Table var1);

    DTPTableWrapper getTable_(Table dtpTable) {
        return this.getSchema_(dtpTable.getSchema()).getTable_(dtpTable);
    }

    abstract DTPColumnWrapper getColumn(Column var1);

    DTPColumnWrapper getColumn_(Column dtpColumn) {
        return this.getTable_(dtpColumn.getTable()).getColumn_(dtpColumn);
    }

    @Override
    public Iterable<Schema> getSchemata() {
        return new ArrayIterable((Object[])this.getSchemaArray());
    }

    Iterable<DTPSchemaWrapper> getSchemaWrappers() {
        return new ArrayIterable((Object[])this.getSchemaArray());
    }

    synchronized DTPSchemaWrapper[] getSchemaArray() {
        if (this.schemata == null) {
            this.schemata = this.buildSchemaArray();
        }
        return this.schemata;
    }

    private DTPSchemaWrapper[] buildSchemaArray() {
        List<org.eclipse.datatools.modelbase.sql.schema.Schema> dtpSchemata = this.getDTPSchemata();
        Object[] result = new DTPSchemaWrapper[dtpSchemata.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPSchemaWrapper(this, dtpSchemata.get(i));
        }
        return (DTPSchemaWrapper[])ArrayTools.sort((Object[])result, (Comparator)DEFAULT_COMPARATOR);
    }

    @Override
    public int getSchemataSize() {
        return this.getSchemaArray().length;
    }

    @Override
    public Iterable<String> getSortedSchemaNames() {
        return new TransformationIterable(this.getSchemaWrappers(), NAME_TRANSFORMER);
    }

    @Override
    public DTPSchemaWrapper getSchemaNamed(String name) {
        return this.selectDatabaseObjectNamed(this.getSchemaWrappers(), name);
    }

    @Override
    public Iterable<String> getSortedSchemaIdentifiers() {
        return new TransformationIterable(this.getSchemaWrappers(), IDENTIFIER_TRANSFORMER);
    }

    @Override
    public DTPSchemaWrapper getSchemaForIdentifier(String identifier) {
        return this.selectDatabaseObjectForIdentifier(this.getSchemaWrappers(), identifier);
    }

    @Override
    public DTPSchemaWrapper getDefaultSchema() {
        return this.getSchemaForNames(this.getDatabase().getDefaultSchemaNames());
    }

    DTPSchemaWrapper getSchemaForNames(Iterable<String> names) {
        for (String name : names) {
            DTPSchemaWrapper schema = this.getSchemaNamed(name);
            if (schema == null) continue;
            return schema;
        }
        return null;
    }

    @Override
    public synchronized String getDefaultSchemaIdentifier() {
        Iterable<String> names = this.getDatabase().getDefaultSchemaNames();
        DTPSchemaWrapper schema = this.getSchemaForNames(names);
        return schema != null ? schema.getIdentifier() : this.convertNameToIdentifier((String)CollectionTools.last(names));
    }

    @Override
    synchronized void startListening() {
        if (this.schemata != null) {
            this.startSchemata();
        }
        super.startListening();
    }

    private void startSchemata() {
        DTPSchemaWrapper[] dTPSchemaWrapperArray = this.schemata;
        int n = this.schemata.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSchemaWrapper schema = dTPSchemaWrapperArray[n2];
            schema.startListening();
            ++n2;
        }
    }

    @Override
    synchronized void stopListening() {
        if (this.schemata != null) {
            this.stopSchemata();
        }
        super.stopListening();
    }

    private void stopSchemata() {
        DTPSchemaWrapper[] dTPSchemaWrapperArray = this.schemata;
        int n = this.schemata.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSchemaWrapper schema = dTPSchemaWrapperArray[n2];
            schema.stopListening();
            ++n2;
        }
    }

    @Override
    synchronized void clear() {
        if (this.schemata != null) {
            this.clearSchemata();
        }
    }

    private void clearSchemata() {
        this.stopSchemata();
        DTPSchemaWrapper[] dTPSchemaWrapperArray = this.schemata;
        int n = this.schemata.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSchemaWrapper schema = dTPSchemaWrapperArray[n2];
            schema.clear();
            ++n2;
        }
        this.schemata = null;
    }
}

