/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptPreferencesManager;
import org.eclipse.wst.jsdt.debug.internal.core.Messages;
import org.eclipse.wst.jsdt.debug.internal.core.launching.ConnectorsManager;
import org.eclipse.wst.jsdt.debug.internal.core.model.BreakpointParticipantManager;
import org.osgi.framework.BundleContext;

public class JavaScriptDebugPlugin
extends Plugin {
    public static final int INTERNAL_ERROR = 120;
    public static final String PLUGIN_ID = "org.eclipse.wst.jsdt.debug.core";
    private static JavaScriptDebugPlugin plugin;
    private static ConnectorsManager connectionmanager;
    private static BreakpointParticipantManager participantmanager;
    private static JavaScriptPreferencesManager prefmanager;
    private static IProject extSrcProject;
    private static Map externalScriptPaths;

    static {
        connectionmanager = null;
        participantmanager = null;
        prefmanager = null;
        extSrcProject = null;
        externalScriptPaths = new HashMap();
    }

    public static synchronized ConnectorsManager getConnectionsManager() {
        if (connectionmanager == null) {
            connectionmanager = new ConnectorsManager();
        }
        return connectionmanager;
    }

    public static synchronized BreakpointParticipantManager getParticipantManager() {
        if (participantmanager == null) {
            participantmanager = new BreakpointParticipantManager();
        }
        return participantmanager;
    }

    public static synchronized IProject getExternalSourceProject(boolean create) {
        if (extSrcProject == null) {
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(Messages.external_javascript_source);
                if (project.isAccessible()) {
                    extSrcProject = project;
                }
                if (project.exists()) {
                    project.open(null);
                    extSrcProject = project;
                } else if (create) {
                    project.create(null);
                    project.open(null);
                    extSrcProject = project;
                }
            }
            catch (CoreException ce) {
                JavaScriptDebugPlugin.log(ce);
            }
        }
        return extSrcProject;
    }

    public static boolean isExternalSource(IPath path) {
        return path.segment(0).equals(Messages.external_javascript_source);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        prefmanager = new JavaScriptPreferencesManager();
        prefmanager.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            plugin = null;
            if (connectionmanager != null) {
                connectionmanager.dispose();
            }
            if (participantmanager != null) {
                participantmanager.dispose();
            }
            if (prefmanager != null) {
                prefmanager.stop();
            }
            if (extSrcProject != null && extSrcProject.exists()) {
                extSrcProject.delete(true, null);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(context);
    }

    public static JavaScriptDebugPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public static void log(Throwable t) {
        JavaScriptDebugPlugin.log(JavaScriptDebugPlugin.newErrorStatus("Error logged from JSDT Debug Core: ", t));
    }

    public static void logErrorMessage(String message) {
        JavaScriptDebugPlugin.log(JavaScriptDebugPlugin.newErrorStatus("Internal message logged from JavaScript Debug Core: " + message, null));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 120, message, exception);
    }

    public static synchronized void addExternalScriptPath(IPath path, String scriptPath) {
        externalScriptPaths.put(path.makeAbsolute(), scriptPath);
    }

    public static synchronized String getExternalScriptPath(IPath path) {
        return (String)externalScriptPaths.get(path.makeAbsolute());
    }
}

