/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.internal.text.html.HTML2TextReader;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.IServerModule;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.provisional.IServerToolTip;

public class ServerToolTip
extends ToolTip {
    protected Hashtable<String, ArrayList<IServerToolTip>> toolTipProviders = new Hashtable();
    protected static Shell CURRENT_TOOLTIP;
    protected Label hintLabel;
    protected Tree tree;
    protected int x;
    protected int y;

    public ServerToolTip(final Tree tree) {
        super((Control)tree);
        this.tree = tree;
        tree.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                ServerToolTip.this.x = e.x;
                ServerToolTip.this.y = e.y;
            }
        });
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e == null) {
                    return;
                }
                if (e.keyCode == 27) {
                    if (CURRENT_TOOLTIP != null) {
                        CURRENT_TOOLTIP.dispose();
                        CURRENT_TOOLTIP = null;
                    }
                    ServerToolTip.this.activate();
                }
                if (e.keyCode == 0x100000F && CURRENT_TOOLTIP == null) {
                    ServerToolTip.this.deactivate();
                    ServerToolTip.this.hide();
                    ServerToolTip.this.createFocusedTooltip((Control)tree);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.loadExtensions();
    }

    public void createFocusedTooltip(Control control) {
        final Shell stickyTooltip = new Shell(control.getShell(), 540676);
        stickyTooltip.setLayout((Layout)new FillLayout());
        stickyTooltip.setBackground(stickyTooltip.getDisplay().getSystemColor(29));
        control.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Event event = new Event();
                event.x = ServerToolTip.this.x;
                event.y = ServerToolTip.this.y;
                event.widget = ServerToolTip.this.tree;
                ServerToolTip.this.createToolTipContentArea(event, (Composite)stickyTooltip);
                stickyTooltip.pack();
                stickyTooltip.setLocation(stickyTooltip.getDisplay().getCursorLocation());
                ServerToolTip.this.hintLabel.setText(Messages.toolTipDisableFocus);
                stickyTooltip.setVisible(true);
            }
        });
        CURRENT_TOOLTIP = stickyTooltip;
    }

    protected Object getToolTipArea(Event event) {
        TreeItem o = this.tree.getItem(new Point(event.x, event.y));
        return o;
    }

    protected final boolean shouldCreateToolTip(Event event) {
        if (this.tree.getItem(new Point(event.x, event.y)) == null) {
            return false;
        }
        return super.shouldCreateToolTip(event);
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        TreeItem o = this.tree.getItem(new Point(event.x, event.y));
        if (o == null) {
            return null;
        }
        IServer server = null;
        IServerModule module = null;
        if (o instanceof TreeItem) {
            Object obj = o.getData();
            if (obj instanceof IServer) {
                server = (IServer)obj;
            }
            if (obj instanceof IServerModule) {
                module = (IServerModule)obj;
            }
        }
        FillLayout layout = (FillLayout)parent.getLayout();
        layout.type = 512;
        parent.setLayout((Layout)layout);
        parent.setBackground(parent.getDisplay().getSystemColor(29));
        StyledText sText = new StyledText(parent, 0);
        sText.setEditable(false);
        sText.setBackground(parent.getBackground());
        if (module != null) {
            IModule[] modules = module.getModule();
            IModule m = modules[modules.length - 1];
            sText.setText("<b>" + m.getName() + "</b>");
            StyledText sText2 = new StyledText(parent, 0);
            sText2.setEditable(false);
            sText2.setBackground(parent.getBackground());
            sText2.setText(m.getModuleType().getName());
        }
        if (server != null) {
            ArrayList<IServerToolTip> listOfProviders;
            sText.setText("<b>" + server.getName() + "</b>");
            if (server.getServerType() != null && (listOfProviders = this.toolTipProviders.get(server.getServerType().getId())) != null) {
                for (IServerToolTip tipProvider : listOfProviders) {
                    tipProvider.createContent(parent, server);
                }
            }
        }
        this.hintLabel = new Label(parent, 2048);
        this.hintLabel.setAlignment(131072);
        this.hintLabel.setBackground(parent.getDisplay().getSystemColor(29));
        this.hintLabel.setText(Messages.toolTipEnableFocus);
        this.hintLabel.setForeground(parent.getDisplay().getSystemColor(16));
        Display display = parent.getDisplay();
        FontData[] fd = parent.getFont().getFontData();
        int size2 = fd.length;
        int i = 0;
        while (i < size2) {
            fd[i].setHeight(7);
            ++i;
        }
        final Font font = new Font((Device)display, fd);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        this.hintLabel.setFont(font);
        this.parseText(sText.getText(), sText);
        return parent;
    }

    protected void parseText(String htmlText, StyledText sText) {
        String text;
        TextPresentation presentation = new TextPresentation();
        HTML2TextReader reader = new HTML2TextReader((Reader)new StringReader(htmlText), presentation);
        try {
            text = reader.getString();
        }
        catch (IOException iOException) {
            text = "";
        }
        sText.setText(text);
        Iterator iter = presentation.getAllStyleRangeIterator();
        while (iter.hasNext()) {
            StyleRange sr = (StyleRange)iter.next();
            sText.setStyleRange(sr);
        }
    }

    private void loadExtensions() {
        Trace.trace((byte)7, "->- Loading serverToolTip extension point ->-");
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor("org.eclipse.wst.server.ui.serverToolTip");
        IServerType[] serverTypes = ServerCore.getServerTypes();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement exElement = extensions[i];
            try {
                String exServerType = exElement.getAttribute("serverTypes");
                IServerType[] iServerTypeArray = serverTypes;
                int n = serverTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IServerType serverType = iServerTypeArray[n2];
                    if ("*".equals(exServerType) || serverType.getId().matches(exServerType)) {
                        IServerToolTip exTooltip = (IServerToolTip)exElement.createExecutableExtension("class");
                        ArrayList<IServerToolTip> listOfProviders = new ArrayList<IServerToolTip>();
                        if (this.toolTipProviders.containsKey(serverType.getId())) {
                            listOfProviders = this.toolTipProviders.get(serverType.getId());
                        }
                        listOfProviders.add(exTooltip);
                        this.toolTipProviders.put(serverType.getId(), listOfProviders);
                        Trace.trace((byte)7, "  Loaded serverToolTip: " + exElement.getAttribute("id") + " for server type: " + serverType.getId());
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Trace.trace((byte)3, "Tooltip failed to load" + exElement.toString(), e);
            }
            ++i;
        }
        Trace.trace((byte)7, "-<- Done loading serverToolTip extension point -<-");
    }
}

