/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.Compiler;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.ICompilerRequestor;
import org.eclipse.wst.jsdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor2;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.util.Messages;
import org.eclipse.wst.jsdt.internal.core.BasicCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.CancelableNameEnvironment;
import org.eclipse.wst.jsdt.internal.core.CancelableProblemFactory;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.DocumentContextFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.util.CommentRecorderParser;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CompilationUnitProblemFinder
extends Compiler
implements ITypeRequestor2 {
    protected CompilationUnitProblemFinder(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerOptions compilerOptions, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, compilerOptions, requestor, problemFactory);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), sourceTypes[0].getPackageName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 31, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            this.lookupEnvironment.buildTypeBindings(unit, accessRestriction);
            this.lookupEnvironment.completeTypeBindings(unit);
        }
    }

    public void accept(ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        this.accept(sourceUnit, new char[0][0], accessRestriction);
    }

    public void accept(ICompilationUnit sourceUnit, char[][] typeNames, AccessRestriction accessRestriction) {
        CompilationResult unitResult = new CompilationResult(sourceUnit, 1, 1, this.options.maxProblemsPerUnit);
        try {
            if (this.options.verbose) {
                String count = String.valueOf(this.totalUnits + 1);
                this.out.println(Messages.bind(Messages.compilation_request, new String[]{count, count, new String(sourceUnit.getFileName())}));
            }
            CompilationUnitDeclaration parsedUnit = this.totalUnits < this.parseThreshold ? this.parser.parse(sourceUnit, unitResult) : this.parser.dietParse(sourceUnit, unitResult);
            this.parser.inferTypes(parsedUnit, this.options);
            this.lookupEnvironment.buildTypeBindings(parsedUnit, typeNames, accessRestriction);
            this.lookupEnvironment.completeTypeBindings(parsedUnit, typeNames);
        }
        catch (AbortCompilationUnit e) {
            if (unitResult.compilationUnit == sourceUnit) {
                this.requestor.acceptResult(unitResult.tagAsAccepted());
            }
            throw e;
        }
    }

    protected static CompilerOptions getCompilerOptions(Map settings, boolean creatingAST, boolean statementsRecovery) {
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        compilerOptions.performMethodsFullRecovery = statementsRecovery;
        compilerOptions.performStatementsRecovery = statementsRecovery;
        compilerOptions.parseLiteralExpressionsAsConstants = !creatingAST;
        compilerOptions.storeAnnotations = creatingAST;
        return compilerOptions;
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return DefaultErrorHandlingPolicies.proceedWithAllProblems();
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompilationUnitDeclaration process(CompilationUnitDeclaration unit, IJavaScriptUnit unitElement, char[] contents, Parser parser, WorkingCopyOwner workingCopyOwner, HashMap problems, boolean creatingAST, int reconcileFlags, IProgressMonitor monitor) throws JavaScriptModelException {
        JavaProject project = (JavaProject)unitElement.getJavaScriptProject();
        CancelableNameEnvironment environment = null;
        CancelableProblemFactory problemFactory = null;
        CompilationUnitProblemFinder problemFinder = null;
        try {
            CompilationUnitDeclaration compilationUnitDeclaration;
            block19: {
                try {
                    CategorizedProblem[] categorizedProblems;
                    int length;
                    DocumentContextFragmentRoot.RestrictedDocumentBinding accessRequestor = null;
                    if (unitElement.getParent().getParent() instanceof DocumentContextFragmentRoot) {
                        accessRequestor = ((DocumentContextFragmentRoot)unitElement.getParent().getParent()).getRestrictedAccessRequestor();
                    }
                    environment = new CancelableNameEnvironment(project, accessRequestor, workingCopyOwner, monitor);
                    if (unitElement instanceof CompilationUnit) {
                        environment.unitToSkip = (CompilationUnit)unitElement;
                        environment.setCompilationUnit(environment.unitToSkip);
                    } else if (unitElement instanceof CompilationUnit) {
                        environment.unitToSkip = (CompilationUnit)unitElement;
                    }
                    problemFactory = new CancelableProblemFactory(monitor);
                    problemFinder = new CompilationUnitProblemFinder(environment, CompilationUnitProblemFinder.getHandlingPolicy(), CompilationUnitProblemFinder.getCompilerOptions(project.getOptions(true), creatingAST, (reconcileFlags & 2) != 0), CompilationUnitProblemFinder.getRequestor(), problemFactory);
                    if (parser != null) {
                        problemFinder.parser = parser;
                    }
                    PackageFragment packageFragment = (PackageFragment)unitElement.getAncestor(4);
                    char[][] expectedPackageName = null;
                    if (packageFragment != null) {
                        expectedPackageName = Util.toCharArrays(packageFragment.names);
                    }
                    if (unit == null) {
                        unit = problemFinder.resolve(new BasicCompilationUnit(contents, expectedPackageName, unitElement.getPath().toString(), unitElement), true, true, true);
                    } else {
                        problemFinder.resolve(unit, null, true, true, true);
                    }
                    CompilationResult unitResult = unit.compilationResult;
                    CategorizedProblem[] unitProblems = unitResult.getProblems();
                    int n = length = unitProblems == null ? 0 : unitProblems.length;
                    if (length > 0) {
                        categorizedProblems = new CategorizedProblem[length];
                        System.arraycopy(unitProblems, 0, categorizedProblems, 0, length);
                        problems.put("org.eclipse.wst.jsdt.core.problem", categorizedProblems);
                    }
                    int n2 = length = (unitProblems = unitResult.getTasks()) == null ? 0 : unitProblems.length;
                    if (length > 0) {
                        categorizedProblems = new CategorizedProblem[length];
                        System.arraycopy(unitProblems, 0, categorizedProblems, 0, length);
                        problems.put("org.eclipse.wst.jsdt.core.task", categorizedProblems);
                    }
                    if (NameLookup.VERBOSE) {
                        System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + environment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
                        System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + environment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
                    }
                    compilationUnitDeclaration = unit;
                    Object var20_25 = null;
                    if (environment == null) break block19;
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    String lineDelimiter = unitElement.findRecommendedLineSeparator();
                    StringBuffer message = new StringBuffer("Exception occurred during problem detection:");
                    message.append(lineDelimiter);
                    message.append("----------------------------------- SOURCE BEGIN -------------------------------------");
                    message.append(lineDelimiter);
                    message.append(contents);
                    message.append(lineDelimiter);
                    message.append("----------------------------------- SOURCE END -------------------------------------");
                    Util.log(e, message.toString());
                    throw new JavaScriptModelException(e, 1005);
                }
                environment.monitor = null;
            }
            if (problemFactory != null) {
                problemFactory.monitor = null;
            }
            if (problemFinder == null) return compilationUnitDeclaration;
            problemFinder.lookupEnvironment.reset();
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            Object var20_26 = null;
            if (environment != null) {
                environment.monitor = null;
            }
            if (problemFactory != null) {
                problemFactory.monitor = null;
            }
            if (problemFinder == null) throw throwable;
            problemFinder.lookupEnvironment.reset();
            throw throwable;
        }
    }

    public static CompilationUnitDeclaration process(IJavaScriptUnit unitElement, char[] contents, WorkingCopyOwner workingCopyOwner, HashMap problems, boolean creatingAST, int reconcileFlags, IProgressMonitor monitor) throws JavaScriptModelException {
        return CompilationUnitProblemFinder.process(null, unitElement, contents, null, workingCopyOwner, problems, creatingAST, reconcileFlags, monitor);
    }

    public void initializeParser() {
        this.parser = new CommentRecorderParser(this.problemReporter, this.options.parseLiteralExpressionsAsConstants);
    }
}

