/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.StringFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class StringCleanUp
extends AbstractCleanUp {
    public StringCleanUp(Map options) {
        super(options);
    }

    public StringCleanUp() {
    }

    public boolean requireAST(IJavaScriptUnit unit) throws CoreException {
        return this.isEnabled("cleanup.add_missing_nls_tags") || this.isEnabled("cleanup.remove_unnecessary_nls_tags");
    }

    public IFix createFix(JavaScriptUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return StringFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.add_missing_nls_tags"), this.isEnabled("cleanup.remove_unnecessary_nls_tags"));
    }

    public IFix createFix(JavaScriptUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return StringFix.createCleanUp(compilationUnit, problems, this.isEnabled("cleanup.add_missing_nls_tags"), this.isEnabled("cleanup.remove_unnecessary_nls_tags"));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.add_missing_nls_tags") || this.isEnabled("cleanup.remove_unnecessary_nls_tags")) {
            result.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        }
        return result;
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.add_missing_nls_tags")) {
            result.add(MultiFixMessages.StringMultiFix_AddMissingNonNls_description);
        }
        if (this.isEnabled("cleanup.remove_unnecessary_nls_tags")) {
            result.add(MultiFixMessages.StringMultiFix_RemoveUnnecessaryNonNls_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isEnabled("cleanup.remove_unnecessary_nls_tags")) {
            buf.append("var s=\"\";");
        } else {
            buf.append("var s=\"\"; //$NON-NLS-1$");
        }
        return buf.toString();
    }

    public boolean canFix(JavaScriptUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return StringFix.createFix(compilationUnit, problem, this.isEnabled("cleanup.remove_unnecessary_nls_tags"), this.isEnabled("cleanup.add_missing_nls_tags")) != null;
    }

    public int maximalNumberOfFixes(JavaScriptUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.add_missing_nls_tags")) {
            result += this.getNumberOfProblems(problems, 536871173);
        }
        if (this.isEnabled("cleanup.remove_unnecessary_nls_tags")) {
            result += this.getNumberOfProblems(problems, 536871177);
        }
        return result;
    }
}

