/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.CaptureType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.PrimitiveType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.WildcardType;

public final class StandardType
extends HierarchyType {
    private static final String OBJECT_KEY = BindingKey.createTypeBindingKey((String)"java.lang.Object");
    private static final String CLONEABLE_KEY = BindingKey.createTypeBindingKey((String)"java.lang.Cloneable");
    private static final String SERIALIZABLE_KEY = BindingKey.createTypeBindingKey((String)"java.io.Serializable");

    protected StandardType(TypeEnvironment environment) {
        super(environment);
    }

    public int getKind() {
        return 5;
    }

    public boolean isJavaLangObject() {
        return OBJECT_KEY.equals(this.getBindingKey());
    }

    public boolean isJavaLangCloneable() {
        return CLONEABLE_KEY.equals(this.getBindingKey());
    }

    public boolean isJavaIoSerializable() {
        return SERIALIZABLE_KEY.equals(this.getBindingKey());
    }

    public boolean doEquals(TType type) {
        return this.getJavaElementType().equals(((StandardType)type).getJavaElementType());
    }

    public int hashCode() {
        return this.getJavaElementType().hashCode();
    }

    protected boolean doCanAssignTo(TType lhs) {
        switch (lhs.getKind()) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return this.canAssignToPrimitive((PrimitiveType)lhs);
            }
            case 4: {
                return false;
            }
            case 5: {
                return this.canAssignToStandardType((StandardType)lhs);
            }
            case 6: {
                return false;
            }
            case 7: {
                return this.isSubType((HierarchyType)lhs);
            }
            case 8: {
                return this.isSubType((HierarchyType)lhs);
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)lhs).checkAssignmentBound(this);
            }
            case 12: {
                return false;
            }
            case 13: {
                return ((CaptureType)lhs).checkLowerBound(this);
            }
        }
        return false;
    }

    private boolean canAssignToPrimitive(PrimitiveType type) {
        PrimitiveType source = this.getEnvironment().createUnBoxed(this);
        return source != null && source.canAssignTo(type);
    }

    public String getName() {
        return this.getJavaElementType().getElementName();
    }

    protected String getPlainPrettySignature() {
        return this.getJavaElementType().getFullyQualifiedName('.');
    }
}

