/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.core.compiler.libraries.LibraryLocation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;

public abstract class JsGlobalScopeContainerInitializer
implements IJsGlobalScopeContainerInitializer,
IJsGlobalScopeContainer {
    public static final int ATTRIBUTE_NOT_SUPPORTED = 1;
    public static final int ATTRIBUTE_READ_ONLY = 2;

    public void initialize(IPath containerPath, IJavaScriptProject project) throws CoreException {
        JavaScriptCore.setJsGlobalScopeContainer(containerPath, new IJavaScriptProject[]{project}, new IJsGlobalScopeContainer[]{this.getContainer(containerPath, project)}, null);
    }

    protected IJsGlobalScopeContainer getContainer(IPath containerPath, IJavaScriptProject project) {
        return this;
    }

    public boolean canUpdateJsGlobalScopeContainer(IPath containerPath, IJavaScriptProject project) {
        if (project == null || containerPath == null) {
            return true;
        }
        LibrarySuperType superType = project.getCommonSuperType();
        return superType != null && superType.getRawContainerPath().equals((Object)this.getPath());
    }

    public void requestJsGlobalScopeContainerUpdate(IPath containerPath, IJavaScriptProject project, IJsGlobalScopeContainer containerSuggestion) throws CoreException {
    }

    public String getDescription(IPath containerPath, IJavaScriptProject project) {
        return containerPath.makeRelative().toString();
    }

    public IJsGlobalScopeContainer getFailureContainer(final IPath containerPath, IJavaScriptProject project) {
        final String description = this.getDescription(containerPath, project);
        return new IJsGlobalScopeContainer(){

            public IIncludePathEntry[] getIncludepathEntries() {
                return new IIncludePathEntry[0];
            }

            public String getDescription() {
                return description;
            }

            public int getKind() {
                return 0;
            }

            public IPath getPath() {
                return containerPath;
            }

            public String toString() {
                return this.getDescription();
            }

            public String[] resolvedLibraryImport(String a) {
                return new String[]{a};
            }
        };
    }

    public Object getComparisonID(IPath containerPath, IJavaScriptProject project) {
        if (containerPath == null) {
            return null;
        }
        return containerPath.segment(0);
    }

    public URI getHostPath(IPath path, IJavaScriptProject project) {
        return null;
    }

    public boolean allowAttachJsDoc() {
        return true;
    }

    public String[] containerSuperTypes() {
        return new String[0];
    }

    public String[] resolvedLibraryImport(String realImport) {
        return new String[]{realImport};
    }

    public IIncludePathEntry[] getIncludepathEntries() {
        LibraryLocation libLocation = this.getLibraryLocation();
        char[][] filesInLibs = libLocation.getLibraryFileNames();
        IIncludePathEntry[] entries = new IIncludePathEntry[filesInLibs.length];
        int i = 0;
        while (i < entries.length) {
            Path workingLibPath = new Path(libLocation.getLibraryPath(filesInLibs[i]));
            entries[i] = JavaScriptCore.newLibraryEntry(workingLibPath.makeAbsolute(), null, null, new IAccessRule[0], new IIncludePathAttribute[0], true);
            ++i;
        }
        return entries;
    }

    public String getDescription() {
        return null;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return null;
    }

    public IStatus getAccessRulesStatus(IPath containerPath, IJavaScriptProject project) {
        if (this.canUpdateJsGlobalScopeContainer(containerPath, project)) {
            return Status.OK_STATUS;
        }
        return new JavaModelStatus(2);
    }

    public IStatus getAttributeStatus(IPath containerPath, IJavaScriptProject project, String attributeKey) {
        if (this.canUpdateJsGlobalScopeContainer(containerPath, project)) {
            return Status.OK_STATUS;
        }
        return new JavaModelStatus(2);
    }

    public IStatus getSourceAttachmentStatus(IPath containerPath, IJavaScriptProject project) {
        if (this.canUpdateJsGlobalScopeContainer(containerPath, project)) {
            return Status.OK_STATUS;
        }
        return new JavaModelStatus(2);
    }

    public String getInferenceID() {
        return null;
    }

    public void removeFromProject(IJavaScriptProject project) {
    }
}

