/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebUtilities
extends JavaEEProjectUtilities {
    public static IPath WEBLIB = new Path("/WEB-INF/lib");

    public static int getServletVersion(IProject webProject) {
        int retVal = 0;
        Object webAppResource = ModelProviderManager.getModelProvider(webProject).getModelObject();
        if (webAppResource instanceof XMLResource) {
            retVal = ((XMLResource)webAppResource).getModuleVersionID();
        } else if (webAppResource instanceof WebApp) {
            switch (((WebApp)webAppResource).getVersion().getValue()) {
                case 0: {
                    retVal = 25;
                }
            }
        }
        return retVal;
    }

    public static int getJSPVersion(IProject webProject) {
        int servletVersion = WebUtilities.getServletVersion(webProject);
        if (servletVersion == 22) {
            return 11;
        }
        if (servletVersion == 23) {
            return 12;
        }
        return 20;
    }

    public static List<IVirtualComponent> getWebFragments(IVirtualComponent webComponent) {
        return WebUtilities.getWebFragments(webComponent, false);
    }

    public static List<IVirtualComponent> getWebFragments(IVirtualComponent webComponent, boolean expandLibraries) {
        IVirtualReference[] refComponents;
        ArrayList<IVirtualComponent> result = new ArrayList<IVirtualComponent>();
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        if (expandLibraries) {
            options.put(J2EEModuleVirtualComponent.GET_EXPANDED_LIB_REFS, Boolean.TRUE);
        }
        IVirtualReference[] iVirtualReferenceArray = refComponents = webComponent.getReferences(options);
        int n = refComponents.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualComponent virtualComponent;
            IVirtualReference virtualReference = iVirtualReferenceArray[n2];
            if (virtualReference.getRuntimePath().equals((Object)WEBLIB) && JavaEEProjectUtilities.isWebFragmentProject(virtualComponent = virtualReference.getReferencedComponent())) {
                result.add(virtualComponent);
            }
            ++n2;
        }
        IVirtualFolder rootFolder = webComponent.getRootFolder();
        IVirtualFolder webLibFolder = rootFolder.getFolder(WEBLIB);
        if (webLibFolder.exists()) {
            try {
                IVirtualResource[] webLibs;
                IVirtualResource[] iVirtualResourceArray = webLibs = webLibFolder.members();
                int n3 = webLibs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVirtualResource webLib = iVirtualResourceArray[n4];
                    if (webLib.getType() == 16 && J2EEComponentClasspathUpdater.endsWithIgnoreCase(webLib.getName(), ".jar")) {
                        IResource iResource = webLib.getUnderlyingResource();
                        IVirtualComponent virtualComponent = ComponentCore.createArchiveComponent((IProject)webComponent.getProject(), (String)("lib" + iResource.getFullPath().toString()));
                        if (JavaEEProjectUtilities.isWebFragmentProject(virtualComponent)) {
                            result.add(virtualComponent);
                        }
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                J2EEPlugin.logError(e);
            }
        }
        return result;
    }

    public static IVirtualReference[] getLibModules(IVirtualComponent webComponent) {
        return WebUtilities.getLibModules(webComponent, false);
    }

    public static IVirtualReference[] getLibModules(IVirtualComponent webComponent, boolean expandLibraries) {
        ArrayList<IVirtualReference> result = new ArrayList<IVirtualReference>();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("REQUESTED_REFERENCE_TYPE", "FLATTENABLE_REFERENCES");
        if (expandLibraries) {
            options.put(J2EEModuleVirtualComponent.GET_EXPANDED_LIB_REFS, Boolean.TRUE);
        }
        IVirtualReference[] refComponents = webComponent.getReferences(options);
        int i = 0;
        while (i < refComponents.length) {
            IVirtualReference reference = refComponents[i];
            if (reference.getRuntimePath().equals((Object)WEBLIB)) {
                result.add(reference);
            }
            ++i;
        }
        return result.toArray(new IVirtualReference[result.size()]);
    }

    public static IVirtualReference[] getLibModules(IProject webProject) {
        IVirtualComponent webComponent = ComponentCore.createComponent((IProject)webProject);
        return WebUtilities.getLibModules(webComponent);
    }

    public static boolean isWebResource(Object object) {
        IResource resource;
        IVirtualComponent component;
        if (object instanceof IResource && (component = ComponentCore.createComponent((IProject)(resource = (IResource)object).getProject())) != null && JavaEEProjectUtilities.isDynamicWebComponent(component)) {
            IPath rootPath = component.getRootFolder().getWorkspaceRelativePath();
            IPath webInfPath = rootPath.append("WEB-INF");
            IPath metaInfPath = rootPath.append("META-INF");
            IPath resourcePath = resource.getFullPath();
            return rootPath.isPrefixOf(resourcePath) && !rootPath.equals((Object)resourcePath) && !webInfPath.isPrefixOf(resourcePath) && !metaInfPath.isPrefixOf(resourcePath);
        }
        return false;
    }

    public static void setServerContextRoot(IProject webProject, String contextRoot) {
        ComponentUtilities.setServerContextRoot((IProject)webProject, (String)contextRoot);
    }

    public static IProject[] getReferencingWebProjects(IProject project) {
        if (project == null) {
            return new IProject[0];
        }
        if (WebUtilities.isDynamicWebProject(project)) {
            return new IProject[]{project};
        }
        ArrayList<IProject> result = new ArrayList<IProject>();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            IVirtualComponent[] refComponents = component.getReferencingComponents();
            int i = 0;
            while (i < refComponents.length) {
                if (WebUtilities.isDynamicWebProject(refComponents[i].getProject())) {
                    result.add(refComponents[i].getProject());
                }
                ++i;
            }
        }
        IProject[] webProjects = result.toArray(new IProject[result.size()]);
        Arrays.sort(webProjects, new Comparator<IProject>(){

            @Override
            public int compare(IProject p0, IProject p1) {
                return p0.getName().compareTo(p1.getName());
            }
        });
        return webProjects;
    }
}

