/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;

public class HostnameComposite
extends Composite {
    public static final String LOCALHOST = "localhost";
    protected String host;
    protected IHostnameSelectionListener listener;
    protected Text hostname;

    public HostnameComposite(Composite parent, IHostnameSelectionListener listener2) {
        super(parent, 0);
        this.listener = listener2;
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        Label label = new Label((Composite)this, 64);
        label.setText(Messages.hostname);
        label.setLayoutData((Object)new GridData(256));
        this.hostname = new Text((Composite)this, 2048);
        this.hostname.setText(LOCALHOST);
        final ControlDecoration hostnameDecoration = new ControlDecoration((Control)this.hostname, 16512);
        GridData data = new GridData(772);
        data.horizontalSpan = 2;
        this.hostname.setLayoutData((Object)data);
        this.hostname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HostnameComposite.this.hostnameChanged(HostnameComposite.this.hostname.getText());
            }
        });
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        FieldDecoration fd = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
        hostnameDecoration.setImage(fd.getImage());
        hostnameDecoration.setDescriptionText(fd.getDescription());
        this.hostname.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                hostnameDecoration.show();
            }

            public void focusLost(FocusEvent e) {
                hostnameDecoration.hide();
            }
        });
        List<String> hosts = ServerUIPlugin.getPreferences().getHostnames();
        String[] hosts2 = hosts.toArray(new String[hosts.size()]);
        new AutoCompleteField((Control)this.hostname, (IControlContentAdapter)new TextContentAdapter(), hosts2);
        Dialog.applyDialogFont((Control)this);
    }

    protected void hostnameChanged(String newHost) {
        if (newHost == null) {
            return;
        }
        if (newHost.equals(this.host)) {
            return;
        }
        this.host = newHost;
        this.listener.hostnameSelected(this.host);
    }

    public String getHostname() {
        return this.host;
    }

    public void setHostname(String newHostname) {
        this.hostname.setText(newHostname);
    }

    public static interface IHostnameSelectionListener {
        public void hostnameSelected(String var1);
    }
}

