/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.mapping;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.MetadataFactory;
import org.eclipse.jst.jsf.common.metadata.MetadataPackage;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.runtime.internal.model.types.ClassTypeInfo;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.ViewMetadataMapper;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.viewmapping.ClassTypeInfo_;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.viewmapping.ComponentMappingFactory;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.viewmapping.TagMapping;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.viewmapping.TagToViewObjectMapping;

public class ViewMetadataGenerator {
    private final ResourceSet _resourceSet;
    private final ExtendedMetaData _extendedMetadata;
    private final Model _root = MetadataFactory.eINSTANCE.createModel();
    private final ViewMetadataMapper _mapper;

    public ViewMetadataGenerator(String uri) {
        this._root.setId(uri);
        this._root.setType("tagFile");
        this._resourceSet = new ResourceSetImpl();
        this._mapper = new ViewMetadataMapper();
        this._extendedMetadata = new BasicExtendedMetaData(this._resourceSet.getPackageRegistry());
        this._resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMLResourceFactoryImpl());
    }

    public void addTagToViewObjectMapping(String tagName, ClassTypeInfo typeInfo, String minJSFVersion, String minLibVersion) {
        ClassTypeInfo_ metadata = this._mapper.mapToMetadata(typeInfo);
        if (metadata != null) {
            TagToViewObjectMapping viewMapping = ComponentMappingFactory.eINSTANCE.createTagToViewObjectMapping();
            if (minJSFVersion != null) {
                viewMapping.setMinJSFVersion(minJSFVersion);
            }
            viewMapping.setMinLibraryVersion(minLibVersion);
            viewMapping.setTypeInfo(metadata);
            TagMapping tagMapping = this.findOrCreateTagMapping(tagName);
            tagMapping.getVersionedTagToViewMappings().add((Object)viewMapping);
            Trait trait = MetadataFactory.eINSTANCE.createTrait();
            trait.setId("viewElementMapping");
            trait.setValue((EObject)tagMapping);
            Entity entity = MetadataFactory.eINSTANCE.createEntity();
            entity.setId(tagName);
            entity.setType("tag");
            entity.getTraits().add((Object)trait);
            this._root.getChildEntities().add((Object)entity);
        }
    }

    private TagMapping findOrCreateTagMapping(String tagName) {
        for (Entity entity : this._root.getChildEntities()) {
            if (!entity.getId().equals(tagName)) continue;
            for (Trait trait : entity.getTraits()) {
                if (!trait.getId().equals("viewElementMapping")) continue;
                return (TagMapping)trait.getValue();
            }
        }
        return ComponentMappingFactory.eINSTANCE.createTagMapping();
    }

    public void save(OutputStream out) throws IOException {
        XMLResourceImpl res = new XMLResourceImpl(){

            protected XMLHelper createXMLHelper() {
                return new XMLHelperImpl(){

                    public String getHREF(EObject obj) {
                        return "http://org.eclipse.jst.jsf.core/componentMapping.ecore";
                    }

                    public EPackage getNoNamespacePackage() {
                        return MetadataPackage.eINSTANCE;
                    }
                };
            }
        };
        res.getContents().add((Object)this._root);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("SCHEMA_LOCATION", Boolean.TRUE);
        options.put("EXTENDED_META_DATA", (Boolean)this._extendedMetadata);
        options.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
        options.put("RECORD_UNKNOWN_FEATURE", Boolean.FALSE);
        res.save(out, options);
    }
}

