/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.frameworks.internal.ui.RunnableWithProgressWrapper;
import org.eclipse.wst.validation.internal.operations.OneValidatorOperation;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;

public class EARValidationHelper {
    private EARValidationHelper() {
    }

    public static IRunnableWithProgress[] getEARValidationOperations(List modifiedProjects) {
        List<IProject> earProjects = Arrays.asList(J2EEProjectUtilities.getAllProjectsInWorkspaceOfType((String)"jst.ear"));
        ArrayList<IRunnableWithProgress> result = new ArrayList<IRunnableWithProgress>(earProjects.size());
        int i = 0;
        while (i < earProjects.size()) {
            IProject earProj = earProjects.get(i);
            if (EARValidationHelper.willEARProjectNeedValidation(earProj, modifiedProjects)) {
                result.add(EARValidationHelper.createValidationRunnable(earProj));
            }
            ++i;
        }
        return result.toArray(new IRunnableWithProgress[result.size()]);
    }

    public static IRunnableWithProgress[] getEARValidationOperations(IProject modifiedJ2EEProject) {
        return EARValidationHelper.getEARValidationOperations(Collections.singletonList(modifiedJ2EEProject));
    }

    public static boolean isEARValidationAutoEnabled(IProject earProj) {
        return ValidatorManager.getManager().isAutoValidate(earProj) && ValidatorManager.getManager().isEnabled(earProj, "org.eclipse.jst.j2ee.internal.validation.UIEarValidator");
    }

    private static boolean willEARProjectNeedValidation(IProject earProj, List modifiedProjects) {
        if (modifiedProjects.contains(earProj) || !EARValidationHelper.isEARValidationAutoEnabled(earProj)) {
            return false;
        }
        return false;
    }

    public static IRunnableWithProgress createValidationRunnable(IProject earProj) {
        OneValidatorOperation op = new OneValidatorOperation(earProj, "org.eclipse.jst.j2ee.internal.validation.UIEarValidator", true, false);
        return new RunnableWithProgressWrapper((IHeadlessRunnableWithProgress)op);
    }
}

