/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxrs.core.internal.JAXRSCorePlugin;
import org.eclipse.jst.ws.jaxrs.core.internal.JAXRSLibraryClasspathContainer;
import org.eclipse.jst.ws.jaxrs.core.internal.Messages;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.ArchiveFile;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.JAXRSLibrary;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.JAXRSLibraryRegistry;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.JAXRSLibraryRegistryFactory;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryInternalReference;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryregistry.adapter.MaintainDefaultImplementationAdapter;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryregistry.impl.JAXRSLibraryRegistryPackageImpl;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryregistry.util.JAXRSLibraryRegistryResourceFactoryImpl;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryregistry.util.JAXRSLibraryRegistryResourceImpl;
import org.eclipse.jst.ws.jaxrs.core.jaxrslibraryregistry.internal.PluginProvidedJAXRSLibraryCreationHelper2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSLibraryRegistryUtil {
    private static JAXRSLibraryRegistryUtil instance = null;
    private List<JAXRSLibraryInternalReference> implLibs = null;
    private static final String JAXRS_LIBRARY_REGISTRY_NSURI = "http://www.eclipse.org/webtools/jaxrs/schema/jaxrslibraryregistry.xsd";
    private static final String LIB_EXT_PT = "pluginProvidedJaxrsLibraries";
    private static JAXRSLibraryRegistryResourceImpl JAXRSLibraryRegistryResource = null;
    private JAXRSLibraryRegistry JAXRSLibraryRegistry;

    private JAXRSLibraryRegistryUtil() {
    }

    public static synchronized JAXRSLibraryRegistryUtil getInstance() {
        if (instance == null) {
            instance = new JAXRSLibraryRegistryUtil();
            instance.loadJAXRSLibraryRegistry();
        }
        return instance;
    }

    public JAXRSLibraryRegistry getJAXRSLibraryRegistry() {
        return this.JAXRSLibraryRegistry;
    }

    public JAXRSLibraryInternalReference getDefaultJAXRSImplementationLibrary() {
        JAXRSLibrary dftImplLib = this.getJAXRSLibraryRegistry().getDefaultImplementation();
        return dftImplLib != null ? this.getJAXRSLibraryReferencebyID(dftImplLib.getID()) : null;
    }

    List<JAXRSLibraryInternalReference> getJAXRSImplementationLibraries() {
        if (this.implLibs == null) {
            this.implLibs = this.wrapJAXRSLibraries(this.getJAXRSLibraryRegistry().getImplJAXRSLibraries());
        } else if (this.implLibs.size() != this.getJAXRSLibraryRegistry().getImplJAXRSLibraries().size() || this.isAnyLibraryChanged(this.implLibs)) {
            this.implLibs.clear();
            this.implLibs = this.wrapJAXRSLibraries(this.getJAXRSLibraryRegistry().getImplJAXRSLibraries());
        }
        return this.implLibs;
    }

    public JAXRSLibraryInternalReference getJAXRSLibraryReferencebyID(String id) {
        Iterator<JAXRSLibraryInternalReference> it = this.getJAXRSImplementationLibraries().iterator();
        JAXRSLibraryInternalReference crtItem = null;
        while (it.hasNext()) {
            crtItem = it.next();
            if (!id.equals(crtItem.getID())) continue;
            return crtItem;
        }
        return null;
    }

    public void addJAXRSLibrary(JAXRSLibraryInternalReference library) {
        if (library != null && this.getJAXRSLibraryRegistry().getJAXRSLibraryByID(library.getID()) == null) {
            JAXRSLibrary jaxrsLib = library.getLibrary();
            this.getJAXRSLibraryRegistry().addJAXRSLibrary(jaxrsLib.getWorkingCopy());
            List<JAXRSLibraryInternalReference> list = this.getJAXRSImplementationLibraries();
            list.add(library);
        }
    }

    private List<JAXRSLibraryInternalReference> wrapJAXRSLibraries(EList libs) {
        ArrayList<JAXRSLibraryInternalReference> list = new ArrayList<JAXRSLibraryInternalReference>();
        if (libs != null) {
            for (JAXRSLibrary jaxrsLib : libs) {
                JAXRSLibraryInternalReference jaxrsLibDctr = new JAXRSLibraryInternalReference(jaxrsLib, true, true, false);
                list.add(jaxrsLibDctr);
            }
        }
        return list;
    }

    private boolean isAnyLibraryChanged(List<JAXRSLibraryInternalReference> list) {
        Iterator<JAXRSLibraryInternalReference> it = list.iterator();
        JAXRSLibraryInternalReference wclib = null;
        JAXRSLibrary lib = null;
        while (it.hasNext()) {
            wclib = it.next();
            lib = this.getJAXRSLibraryRegistry().getJAXRSLibraryByID(wclib.getID());
            if (lib == null) {
                return true;
            }
            if (wclib.getArchiveFiles().size() != lib.getArchiveFiles().size()) {
                return true;
            }
            if (!this.isAnyArchiveFileChanged(wclib.getArchiveFiles(), lib.getArchiveFiles())) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyArchiveFileChanged(EList source, EList target) {
        ArchiveFile arSrc2 = null;
        for (ArchiveFile arSrc2 : source) {
            if (this.findMatchedArchive(arSrc2, target)) continue;
            return true;
        }
        return false;
    }

    private boolean findMatchedArchive(ArchiveFile source, EList list) {
        ArchiveFile target2 = null;
        for (ArchiveFile target2 : list) {
            if (!target2.equals(source)) continue;
            return true;
        }
        return false;
    }

    public IClasspathEntry[] getClasspathEntries(JAXRSLibrary lib) {
        ArrayList<IClasspathEntry> res = new ArrayList<IClasspathEntry>(lib.getArchiveFiles().size());
        for (ArchiveFile jar : lib.getArchiveFiles()) {
            IClasspathEntry entry;
            if (jar == null || !jar.exists() || (entry = this.getClasspathEntry(jar)) == null) continue;
            res.add(entry);
        }
        IClasspathEntry[] entries = res.toArray(new IClasspathEntry[res.size()]);
        return entries;
    }

    public IClasspathEntry getClasspathEntry(ArchiveFile jar) {
        IClasspathEntry entry = null;
        if (jar != null && jar.exists()) {
            entry = JavaCore.newLibraryEntry((IPath)new Path(jar.getResolvedSourceLocation()), null, null);
        }
        return entry;
    }

    public static void rebindClasspathContainerEntries(String oldId, String newId, IProgressMonitor monitor) throws JavaModelException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        IPath containerPath = new Path("org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibrarycontainer").append(newId);
        IPath oldContainerPath = new Path("org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibrarycontainer").append(oldId);
        JAXRSLibrary lib = JAXRSLibraryRegistryUtil.getInstance().getJAXRSLibraryRegistry().getJAXRSLibraryByID(newId);
        ArrayList<IJavaProject> affectedProjects = new ArrayList<IJavaProject>();
        boolean removeAndAddBecauseOfRename = !oldId.equals(newId);
        int i = 0;
        while (i < projects.length) {
            IJavaProject project = projects[i];
            IClasspathEntry[] entries = project.getRawClasspath();
            int k = 0;
            while (k < entries.length) {
                IClasspathEntry curr = entries[k];
                if (curr.getEntryKind() == 5 && oldContainerPath.equals((Object)curr.getPath())) {
                    affectedProjects.add(project);
                    break;
                }
                ++k;
            }
            ++i;
        }
        if (!affectedProjects.isEmpty()) {
            IJavaProject[] affected = affectedProjects.toArray(new IJavaProject[affectedProjects.size()]);
            IClasspathContainer[] containers = new IClasspathContainer[affected.length];
            boolean bl = removeAndAddBecauseOfRename = !oldId.equals(newId);
            if (removeAndAddBecauseOfRename) {
                IClasspathEntry newEntry = JavaCore.newContainerEntry((IPath)containerPath);
                int i2 = 0;
                while (i2 < affected.length) {
                    IJavaProject project = affected[i2];
                    IClasspathEntry[] entries = project.getRawClasspath();
                    ArrayList<IClasspathEntry> keptEntries = new ArrayList<IClasspathEntry>();
                    int k = 0;
                    while (k < entries.length) {
                        IClasspathEntry curr = entries[k];
                        if (curr.getEntryKind() == 5) {
                            if (!oldContainerPath.equals((Object)curr.getPath())) {
                                keptEntries.add(curr);
                            }
                        } else {
                            keptEntries.add(curr);
                        }
                        ++k;
                    }
                    keptEntries.add(newEntry);
                    JAXRSLibraryRegistryUtil.setRawClasspath(project, keptEntries, monitor);
                    ++i2;
                }
            } else {
                JAXRSLibraryClasspathContainer container = new JAXRSLibraryClasspathContainer(lib);
                containers[0] = container;
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])affected, (IClasspathContainer[])containers, (IProgressMonitor)monitor);
            }
        } else if (monitor != null) {
            monitor.done();
        }
    }

    public static void setRawClasspath(IJavaProject project, List<IClasspathEntry> cpEntries, IProgressMonitor monitor) {
        IClasspathEntry[] entries = cpEntries.toArray(new IClasspathEntry[0]);
        try {
            project.setRawClasspath(entries, monitor);
        }
        catch (JavaModelException e) {
            JAXRSCorePlugin.log((Exception)((Object)e), "Unable to set classpath for: " + project.getProject().getName());
        }
    }

    public static URI getRegistryURI(String registryVersion) throws MalformedURLException {
        URL jaxrsLibRegURL = new URL(Platform.getInstanceLocation().getURL(), registryVersion);
        return URI.createURI((String)jaxrsLibRegURL.toString());
    }

    private void loadJAXRSLibraryRegistry() {
        try {
            EPackage.Registry.INSTANCE.put((Object)JAXRS_LIBRARY_REGISTRY_NSURI, (Object)JAXRSLibraryRegistryPackageImpl.init());
            URI jaxrsLibRegURI = JAXRSLibraryRegistryUtil.getRegistryURI(".metadata/.plugins/org.eclipse.jst.ws.jaxrs.core/JAXRSLibraryRegistry.xml");
            JAXRSLibraryRegistryResourceFactoryImpl resourceFactory = new JAXRSLibraryRegistryResourceFactoryImpl();
            JAXRSLibraryRegistryResource = (JAXRSLibraryRegistryResourceImpl)resourceFactory.createResource(jaxrsLibRegURI);
            try {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("DISABLE_NOTIFY", Boolean.TRUE);
                JAXRSLibraryRegistryResource.load(options);
                this.JAXRSLibraryRegistry = (JAXRSLibraryRegistry)JAXRSLibraryRegistryResource.getContents().get(0);
                this.loadJAXRSLibraryExtensions();
            }
            catch (IOException iOException) {
                this.JAXRSLibraryRegistry = JAXRSLibraryRegistryFactory.eINSTANCE.createJAXRSLibraryRegistry();
                JAXRSLibraryRegistryResource = (JAXRSLibraryRegistryResourceImpl)resourceFactory.createResource(jaxrsLibRegURI);
                JAXRSLibraryRegistryResource.getContents().add((Object)this.JAXRSLibraryRegistry);
                this.loadJAXRSLibraryExtensions();
                this.saveJAXRSLibraryRegistry();
            }
            if (this.JAXRSLibraryRegistry != null) {
                JAXRSLibrary defLib = this.JAXRSLibraryRegistry.getDefaultImplementation();
                if (defLib == null && this.JAXRSLibraryRegistry.getImplJAXRSLibraries().size() > 0) {
                    this.JAXRSLibraryRegistry.setDefaultImplementation((JAXRSLibrary)this.JAXRSLibraryRegistry.getImplJAXRSLibraries().get(0));
                    this.saveJAXRSLibraryRegistry();
                }
                this.JAXRSLibraryRegistry.eAdapters().add((Object)MaintainDefaultImplementationAdapter.getInstance());
            }
        }
        catch (MalformedURLException mue) {
            JAXRSCorePlugin.log(4, Messages.JAXRSLibraryRegistry_ErrorCreatingURL, mue);
        }
    }

    private void loadJAXRSLibraryExtensions() {
        try {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.ws.jaxrs.core", LIB_EXT_PT);
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                int j = 0;
                while (j < ext.getConfigurationElements().length) {
                    PluginProvidedJAXRSLibraryCreationHelper2 newLibCreator = new PluginProvidedJAXRSLibraryCreationHelper2(ext.getConfigurationElements()[j]);
                    JAXRSLibrary newLib = newLibCreator.create();
                    if (newLib != null) {
                        this.JAXRSLibraryRegistry.addJAXRSLibrary(newLib);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException e) {
            JAXRSCorePlugin.log(4, Messages.JAXRSLibraryRegistry_ErrorLoadingFromExtPt, e);
        }
    }

    public boolean saveJAXRSLibraryRegistry() {
        boolean saved = false;
        if (JAXRSLibraryRegistryResource != null) {
            try {
                JAXRSLibraryRegistryResource.save(Collections.EMPTY_MAP);
                saved = true;
            }
            catch (IOException ioe) {
                JAXRSCorePlugin.log(4, Messages.JAXRSLibraryRegistry_ErrorSaving, ioe);
            }
        } else {
            JAXRSCorePlugin.log(4, Messages.JAXRSLibraryRegistry_ErrorSaving);
        }
        return saved;
    }
}

