/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.ReferenceTable;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.details.JoinColumnInReferenceTableDialog;
import org.eclipse.jpt.ui.internal.details.JoinColumnInReferenceTableStateObject;
import org.eclipse.jpt.ui.internal.details.JoinColumnsComposite;
import org.eclipse.jpt.ui.internal.details.db.CatalogCombo;
import org.eclipse.jpt.ui.internal.details.db.SchemaCombo;
import org.eclipse.jpt.ui.internal.details.db.TableCombo;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.internal.model.value.CachingTransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ReadOnlyWritablePropertyValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.ValueListAdapter;
import org.eclipse.jpt.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferenceTableComposite<T extends ReferenceTable>
extends Pane<T> {
    protected Button overrideDefaultJoinColumnsCheckBox;
    protected JoinColumnsComposite<T> joinColumnsComposite;

    protected ReferenceTableComposite(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent, false);
    }

    protected ReferenceTableComposite(PropertyValueModel<? extends T> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    protected void installJoinColumnsPaneEnabler(JoinColumnsComposite<T> pane) {
        pane.installJoinColumnsPaneEnabler((PropertyValueModel<Boolean>)new JoinColumnPaneEnablerHolder());
    }

    private void addJoinColumn(T referenceTable) {
        JoinColumnInReferenceTableDialog dialog = new JoinColumnInReferenceTableDialog(this.getShell(), (ReferenceTable)referenceTable, null);
        dialog.openDialog(this.buildAddJoinColumnPostExecution());
    }

    private void addJoinColumnFromDialog(JoinColumnInReferenceTableStateObject stateObject) {
        int index = ((ReferenceTable)this.getSubject()).specifiedJoinColumnsSize();
        JoinColumn joinColumn = ((ReferenceTable)this.getSubject()).addSpecifiedJoinColumn(index);
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
        this.setSelectedJoinColumn(joinColumn);
    }

    private void setSelectedJoinColumn(JoinColumn joinColumn) {
        this.joinColumnsComposite.setSelectedJoinColumn(joinColumn);
    }

    private PostExecution<JoinColumnInReferenceTableDialog> buildAddJoinColumnPostExecution() {
        return new PostExecution<JoinColumnInReferenceTableDialog>(){

            @Override
            public void execute(JoinColumnInReferenceTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    ReferenceTableComposite.this.addJoinColumnFromDialog((JoinColumnInReferenceTableStateObject)((Object)dialog.getSubject()));
                }
            }
        };
    }

    private PostExecution<JoinColumnInReferenceTableDialog> buildEditJoinColumnPostExecution() {
        return new PostExecution<JoinColumnInReferenceTableDialog>(){

            @Override
            public void execute(JoinColumnInReferenceTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    ReferenceTableComposite.this.editJoinColumn((JoinColumnInReferenceTableStateObject)((Object)dialog.getSubject()));
                }
            }
        };
    }

    protected JoinColumnsProvider buildJoinColumnsEditor() {
        return new JoinColumnsProvider();
    }

    protected WritablePropertyValueModel<Boolean> buildOverrideDefaultJoinColumnHolder() {
        return new OverrideDefaultJoinColumnHolder();
    }

    private ListValueModel<JoinColumn> buildSpecifiedJoinColumnsListHolder() {
        return new ListAspectAdapter<T, JoinColumn>(this.getSubjectHolder(), new String[]{"specifiedJoinColumns"}){

            protected ListIterator<JoinColumn> listIterator_() {
                return ((ReferenceTable)this.subject).specifiedJoinColumns();
            }

            protected int size_() {
                return ((ReferenceTable)this.subject).specifiedJoinColumnsSize();
            }
        };
    }

    protected Composite addPane(Composite container, int groupBoxMargin) {
        return this.addSubPane(container, 0, groupBoxMargin, 10, groupBoxMargin);
    }

    protected TableCombo<T> addTableCombo(Composite container) {
        return new TableCombo<T>(this, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultName");
                propertyNames.add("specifiedName");
                propertyNames.add("defaultSchema");
                propertyNames.add("specifiedSchema");
                propertyNames.add("defaultCatalog");
                propertyNames.add("specifiedCatalog");
            }

            @Override
            protected void propertyChanged(String propertyName) {
                super.propertyChanged(propertyName);
                if (propertyName == "defaultSchema" || propertyName == "specifiedSchema" || propertyName == "defaultCatalog" || propertyName == "specifiedCatalog") {
                    this.repopulate();
                }
            }

            @Override
            protected String getDefaultValue() {
                return ((ReferenceTable)this.getSubject()).getDefaultName();
            }

            @Override
            protected void setValue(String value) {
                ((ReferenceTable)this.getSubject()).setSpecifiedName(value);
            }

            @Override
            protected String getValue() {
                return ((ReferenceTable)this.getSubject()).getSpecifiedName();
            }

            @Override
            protected Schema getDbSchema_() {
                return ((ReferenceTable)this.getSubject()).getDbSchema();
            }
        };
    }

    protected SchemaCombo<T> addSchemaCombo(Composite container) {
        return new SchemaCombo<T>(this, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultSchema");
                propertyNames.add("specifiedSchema");
                propertyNames.add("defaultCatalog");
                propertyNames.add("specifiedCatalog");
            }

            @Override
            protected void propertyChanged(String propertyName) {
                super.propertyChanged(propertyName);
                if (propertyName == "defaultCatalog" || propertyName == "specifiedCatalog") {
                    this.repopulate();
                }
            }

            @Override
            protected String getDefaultValue() {
                return ((ReferenceTable)this.getSubject()).getDefaultSchema();
            }

            @Override
            protected void setValue(String value) {
                ((ReferenceTable)this.getSubject()).setSpecifiedSchema(value);
            }

            @Override
            protected String getValue() {
                return ((ReferenceTable)this.getSubject()).getSpecifiedSchema();
            }

            @Override
            protected SchemaContainer getDbSchemaContainer_() {
                return ((ReferenceTable)this.getSubject()).getDbSchemaContainer();
            }
        };
    }

    protected CatalogCombo<T> addCatalogCombo(Composite container) {
        return new CatalogCombo<T>(this, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultCatalog");
                propertyNames.add("specifiedCatalog");
            }

            @Override
            protected String getDefaultValue() {
                return ((ReferenceTable)this.getSubject()).getDefaultCatalog();
            }

            @Override
            protected void setValue(String value) {
                ((ReferenceTable)this.getSubject()).setSpecifiedCatalog(value);
            }

            @Override
            protected String getValue() {
                return ((ReferenceTable)this.getSubject()).getSpecifiedCatalog();
            }
        };
    }

    private void editJoinColumn(JoinColumn joinColumn) {
        JoinColumnInReferenceTableDialog dialog = new JoinColumnInReferenceTableDialog(this.getShell(), (ReferenceTable)this.getSubject(), joinColumn);
        dialog.openDialog(this.buildEditJoinColumnPostExecution());
    }

    private void editJoinColumn(JoinColumnInReferenceTableStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    private void updateJoinColumns() {
        if (this.isPopulating()) {
            return;
        }
        ReferenceTable referenceTable = (ReferenceTable)this.getSubject();
        if (referenceTable == null) {
            return;
        }
        boolean selected = this.overrideDefaultJoinColumnsCheckBox.getSelection();
        this.setPopulating(true);
        try {
            if (selected) {
                referenceTable.convertDefaultToSpecifiedJoinColumn();
                this.setSelectedJoinColumn((JoinColumn)referenceTable.specifiedJoinColumns().next());
            } else {
                int index = referenceTable.specifiedJoinColumnsSize();
                while (--index >= 0) {
                    referenceTable.removeSpecifiedJoinColumn(index);
                }
            }
        }
        finally {
            this.setPopulating(false);
        }
    }

    protected abstract boolean isParentVirtual(T var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinColumnPaneEnablerHolder
    extends CachingTransformationPropertyValueModel<T, Boolean> {
        private StateChangeListener stateChangeListener;

        public JoinColumnPaneEnablerHolder() {
            super((PropertyValueModel)new ValueListAdapter((WritablePropertyValueModel)new ReadOnlyWritablePropertyValueModelWrapper(ReferenceTableComposite.this.getSubjectHolder()), new String[]{"specifiedJoinColumns"}));
            this.stateChangeListener = this.buildStateChangeListener();
        }

        private StateChangeListener buildStateChangeListener() {
            return new StateChangeListener(){

                public void stateChanged(StateChangeEvent event) {
                    JoinColumnPaneEnablerHolder.this.valueStateChanged(event);
                }
            };
        }

        private void valueStateChanged(StateChangeEvent event) {
            Object oldValue = this.cachedValue;
            Object newValue = this.transformNew((ReferenceTable)this.valueHolder.getValue());
            this.firePropertyChanged("value", oldValue, newValue);
        }

        protected Boolean transform(T value) {
            if (value == null) {
                return Boolean.FALSE;
            }
            return (Boolean)super.transform(value);
        }

        protected Boolean transform_(T value) {
            boolean virtual = ReferenceTableComposite.this.isParentVirtual(value);
            return !virtual && value.specifiedJoinColumnsSize() > 0;
        }

        protected void engageModel() {
            super.engageModel();
            this.valueHolder.addStateChangeListener(this.stateChangeListener);
        }

        protected void disengageModel() {
            this.valueHolder.removeStateChangeListener(this.stateChangeListener);
            super.disengageModel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinColumnsProvider
    implements JoinColumnsComposite.JoinColumnsEditor<T> {
        private JoinColumnsProvider() {
        }

        @Override
        public void addJoinColumn(T subject) {
            ReferenceTableComposite.this.addJoinColumn(subject);
        }

        @Override
        public JoinColumn getDefaultJoinColumn(T subject) {
            return subject.getDefaultJoinColumn();
        }

        @Override
        public String getDefaultPropertyName() {
            return "defaultJoinColumn";
        }

        @Override
        public void editJoinColumn(T subject, JoinColumn joinColumn) {
            ReferenceTableComposite.this.editJoinColumn(joinColumn);
        }

        @Override
        public boolean hasSpecifiedJoinColumns(T subject) {
            return subject.hasSpecifiedJoinColumns();
        }

        @Override
        public void removeJoinColumns(T subject, int[] selectedIndices) {
            int index = selectedIndices.length;
            while (--index >= 0) {
                subject.removeSpecifiedJoinColumn(selectedIndices[index]);
            }
        }

        @Override
        public ListIterator<JoinColumn> specifiedJoinColumns(T subject) {
            return subject.specifiedJoinColumns();
        }

        @Override
        public int specifiedJoinColumnsSize(T subject) {
            return subject.specifiedJoinColumnsSize();
        }

        @Override
        public String getSpecifiedJoinColumnsListPropertyName() {
            return "specifiedJoinColumns";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverrideDefaultJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements WritablePropertyValueModel<Boolean> {
        public OverrideDefaultJoinColumnHolder() {
            super(ReferenceTableComposite.this.buildSpecifiedJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            return this.listHolder.size() > 0;
        }

        public void setValue(Boolean value) {
            ReferenceTableComposite.this.updateJoinColumns();
        }
    }
}

