/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.internal.types.BooleanLiteralType;
import org.eclipse.jst.jsf.common.internal.types.NullLiteralType;
import org.eclipse.jst.jsf.common.internal.types.StringLiteralType;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.UnaryOperator;

class EmptyUnaryOperator
extends UnaryOperator {
    private static final String EMPTY = "empty";

    EmptyUnaryOperator(DiagnosticFactory diagnosticFactory) {
        super(diagnosticFactory);
    }

    public ValueType performOperation(ValueType type) {
        if (type instanceof StringLiteralType) {
            if ("".equals(((StringLiteralType)type).getLiteralValue())) {
                return BooleanLiteralType.TRUE;
            }
            return BooleanLiteralType.FALSE;
        }
        if (type instanceof NullLiteralType) {
            return BooleanLiteralType.TRUE;
        }
        String testSig = type.getSignature();
        if (!("Ljava.lang.String;".equals(testSig) || type.isInstanceOf("Ljava.util.Collection;") || type.isInstanceOf("Ljava.util.Map;") || Signature.getTypeSignatureKind((String)testSig) == 4)) {
            return BooleanLiteralType.FALSE;
        }
        return new ValueType("Z", type.getAssignability());
    }

    public Diagnostic validate(ValueType type) {
        if (type instanceof StringLiteralType) {
            String condition = "".equals(((StringLiteralType)type).getLiteralValue()) ? "true" : "false";
            return this._diagnosticFactory.create_UNARY_OP_CONSTANT_EXPRESSION_EVAL_SAME_ID(EMPTY, condition);
        }
        if (type instanceof NullLiteralType) {
            return this._diagnosticFactory.create_UNARY_OP_CONSTANT_EXPRESSION_EVAL_SAME_ID(EMPTY, "true");
        }
        String testSig = type.getSignature();
        if (!("Ljava.lang.String;".equals(testSig) || type.isInstanceOf("Ljava.util.Collection;") || type.isInstanceOf("Ljava.util.Map;") || Signature.getTypeSignatureKind((String)testSig) == 4)) {
            return this._diagnosticFactory.create_UNARY_OP_EMPTY_ALWAYS_FALSE_ON_TYPE();
        }
        return Diagnostic.OK_INSTANCE;
    }
}

