/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation.errorcustomization;

import java.util.Stack;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationInfo;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.ElementInformation;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.ErrorCustomizationRegistry;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.IErrorMessageCustomizer;

public class ErrorCustomizationManager {
    protected Stack elementInformationStack = new Stack();
    protected ErrorMessageInformation messageForConsideration;

    public void startElement(String uri, String localName) {
        ElementInformation elementInformation = new ElementInformation(uri, localName);
        if (this.elementInformationStack.size() > 0) {
            ElementInformation parent = (ElementInformation)this.elementInformationStack.peek();
            parent.children.add(elementInformation);
        }
        this.elementInformationStack.push(elementInformation);
    }

    public void endElement(String uri, String localName) {
        if (this.elementInformationStack.size() > 0) {
            ElementInformation elementInformation = (ElementInformation)this.elementInformationStack.pop();
            if (this.messageForConsideration != null) {
                IErrorMessageCustomizer[] customizers = ErrorCustomizationRegistry.getInstance().getCustomizers(elementInformation.getNamespace());
                int numCustomizers = customizers.length;
                int i = 0;
                while (i < numCustomizers) {
                    String message = customizers[i].customizeMessage(elementInformation, this.messageForConsideration.key, this.messageForConsideration.arguments);
                    if (message != null) {
                        this.messageForConsideration.message.setMessage(message);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public void considerReportedError(ValidationInfo valInfo, String key, Object[] arguments) {
        this.messageForConsideration = null;
        ValidationMessage[] messages = valInfo.getValidationMessages();
        if (messages.length > 0) {
            this.messageForConsideration = new ErrorMessageInformation();
            this.messageForConsideration.key = key;
            this.messageForConsideration.arguments = arguments;
            this.messageForConsideration.message = messages[messages.length - 1];
        }
    }

    public class ErrorMessageInformation {
        public String key = null;
        public Object[] arguments = null;
        public ValidationMessage message = null;
    }
}

