/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ui.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsController;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerHelper;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerManager;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.ejb.provider.BeanClassProviderHelper;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.swt.graphics.Image;

public class AnnotationIconDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    protected static final String ANNOTATION_IMAGE_DESC_STRING = "annotation_bean_overlay";
    protected static final String ANNOTATION_DISABLED_IMAGE_DESC_STRING = "dis_annotation_bean_overlay";
    private static final ImageDescriptor ANNOTATION_IMG_DESC = AnnotationIconDecorator.getImageDescriptor("annotation_bean_overlay");
    private static final ImageDescriptor ANNOTATION_DISABLED_IMG_DESC = AnnotationIconDecorator.getImageDescriptor("dis_annotation_bean_overlay");

    private boolean isAnnotatedSupported(EObject target) {
        boolean bAnnotationSupported = false;
        if (AnnotationsControllerHelper.INSTANCE.isAnnotated(target)) {
            bAnnotationSupported = true;
        }
        return bAnnotationSupported;
    }

    private AnnotationsController getControllerForProject(IProject targetProject) {
        AnnotationsController controller = AnnotationsControllerManager.INSTANCE.getAnnotationsController(targetProject);
        return controller;
    }

    public void decorate(Object element, IDecoration decoration) {
        EnterpriseBean eObject = null;
        if (element instanceof BeanClassProviderHelper) {
            BeanClassProviderHelper beanClassHelper = (BeanClassProviderHelper)element;
            eObject = beanClassHelper.getEjb();
        } else if (element instanceof EnterpriseBean || element instanceof Servlet) {
            eObject = (EObject)element;
        }
        if (eObject == null) {
            return;
        }
        if (this.isAnnotatedSupported((EObject)eObject)) {
            if (this.isAnnotationEnabled((EObject)eObject)) {
                if (ANNOTATION_IMG_DESC != null) {
                    decoration.addOverlay(ANNOTATION_IMG_DESC);
                }
            } else if (ANNOTATION_DISABLED_IMG_DESC != null) {
                decoration.addOverlay(ANNOTATION_DISABLED_IMG_DESC);
            }
        }
    }

    private boolean isAnnotationEnabled(EObject eObject) {
        IProject targetProject;
        AnnotationsController controller;
        IFile annotatedSource = null;
        if (AnnotationsControllerManager.INSTANCE.isAnyAnnotationsSupported() && (controller = this.getControllerForProject(targetProject = ProjectUtilities.getProject((EObject)eObject))) != null) {
            annotatedSource = controller.getEnabledAnnotationFile(eObject);
        }
        return annotatedSource != null;
    }

    public Image decorateImage(Image image, Object element) {
        return image;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    protected static ImageDescriptor getImageDescriptor(String imageFileName) {
        if (imageFileName != null) {
            return J2EEUIPlugin.getDefault().getImageDescriptor(imageFileName);
        }
        return null;
    }
}

