/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.internal.util;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAnyElement;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.util.CMValidator;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMVisitor;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMValidator
extends CMValidator {
    protected String getNamespaceURI(Node node) {
        return DOMNamespaceHelper.getNamespaceURI(node);
    }

    protected String getFallbackNamepaceURI(CMElementDeclaration ed) {
        String fallbackNamepaceURI = null;
        CMDocument cmDocument = (CMDocument)ed.getProperty("CMDocument");
        if (cmDocument != null) {
            fallbackNamepaceURI = (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI");
        }
        return fallbackNamepaceURI;
    }

    public List createContentSpecificationList(Element element, CMElementDeclaration ed) {
        boolean isNamespaceAware = this.isNamespaceAware(ed);
        Vector<String> v = new Vector<String>();
        Node childNode = element.getFirstChild();
        while (childNode != null) {
            v.add(this.createContentSpecification(childNode, isNamespaceAware, isNamespaceAware ? this.getFallbackNamepaceURI(ed) : null));
            childNode = childNode.getNextSibling();
        }
        return v;
    }

    public List createContentSpecificationList(List nodeList, CMElementDeclaration ed) {
        boolean isNamespaceAware = this.isNamespaceAware(ed);
        Vector<String> v = new Vector<String>();
        Iterator i = nodeList.iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            v.add(this.createContentSpecification(node, isNamespaceAware, this.getFallbackNamepaceURI(ed)));
        }
        return v;
    }

    public String createContentSpecification(Node node, boolean isNamespaceAware, String fallbackNamepaceURI) {
        String result = "!";
        switch (node.getNodeType()) {
            case 1: {
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("jsp:")) {
                    result = "!";
                    break;
                }
                if (isNamespaceAware) {
                    result = DOMNamespaceHelper.getUnprefixedName(nodeName);
                    String uri = this.getNamespaceURI(node);
                    if (uri != null) {
                        result = "[" + uri + "]" + result;
                        break;
                    }
                    if (fallbackNamepaceURI == null) break;
                    result = "[" + fallbackNamepaceURI + "]" + result;
                    break;
                }
                result = nodeName;
                break;
            }
            case 7: {
                result = "?";
                break;
            }
            case 8: {
                result = "!";
                break;
            }
            case 4: {
                result = "\"" + node.getNodeName() + "\"";
                break;
            }
            case 3: {
                String data = ((Text)node).getData();
                result = data != null && data.trim().length() > 0 ? "\"" + node.getNodeName() + "\"" : "!";
            }
        }
        return result;
    }

    public List createContentSpecificationList(CMNode cmNode) {
        Vector<String> list = new Vector<String>();
        switch (cmNode.getNodeType()) {
            case 5: {
                list.add(this.createContentSpecificationForCMElementDeclaration((CMElementDeclaration)cmNode));
                break;
            }
            case 3: {
                list.add("\"" + cmNode.getNodeName() + "\"");
                break;
            }
            case 7: {
                this.createContentSpecificationListForCMGroup((CMGroup)cmNode, list);
                break;
            }
            case 1: {
                list.add("*");
                break;
            }
            default: {
                list.add("!");
            }
        }
        return list;
    }

    protected String createContentSpecificationForCMElementDeclaration(CMElementDeclaration ed) {
        CMDocument document = (CMDocument)ed.getProperty("CMDocument");
        String uri = document != null ? (String)document.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI") : null;
        String string = ed.getNodeName();
        if (uri != null) {
            string = "[" + uri + "]" + string;
        }
        return string;
    }

    protected void createContentSpecificationListForCMGroup(CMGroup group, List list) {
        CMGroupContentVisitor visitor = new CMGroupContentVisitor(group, list);
        visitor.visitCMNode(group);
    }

    public boolean isNamespaceAware(CMElementDeclaration ed) {
        return ed != null ? ed.getProperty("http://org.eclipse.wst/cm/properties/isNameSpaceAware") != null : false;
    }

    public CMNode[] getOriginArray(CMElementDeclaration ed, Element element) {
        CMValidator.ElementPathRecordingResult result = new CMValidator.ElementPathRecordingResult();
        this.getOriginArray(ed, this.createContentSpecificationList(element, ed), stringContentComparitor, result);
        return result.getOriginArray();
    }

    public CMValidator.MatchModelNode getMatchModel(CMElementDeclaration ed, Element element) {
        CMValidator.MatchModelNode matchModelNode = null;
        CMValidator.PathRecordingResult result = new CMValidator.PathRecordingResult();
        this.validate(ed, this.createContentSpecificationList(element, ed), stringContentComparitor, result);
        if (result.isValid) {
            matchModelNode = result.getMatchModel();
        }
        return matchModelNode;
    }

    public List clone(List list) {
        Vector result = new Vector(list.size());
        result.addAll(list);
        return result;
    }

    public boolean canInsert(CMElementDeclaration ed, List contentSpecificationList, int insertIndex, CMNode cmNode) {
        List clonedList = this.clone(contentSpecificationList);
        this.insert(clonedList, insertIndex, cmNode);
        boolean result = this.isPartiallyValid(ed, clonedList);
        return result;
    }

    public boolean canInsert(CMElementDeclaration ed, List contentSpecificationList, int insertIndex, List cmNodeList) {
        List clonedList = this.clone(contentSpecificationList);
        this.insert(clonedList, insertIndex, cmNodeList);
        return this.isValid(ed, clonedList);
    }

    public boolean canRemove(CMElementDeclaration ed, List contentSpecificationList, int startRemoveIndex) {
        return this.canRemove(ed, contentSpecificationList, startRemoveIndex, startRemoveIndex);
    }

    public boolean canRemove(CMElementDeclaration ed, List contentSpecificationList, int startRemoveIndex, int endRemoveIndex) {
        List clonedList = this.clone(contentSpecificationList);
        this.remove(clonedList, startRemoveIndex, endRemoveIndex);
        return this.isValid(ed, clonedList);
    }

    public boolean canReplace(CMElementDeclaration ed, List contentSpecificationList, int startRemoveIndex, int endRemoveIndex, CMNode cmNode) {
        List clonedList = this.clone(contentSpecificationList);
        this.remove(clonedList, startRemoveIndex, endRemoveIndex);
        this.insert(clonedList, startRemoveIndex, cmNode);
        return this.isValid(ed, clonedList);
    }

    public boolean isValid(CMElementDeclaration ed, List contentSpecificationList) {
        CMValidator.Result result = new CMValidator.Result();
        this.validate(ed, contentSpecificationList, stringContentComparitor, result);
        return result.isValid;
    }

    public boolean isPartiallyValid(CMElementDeclaration ed, List contentSpecificationList) {
        CMValidator.ElementPathRecordingResult result = new CMValidator.ElementPathRecordingResult();
        this.validate(ed, contentSpecificationList, stringContentComparitor, result);
        int count = this.getElementCount(contentSpecificationList);
        return result.getPartialValidationCount() >= count;
    }

    public int getElementCount(List contentSpecificationList) {
        int count = 0;
        Iterator i = contentSpecificationList.iterator();
        while (i.hasNext()) {
            if (!stringContentComparitor.isElement(i.next())) continue;
            ++count;
        }
        return count;
    }

    protected CMValidator.Result validate(CMElementDeclaration ed, Element element) {
        CMValidator.Result result = new CMValidator.Result();
        this.validate(ed, this.createContentSpecificationList(element, ed), stringContentComparitor, result);
        return result;
    }

    protected void remove(List stringList, int startRemoveIndex, int endRemoveIndex) {
        if (startRemoveIndex != -1) {
            int i = startRemoveIndex;
            while (i <= endRemoveIndex) {
                stringList.remove(i);
                ++i;
            }
        }
    }

    protected void insert(List stringList, int insertIndex, CMNode cmNode) {
        if (insertIndex != -1) {
            stringList.addAll(insertIndex, this.createContentSpecificationList(cmNode));
        }
    }

    protected void insert(List stringList, int insertIndex, List cmNodeList) {
        if (insertIndex != -1) {
            int insertListSize = cmNodeList.size();
            int i = insertListSize - 1;
            while (i >= 0) {
                CMNode cmNode = (CMNode)cmNodeList.get(i);
                stringList.addAll(insertIndex, this.createContentSpecificationList(cmNode));
                --i;
            }
        }
    }

    protected class CMGroupContentVisitor
    extends CMVisitor {
        protected CMGroup root;
        protected List list;

        public CMGroupContentVisitor(CMGroup root, List list) {
            this.root = root;
            this.list = list;
        }

        public void visitCMElementDeclaration(CMElementDeclaration ed) {
            if (ed.getMinOccur() > 0) {
                this.list.add(DOMValidator.this.createContentSpecificationForCMElementDeclaration(ed));
            }
        }

        public void visitCMAnyElement(CMAnyElement anyElement) {
            this.list.add("*");
        }

        public void visitCMGroup(CMGroup group) {
            if (group == this.root || group.getMinOccur() > 0) {
                CMNodeList nodeList;
                int op = group.getOperator();
                if (op == 1) {
                    super.visitCMGroup(group);
                } else if (op == 2 && (nodeList = group.getChildNodes()).getLength() > 0) {
                    this.visitCMNode(nodeList.item(0));
                }
            }
        }
    }
}

