/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.command;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.HandlerDescriptionHolder;
import org.eclipse.jst.ws.internal.consumption.ui.common.HandlerServiceRefHolder;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.HandlerTableItem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.ui.eclipse.EnvironmentUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class GenerateHandlerSkeletonCommand
extends AbstractDataModelOperation {
    private IPath outputLocation_;
    private boolean genSkeleton_;
    private String handlerNameForEdit_ = null;
    private HandlerServiceRefHolder[] handlerServiceRefHolder_;
    private HandlerDescriptionHolder[] handlerDescriptionHolder_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus returnStatus = Status.OK_STATUS;
        if (!this.genSkeleton_) {
            return returnStatus;
        }
        if (this.handlerDescriptionHolder_ != null) {
            int i = 0;
            while (i < this.handlerDescriptionHolder_.length) {
                Hashtable<String, IPath> handlerTable = new Hashtable<String, IPath>();
                IPath outPath = this.handlerDescriptionHolder_[i].getSourceOutputPath();
                List handlers = this.handlerDescriptionHolder_[i].getHandlerList();
                int j = 0;
                while (j < handlers.size()) {
                    HandlerTableItem hti = (HandlerTableItem)handlers.get(j);
                    String className = hti.getHandlerClassName();
                    if (className != null && outPath != null) {
                        handlerTable.put(className, outPath);
                    }
                    ++j;
                }
                returnStatus = this.genHandlersClasses(handlerTable, monitor);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.handlerServiceRefHolder_.length) {
                Hashtable<String, IPath> handlerTable = new Hashtable<String, IPath>();
                IPath outPath = this.handlerServiceRefHolder_[i].getSourceOutputPath();
                List handlers = this.handlerServiceRefHolder_[i].getHandlerList();
                int j = 0;
                while (j < handlers.size()) {
                    HandlerTableItem hti = (HandlerTableItem)handlers.get(j);
                    String className = hti.getHandlerClassName();
                    if (className != null && outPath != null) {
                        handlerTable.put(className, outPath);
                    }
                    ++j;
                }
                returnStatus = this.genHandlersClasses(handlerTable, monitor);
                ++i;
            }
        }
        return returnStatus;
    }

    private IStatus genHandlersClasses(Hashtable handlersForGen, IProgressMonitor monitor) {
        IEnvironment env = this.getEnvironment();
        MultiStatus status = null;
        IStatus returnStatus = Status.OK_STATUS;
        boolean error = false;
        Enumeration keys = handlersForGen.keys();
        while (keys.hasMoreElements()) {
            String className = (String)keys.nextElement();
            IStatus writeStatus = this.writeFile(env, className, (IPath)handlersForGen.get(className), monitor);
            if (writeStatus.getSeverity() != 4) continue;
            error = true;
            if (status == null) {
                status = StatusUtils.multiStatus((String)ConsumptionUIMessages.MSG_ERROR_GENERATE_HANDLER_SKELETON, (IStatus[])new IStatus[0]);
            }
            status.add(writeStatus);
        }
        if (error) {
            env.getStatusHandler().reportError(status);
            returnStatus = status;
        }
        return returnStatus;
    }

    private IStatus writeFile(IEnvironment env, String className, IPath outputLocation, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        String simpleClassName = className;
        String packageName = null;
        IPath filePath = outputLocation;
        if (className != null) {
            int index = className.lastIndexOf(46);
            if (index != -1) {
                simpleClassName = className.substring(index + 1);
                String packageSegment = packageName = className.substring(0, index);
                int j = 0;
                j = packageSegment.indexOf(46);
                while (j != -1) {
                    filePath = filePath.append(packageSegment.substring(0, j));
                    packageSegment = packageSegment.substring(j + 1);
                    j = packageSegment.indexOf(46);
                }
                filePath = filePath.append(packageSegment);
            } else {
                packageName = "";
            }
        }
        filePath = filePath.append(simpleClassName);
        IResource workspaceRes = ResourceUtils.findResource((IPath)(filePath = filePath.addFileExtension("java")));
        if (workspaceRes != null && workspaceRes.exists()) {
            return status;
        }
        if (this.handlerNameForEdit_ == null) {
            this.handlerNameForEdit_ = className;
            this.outputLocation_ = outputLocation;
        }
        OutputStream outputStream = FileResourceUtils.newFileOutputStream((ResourceContext)EnvironmentUtils.getResourceContext((IEnvironment)env), (IPath)filePath, (IProgressMonitor)monitor, (IStatusHandler)env.getStatusHandler());
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream));
        try {
            if (packageName.length() != 0) {
                bw.write("package " + packageName + ";");
                bw.newLine();
                bw.newLine();
            }
            bw.write("import javax.xml.rpc.handler.GenericHandler;");
            bw.newLine();
            bw.write("import javax.xml.rpc.handler.MessageContext;");
            bw.newLine();
            bw.write("import javax.xml.namespace.QName;");
            bw.newLine();
            bw.newLine();
            bw.write("public class " + simpleClassName + " extends GenericHandler");
            bw.newLine();
            bw.write("{");
            bw.newLine();
            bw.newLine();
            bw.write("   public QName[] getHeaders ()");
            bw.newLine();
            bw.write("   {");
            bw.newLine();
            bw.write("      // Fill in method body");
            bw.newLine();
            bw.write("      return null;");
            bw.newLine();
            bw.write("   }");
            bw.newLine();
            bw.newLine();
            bw.write("   public boolean handleRequest( MessageContext context )");
            bw.newLine();
            bw.write("   {");
            bw.newLine();
            bw.write("      // Fill in method body or delete method to use GenericHandler");
            bw.newLine();
            bw.write("      return true;");
            bw.newLine();
            bw.write("   }");
            bw.newLine();
            bw.newLine();
            bw.write("   public boolean handleResponse( MessageContext context )");
            bw.newLine();
            bw.write("   {");
            bw.newLine();
            bw.write("      // Fill in method body or delete method to use GenericHandler ");
            bw.newLine();
            bw.write("      return true;");
            bw.newLine();
            bw.write("   }");
            bw.newLine();
            bw.newLine();
            bw.write("   public boolean handleFault( MessageContext context )");
            bw.newLine();
            bw.write("   {");
            bw.newLine();
            bw.write("      // Fill in method body or delete method to use GenericHandler");
            bw.newLine();
            bw.write("      return true;");
            bw.newLine();
            bw.write("   }");
            bw.newLine();
            bw.newLine();
            bw.write("}");
            bw.close();
            status = Status.OK_STATUS;
        }
        catch (IOException e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_WRITE_FILE, (Object[])new String[]{className}), (Throwable)e);
            try {
                bw.close();
            }
            catch (IOException iOException) {}
        }
        return status;
    }

    public void setGenSkeletonEnabled(boolean genSkeleton) {
        this.genSkeleton_ = genSkeleton;
    }

    public IProject getProject() {
        IProject project = null;
        if (this.outputLocation_ != null) {
            project = ResourceUtils.getProjectOf((IPath)this.outputLocation_);
        }
        return project;
    }

    public List getClassNames() {
        ArrayList<String> classes = new ArrayList<String>();
        if (this.handlerNameForEdit_ != null) {
            classes.add(this.handlerNameForEdit_);
        }
        return classes;
    }

    public void setHandlerServiceRefHolder(HandlerServiceRefHolder[] handlerHolders) {
        this.handlerServiceRefHolder_ = handlerHolders;
    }

    public void setHandlerDescriptionHolders(HandlerDescriptionHolder[] handlerHolders) {
        this.handlerDescriptionHolder_ = handlerHolders;
    }
}

