/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions;

import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions.DetectNonJavaCharsMethodVisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions.VisitorActionImpl;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitors.JavaMofMethodVisitor;

public class DetectNonJavaCharsBeanVisitorAction
extends VisitorActionImpl {
    private static char UNDERSCORE = (char)95;

    public DetectNonJavaCharsBeanVisitorAction(Vector messages, Vector beans) {
        super(messages, beans);
    }

    public IStatus visit(Object javaclass) {
        JavaClass javaClass = (JavaClass)javaclass;
        String packageName = javaClass.getJavaPackage().getPackageName();
        String beanName = javaClass.getName();
        if (!this.isBeanVisited(javaClass)) {
            this.addVisitedBean(javaClass);
            this.checkBeanName(beanName);
            this.checkPackageName(packageName, beanName);
            DetectNonJavaCharsMethodVisitorAction methodVisitorAction = new DetectNonJavaCharsMethodVisitorAction(this.getMessages(), this.getBeansVisited());
            JavaMofMethodVisitor methodVisitor = new JavaMofMethodVisitor();
            methodVisitor.run(javaClass, methodVisitorAction);
        }
        return Status.OK_STATUS;
    }

    private void checkBeanName(String beanName) {
        if (Character.isLowerCase(beanName.charAt(0))) {
            this.addMessage(ConsumptionMessages.WARN_BEAN_NAME_STARTS_WITH_LOWER_CASE, new String[]{beanName});
        }
        int underScoreIndex = beanName.indexOf(UNDERSCORE);
        String tempName = beanName;
        while (underScoreIndex != -1) {
            if (Character.isLowerCase((tempName = tempName.substring(underScoreIndex + 1)).charAt(0))) {
                this.addMessage(ConsumptionMessages.MSG_WARN_METHOD_NAME_INVALID, new String[]{beanName});
                break;
            }
            underScoreIndex = tempName.indexOf(UNDERSCORE);
        }
    }

    private void checkPackageName(String packageName, String beanName) {
        if (!packageName.equals(packageName.toLowerCase())) {
            this.addMessage(ConsumptionMessages.MSG_WARN_PACKAGE_NAME_HAS_UPPER_CASE, new String[]{packageName, beanName});
        }
    }
}

