/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptFunctionBreakpoint;
import org.eclipse.wst.jsdt.debug.core.jsdi.Location;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.BreakpointRequest;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;

public class JavaScriptFunctionBreakpoint
extends JavaScriptLineBreakpoint
implements IJavaScriptFunctionBreakpoint {
    private static final String ENTRY = "org.eclipse.wst.jsdt.debug.core.entry";
    private static final String EXIT = "org.eclipse.wst.jsdt.debug.core.exit";

    public JavaScriptFunctionBreakpoint() {
    }

    public JavaScriptFunctionBreakpoint(final IResource resource, final String name, final String signature, final int charstart, final int charend, final Map attributes, final boolean register) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JavaScriptFunctionBreakpoint.this.setMarker(resource.createMarker("org.eclipse.wst.jsdt.debug.core.function.breakpoint.marker"));
                attributes.put("org.eclipse.debug.core.id", JavaScriptFunctionBreakpoint.this.getModelIdentifier());
                attributes.put("org.eclipse.debug.core.enabled", true);
                attributes.put("org.eclipse.wst.jsdt.debug.core.function_name", name);
                attributes.put("org.eclipse.wst.jsdt.debug.core.function_signature", signature);
                attributes.put("charStart", new Integer(charstart));
                attributes.put("charEnd", new Integer(charend));
                attributes.put(JavaScriptFunctionBreakpoint.ENTRY, true);
                JavaScriptFunctionBreakpoint.this.ensureMarker().setAttributes(attributes);
                JavaScriptFunctionBreakpoint.this.register(register);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public String getFunctionName() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.wst.jsdt.debug.core.function_name", null);
    }

    public String getSignature() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.wst.jsdt.debug.core.function_signature", null);
    }

    protected boolean createRequest(JavaScriptDebugTarget target, ScriptReference script) throws CoreException {
        Location loc = script.functionLocation(this.getFunctionName());
        if (loc == null) {
            return false;
        }
        BreakpointRequest request = target.getEventRequestManager().createBreakpointRequest(loc);
        this.registerRequest(target, request);
        this.configureRequest(request);
        request.setEnabled(this.isEnabled());
        return true;
    }

    public boolean isEntry() throws CoreException {
        return this.ensureMarker().getAttribute(ENTRY, false);
    }

    public void setEntry(boolean isentry) throws CoreException {
        if (isentry != this.isEntry()) {
            if (isentry && !this.isEnabled()) {
                this.setAttributes(new String[]{ENTRY, "org.eclipse.debug.core.enabled"}, new Object[]{isentry, Boolean.TRUE});
            } else if (!this.isExit()) {
                this.setAttributes(new String[]{ENTRY, "org.eclipse.debug.core.enabled"}, new Object[]{isentry, Boolean.FALSE});
            } else {
                this.setAttribute(ENTRY, isentry);
            }
            this.handleBreakpointChange();
        }
    }

    public boolean isExit() throws CoreException {
        return this.ensureMarker().getAttribute(EXIT, false);
    }

    public void setExit(boolean isexit) throws CoreException {
        if (isexit != this.isExit()) {
            if (isexit && !this.isEnabled()) {
                this.setAttributes(new String[]{EXIT, "org.eclipse.debug.core.enabled"}, new Object[]{isexit, Boolean.TRUE});
            } else if (!this.isEntry()) {
                this.setAttributes(new String[]{EXIT, "org.eclipse.debug.core.enabled"}, new Object[]{isexit, Boolean.FALSE});
            } else {
                this.setAttribute(EXIT, isexit);
            }
        }
    }
}

