/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core;

import org.eclipse.core.runtime.content.IContentType;

public class JpaResourceType {
    private final IContentType contentType;
    private final String version;
    public static final String UNDETERMINED_VERSION = "<undetermined>";

    public JpaResourceType(IContentType contentType) {
        this(contentType, UNDETERMINED_VERSION);
    }

    public JpaResourceType(IContentType contentType, String version) {
        if (contentType == null) {
            throw new NullPointerException("content type");
        }
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.contentType = contentType;
        this.version = version;
    }

    public IContentType getContentType() {
        return this.contentType;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        JpaResourceType other = (JpaResourceType)obj;
        return this.contentType.equals(other.contentType) && this.version.equals(other.version);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.contentType.hashCode();
        hash = hash * 31 + this.version.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(content = ");
        sb.append(this.contentType);
        sb.append(", ");
        sb.append("version = ");
        sb.append(this.version);
        sb.append(')');
        return sb.toString();
    }
}

