/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request;

import org.eclipse.wst.jsdt.debug.core.jsdi.ThreadReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.StepRequest;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.ThreadReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.VirtualMachineImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.EventRequestImpl;

public class StepRequestImpl
extends EventRequestImpl
implements StepRequest {
    private final ThreadReferenceImpl thread;
    private final int step;

    public StepRequestImpl(VirtualMachineImpl vm, ThreadReference thread, int step) {
        super(vm);
        this.thread = (ThreadReferenceImpl)thread;
        this.step = step;
    }

    public int step() {
        return this.step;
    }

    public ThreadReference thread() {
        return this.thread;
    }

    public synchronized void setEnabled(boolean enabled) {
        this.checkDeleted();
        if (this.enabled == enabled) {
            return;
        }
        if (enabled) {
            String stepType = null;
            if (this.step == 1) {
                stepType = "in";
            } else if (this.step == 2) {
                stepType = "next";
            } else if (this.step == 3) {
                stepType = "out";
            }
            if (this.thread.getStep() != null) {
                throw new IllegalStateException("duplicate step");
            }
            this.thread.setStep(stepType);
        } else {
            this.thread.setStep(null);
        }
        this.enabled = enabled;
    }
}

