/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.facet;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;

public class RuntimeChangedListener
implements IFacetedProjectListener {
    public void handleEvent(IFacetedProjectEvent facetedProjectEvent) {
        IProjectFacetVersion pfv;
        IFacetedProjectWorkingCopy fpb = facetedProjectEvent.getWorkingCopy();
        if (fpb == null) {
            fpb = facetedProjectEvent.getProject();
        }
        if ((pfv = fpb.getProjectFacetVersion(ProjectFacetsManager.getProjectFacet((String)"jpt.jpa"))) != null) {
            HashMap<String, String> enablementVariables = new HashMap<String, String>();
            enablementVariables.put("jpaPlatform", this.getJpaPlatformId(fpb.getProject()));
            LibraryInstallDelegate lp = new LibraryInstallDelegate((IFacetedProjectBase)fpb, pfv, enablementVariables);
            try {
                lp.execute((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                JptCorePlugin.log(ce);
            }
        }
    }

    protected String getJpaPlatformId(IProject project) {
        JpaProject jpaProject = JptCorePlugin.getJpaProject(project);
        return jpaProject == null ? null : jpaProject.getJpaPlatform().getId();
    }
}

