/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCacheListener;

public class CMDocumentCache {
    public static final int STATUS_NOT_LOADED = 0;
    public static final int STATUS_LOADING = 2;
    public static final int STATUS_LOADED = 3;
    public static final int STATUS_ERROR = 4;
    protected Hashtable hashtable;
    protected List listenerList = new Vector();

    public CMDocumentCache() {
        this.hashtable = new Hashtable();
    }

    public void addListener(CMDocumentCacheListener listener) {
        this.listenerList.add(listener);
    }

    public void removeListener(CMDocumentCacheListener listener) {
        this.listenerList.remove(listener);
    }

    public CMDocument getCMDocument(String grammarURI) {
        Entry entry;
        CMDocument result = null;
        if (grammarURI != null && (entry = (Entry)this.hashtable.get(grammarURI)) != null) {
            result = entry.cmDocument;
        }
        return result;
    }

    public int getStatus(String grammarURI) {
        Entry entry;
        int result = 0;
        if (grammarURI != null && (entry = (Entry)this.hashtable.get(grammarURI)) != null) {
            result = entry.status;
        }
        return result;
    }

    protected Entry lookupOrCreate(String grammarURI) {
        Entry entry = (Entry)this.hashtable.get(grammarURI);
        if (entry == null) {
            entry = new Entry(grammarURI);
            this.hashtable.put(grammarURI, entry);
        }
        return entry;
    }

    public void putCMDocument(String grammarURI, CMDocument cmDocument) {
        if (grammarURI != null && cmDocument != null) {
            Entry entry = this.lookupOrCreate(grammarURI);
            int oldStatus = entry.status;
            entry.status = 3;
            entry.cmDocument = cmDocument;
            this.notifyCacheUpdated(grammarURI, oldStatus, entry.status, entry.cmDocument);
        }
    }

    public void setStatus(String grammarURI, int status) {
        if (grammarURI != null) {
            Entry entry = this.lookupOrCreate(grammarURI);
            int oldStatus = entry.status;
            entry.status = status;
            this.notifyCacheUpdated(grammarURI, oldStatus, entry.status, entry.cmDocument);
        }
    }

    public void clear() {
        this.hashtable.clear();
        this.notifyCacheCleared();
    }

    protected void notifyCacheUpdated(String uri, int oldStatus, int newStatus, CMDocument cmDocument) {
        Vector list = new Vector();
        list.addAll(this.listenerList);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            CMDocumentCacheListener listener = (CMDocumentCacheListener)i.next();
            listener.cacheUpdated(this, uri, oldStatus, newStatus, cmDocument);
        }
    }

    protected void notifyCacheCleared() {
        Vector list = new Vector();
        list.addAll(this.listenerList);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            CMDocumentCacheListener listener = (CMDocumentCacheListener)i.next();
            listener.cacheCleared(this);
        }
    }

    public List getCMDocuments() {
        ArrayList<CMDocument> list = new ArrayList<CMDocument>();
        Iterator i = this.hashtable.values().iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            list.add(entry.cmDocument);
        }
        return list;
    }

    protected class Entry {
        public String uri;
        public int status = 0;
        public float progress;
        public CMDocument cmDocument;

        public Entry(String uri) {
            this.uri = uri;
        }

        public Entry(String uri, int status, CMDocument cmDocument) {
            this.uri = uri;
            this.status = status;
            this.cmDocument = cmDocument;
        }
    }
}

