/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceOverrideAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.NestableJoinColumnAnnotation;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceAssociationOverrideAnnotation
extends SourceOverrideAnnotation
implements NestableAssociationOverrideAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AssociationOverride");
    private final Vector<NestableJoinColumnAnnotation> joinColumns = new Vector();
    private final JoinColumnsAnnotationContainer joinColumnsContainer = new JoinColumnsAnnotationContainer();

    protected SourceAssociationOverrideAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.AssociationOverride";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        AnnotationContainerTools.initialize(this.joinColumnsContainer, astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        AnnotationContainerTools.synchronize(this.joinColumnsContainer, astRoot);
    }

    @Override
    protected String getNameElementName() {
        return "name";
    }

    @Override
    public ListIterator<JoinColumnAnnotation> joinColumns() {
        return new CloneListIterator(this.joinColumns);
    }

    Iterable<NestableJoinColumnAnnotation> getNestableJoinColumns() {
        return new LiveCloneIterable(this.joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.joinColumns.size();
    }

    @Override
    public NestableJoinColumnAnnotation joinColumnAt(int index) {
        return this.joinColumns.get(index);
    }

    @Override
    public int indexOfJoinColumn(JoinColumnAnnotation joinColumn) {
        return this.joinColumns.indexOf(joinColumn);
    }

    @Override
    public NestableJoinColumnAnnotation addJoinColumn(int index) {
        return (NestableJoinColumnAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation addJoinColumn_() {
        return this.addJoinColumn_(this.joinColumns.size());
    }

    private NestableJoinColumnAnnotation addJoinColumn_(int index) {
        NestableJoinColumnAnnotation joinColumn = this.buildJoinColumn(index);
        this.joinColumns.add(joinColumn);
        return joinColumn;
    }

    void syncAddJoinColumn(Annotation astAnnotation) {
        int index = this.joinColumns.size();
        NestableJoinColumnAnnotation joinColumn = this.addJoinColumn_(index);
        joinColumn.initialize((CompilationUnit)astAnnotation.getRoot());
        this.fireItemAdded("joinColumns", index, joinColumn);
    }

    private NestableJoinColumnAnnotation buildJoinColumn(int index) {
        return SourceJoinColumnAnnotation.createAssociationOverrideJoinColumn(this.daa, this, this.member, index);
    }

    void joinColumnAdded(int index, NestableJoinColumnAnnotation joinColumn) {
        this.fireItemAdded("joinColumns", index, joinColumn);
    }

    @Override
    public void moveJoinColumn(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation moveJoinColumn_(int targetIndex, int sourceIndex) {
        return (NestableJoinColumnAnnotation)CollectionTools.move(this.joinColumns, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    @Override
    public void removeJoinColumn(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation removeJoinColumn_(int index) {
        return this.joinColumns.remove(index);
    }

    void syncRemoveJoinColumns(int index) {
        this.removeItemsFromList(index, this.joinColumns, "joinColumns");
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        AssociationOverrideAnnotation oldOverride = (AssociationOverrideAnnotation)((Object)oldAnnotation);
        for (JoinColumnAnnotation oldJoinColumn : CollectionTools.iterable(oldOverride.joinColumns())) {
            NestableJoinColumnAnnotation newJoinColumn = this.addJoinColumn(oldOverride.indexOfJoinColumn(oldJoinColumn));
            newJoinColumn.initializeFrom((NestableAnnotation)((Object)oldJoinColumn));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JoinColumnsAnnotationContainer
    implements AnnotationContainer<NestableJoinColumnAnnotation> {
        JoinColumnsAnnotationContainer() {
        }

        @Override
        public Annotation getAstAnnotation(CompilationUnit astRoot) {
            return SourceAssociationOverrideAnnotation.this.getAstAnnotation(astRoot);
        }

        @Override
        public String getElementName() {
            return "joinColumns";
        }

        @Override
        public String getNestedAnnotationName() {
            return "javax.persistence.JoinColumn";
        }

        @Override
        public Iterable<NestableJoinColumnAnnotation> getNestedAnnotations() {
            return SourceAssociationOverrideAnnotation.this.getNestableJoinColumns();
        }

        @Override
        public int getNestedAnnotationsSize() {
            return SourceAssociationOverrideAnnotation.this.joinColumnsSize();
        }

        @Override
        public NestableJoinColumnAnnotation addNestedAnnotation() {
            return SourceAssociationOverrideAnnotation.this.addJoinColumn_();
        }

        @Override
        public void syncAddNestedAnnotation(Annotation astAnnotation) {
            SourceAssociationOverrideAnnotation.this.syncAddJoinColumn(astAnnotation);
        }

        @Override
        public NestableJoinColumnAnnotation moveNestedAnnotation(int targetIndex, int sourceIndex) {
            return SourceAssociationOverrideAnnotation.this.moveJoinColumn_(targetIndex, sourceIndex);
        }

        @Override
        public NestableJoinColumnAnnotation removeNestedAnnotation(int index) {
            return SourceAssociationOverrideAnnotation.this.removeJoinColumn_(index);
        }

        @Override
        public void syncRemoveNestedAnnotations(int index) {
            SourceAssociationOverrideAnnotation.this.syncRemoveJoinColumns(index);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

