/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.Arrays;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableUniqueConstraintAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceUniqueConstraintAnnotation
extends SourceAnnotation<Member>
implements NestableUniqueConstraintAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.UniqueConstraint");
    private final DeclarationAnnotationElementAdapter<String[]> columnNamesDeclarationAdapter;
    private final AnnotationElementAdapter<String[]> columnNamesAdapter;
    private final Vector<String> columnNames = new Vector();

    public SourceUniqueConstraintAnnotation(JavaResourceNode parent, Member member, IndexedDeclarationAnnotationAdapter idaa) {
        super(parent, member, idaa, new MemberIndexedAnnotationAdapter(member, idaa));
        this.columnNamesDeclarationAdapter = SourceUniqueConstraintAnnotation.buildArrayAnnotationElementAdapter(idaa, "columnNames");
        this.columnNamesAdapter = this.buildAnnotationElementAdapter(this.columnNamesDeclarationAdapter);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.UniqueConstraint";
    }

    private AnnotationElementAdapter<String[]> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String[]> daea) {
        return new MemberAnnotationElementAdapter<String[]>(this.member, daea);
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return SourceUniqueConstraintAnnotation.buildArrayAnnotationElementAdapter(annotationAdapter, elementName, AnnotationStringArrayExpressionConverter.forStrings());
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String[]> converter) {
        return new ConversionDeclarationAnnotationElementAdapter<String[]>(annotationAdapter, elementName, false, converter);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.initializeColumnNames(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncColumnNames(astRoot);
    }

    public IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.columnNames);
    }

    @Override
    public ListIterator<String> columnNames() {
        return new CloneListIterator(this.columnNames);
    }

    @Override
    public int columnNamesSize() {
        return this.columnNames.size();
    }

    @Override
    public void addColumnName(String columnName) {
        this.addColumnName(this.columnNames.size(), columnName);
    }

    @Override
    public void addColumnName(int index, String columnName) {
        this.columnNames.add(index, columnName);
        this.writeColumnNames();
    }

    @Override
    public void moveColumnName(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.columnNames, (int)targetIndex, (int)sourceIndex);
        this.writeColumnNames();
    }

    @Override
    public void removeColumnName(String columnName) {
        this.columnNames.remove(columnName);
        this.writeColumnNames();
    }

    @Override
    public void removeColumnName(int index) {
        this.columnNames.remove(index);
        this.writeColumnNames();
    }

    private void writeColumnNames() {
        this.columnNamesAdapter.setValue(this.columnNames.toArray(new String[this.columnNames.size()]));
    }

    private void initializeColumnNames(CompilationUnit astRoot) {
        String[] astColumnNames = this.columnNamesAdapter.getValue(astRoot);
        int i = 0;
        while (i < astColumnNames.length) {
            this.columnNames.add(astColumnNames[i]);
            ++i;
        }
    }

    private void syncColumnNames(CompilationUnit astRoot) {
        String[] javaColumnNames = this.columnNamesAdapter.getValue(astRoot);
        this.synchronizeList(Arrays.asList(javaColumnNames), this.columnNames, "columnNames");
    }

    @Override
    public boolean columnNamesTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.columnNamesDeclarationAdapter, pos, astRoot);
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        UniqueConstraintAnnotation oldConstraint = (UniqueConstraintAnnotation)((Object)oldAnnotation);
        for (String columnName : CollectionTools.iterable(oldConstraint.columnNames())) {
            this.addColumnName(columnName);
        }
    }

    @Override
    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }
}

