/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmBaseColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmJoinColumn
extends AbstractOrmBaseColumn<XmlJoinColumn>
implements OrmJoinColumn {
    protected String specifiedReferencedColumnName;
    protected String defaultReferencedColumnName;
    protected XmlJoinColumn resourceJoinColumn;

    public GenericOrmJoinColumn(XmlContextNode parent, OrmJoinColumn.Owner owner, XmlJoinColumn resourceJoinColumn) {
        super(parent, owner);
        this.initialize(resourceJoinColumn);
    }

    @Override
    public void initializeFrom(JoinColumn oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedReferencedColumnName(oldColumn.getSpecifiedReferencedColumnName());
    }

    @Override
    public String getReferencedColumnName() {
        return this.getSpecifiedReferencedColumnName() == null ? this.getDefaultReferencedColumnName() : this.getSpecifiedReferencedColumnName();
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.getResourceColumn().setReferencedColumnName(newSpecifiedReferencedColumnName);
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    protected void setSpecifiedReferencedColumnName_(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String newDefaultReferencedColumnName) {
        String oldDefaultReferencedColumnName = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = newDefaultReferencedColumnName;
        this.firePropertyChanged("defaultReferencedColumnName", oldDefaultReferencedColumnName, newDefaultReferencedColumnName);
    }

    @Override
    public boolean isVirtual() {
        return this.getOwner().isVirtual(this);
    }

    @Override
    public OrmJoinColumn.Owner getOwner() {
        return (OrmJoinColumn.Owner)this.owner;
    }

    @Override
    public Table getReferencedColumnDbTable() {
        return this.getOwner().getReferencedColumnDbTable();
    }

    @Override
    public Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedColumnName());
    }

    @Override
    public boolean isReferencedColumnResolved() {
        return this.getReferencedDbColumn() != null;
    }

    @Override
    public TextRange getReferencedColumnNameTextRange() {
        TextRange textRange;
        if (this.getResourceColumn() != null && (textRange = this.getResourceColumn().getReferencedColumnNameTextRange()) != null) {
            return textRange;
        }
        return this.getOwner().getValidationTextRange();
    }

    @Override
    protected XmlJoinColumn getResourceColumn() {
        return this.resourceJoinColumn;
    }

    @Override
    protected void addResourceColumn() {
    }

    @Override
    protected void removeResourceColumn() {
    }

    @Override
    protected void initialize(XmlJoinColumn xjc) {
        this.resourceJoinColumn = xjc;
        super.initialize(xjc);
        this.specifiedReferencedColumnName = this.buildSpecifiedReferencedColumnName(xjc);
        this.defaultReferencedColumnName = this.buildDefaultReferencedColumnName();
    }

    @Override
    public void update(XmlJoinColumn xjc) {
        this.resourceJoinColumn = xjc;
        super.update(xjc);
        this.setSpecifiedReferencedColumnName_(this.buildSpecifiedReferencedColumnName(xjc));
        this.setDefaultReferencedColumnName(this.buildDefaultReferencedColumnName());
    }

    protected String buildSpecifiedReferencedColumnName(XmlJoinColumn xjc) {
        return xjc == null ? null : xjc.getReferencedColumnName();
    }

    @Override
    protected String buildDefaultName() {
        return MappingTools.buildJoinColumnDefaultName(this, this.getOwner());
    }

    protected String buildDefaultReferencedColumnName() {
        return MappingTools.buildJoinColumnDefaultReferencedColumnName(this.getOwner());
    }

    @Override
    protected void validateName(List<IMessage> messages) {
        this.validateJoinColumnName(messages);
        this.validateReferencedColumnName(messages);
    }

    protected void validateJoinColumnName(List<IMessage> messages) {
        if (this.getSpecifiedName() == null && this.getOwner().joinColumnsSize() > 1) {
            messages.add(this.buildUnspecifiedNameMultipleJoinColumnsMessage());
        } else if (this.getName() != null) {
            super.validateName(messages);
        }
    }

    protected void validateReferencedColumnName(List<IMessage> messages) {
        Table refColumnDbTable;
        if (this.getSpecifiedReferencedColumnName() == null && this.getOwner().joinColumnsSize() > 1) {
            messages.add(this.buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage());
        } else if (this.getSpecifiedReferencedColumnName() != null && (refColumnDbTable = this.getReferencedColumnDbTable()) != null && !this.isReferencedColumnResolved()) {
            messages.add(this.getOwner().buildUnresolvedReferencedColumnNameMessage(this, this.getReferencedColumnNameTextRange()));
        }
    }

    protected IMessage buildUnspecifiedNameMultipleJoinColumnsMessage() {
        return this.getOwner().buildUnspecifiedNameMultipleJoinColumnsMessage(this, this.getNameTextRange());
    }

    protected IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage() {
        return this.getOwner().buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(this, this.getReferencedColumnNameTextRange());
    }
}

