/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource;

import java.io.IOException;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jem.util.emf.workbench.FlexibleProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.resource.JpaXmlResourceProvider;
import org.eclipse.jpt.core.resource.JpaXmlResourceProviderEvent;
import org.eclipse.jpt.core.resource.JpaXmlResourceProviderListener;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.utility.internal.ListenerList;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateInputProvider;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorImpl;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorPresenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXmlResourceProvider
implements JpaXmlResourceProvider,
ResourceStateInputProvider,
ResourceStateValidator {
    protected IProject project;
    protected URI fileUri;
    protected JpaXmlResource resource;
    protected IContentType contentType;
    protected final ResourceAdapter resourceAdapter = new ResourceAdapter();
    protected final ListenerList<JpaXmlResourceProviderListener> listenerList = new ListenerList(JpaXmlResourceProviderListener.class);
    protected ResourceStateValidator stateValidator;

    public AbstractXmlResourceProvider(IProject project, IPath resourcePath, IContentType contentType) {
        this.project = project;
        this.fileUri = this.buildFileUri(resourcePath);
        this.contentType = contentType;
    }

    protected URI buildFileUri(IPath resourcePath) {
        URI resourceUri = null;
        resourceUri = resourcePath.isAbsolute() ? URI.createPlatformResourceURI((String)resourcePath.toString(), (boolean)false) : this.getModuleURI(URI.createURI((String)resourcePath.toString()));
        URIConverter uriConverter = this.getResourceSet().getURIConverter();
        return uriConverter.normalize(resourceUri);
    }

    @Override
    public JpaXmlResource getXmlResource() {
        if (this.resource == null) {
            JpaXmlResource newResource = (JpaXmlResource)WorkbenchResourceHelper.getOrCreateResource((URI)this.fileUri, (ResourceSet)this.getResourceSet());
            if (newResource.getContentType().equals(this.contentType)) {
                this.resource = newResource;
            } else {
                this.createResourceAndLoad();
            }
        }
        return this.resource;
    }

    protected JpaXmlResource createResourceAndLoad() {
        this.resource = this.createResource();
        this.loadResource();
        return this.resource;
    }

    protected JpaXmlResource createResource() {
        Resource.Factory resourceFactory = WTPResourceFactoryRegistry.INSTANCE.getFactory(this.fileUri, this.contentType.getDefaultDescription());
        return (JpaXmlResource)((FlexibleProjectResourceSet)this.getResourceSet()).createResource(this.fileUri, resourceFactory);
    }

    protected void loadResource() {
        try {
            this.resource.load(((FlexibleProjectResourceSet)this.getResourceSet()).getLoadOptions());
        }
        catch (IOException e) {
            JptCorePlugin.log(e);
        }
    }

    protected void createResourceAndUnderlyingFile(Object config) {
        this.resource = this.createResource();
        if (this.resource.fileExists()) {
            this.loadResource();
        } else {
            this.populateRoot(config);
            try {
                this.resource.saveIfNecessary();
            }
            catch (Exception e) {
                JptCorePlugin.log(e);
            }
        }
    }

    public JpaXmlResource createFileAndResource(final Object config) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                AbstractXmlResourceProvider.this.createResourceAndUnderlyingFile(config);
            }
        };
        workspace.run(runnable, (ISchedulingRule)this.project, 1, null);
        return this.resource;
    }

    protected URI getModuleURI(URI uri) {
        URI moduleuri = ModuleURIUtil.fullyQualifyURI((IProject)this.project);
        IPath requestPath = new Path(moduleuri.path()).append((IPath)new Path(uri.path()));
        URI resourceURI = URI.createURI((String)("module:" + requestPath.toString()));
        return resourceURI;
    }

    protected void populateRoot(Object config) {
    }

    protected EList<EObject> getResourceContents() {
        return this.resource.getContents();
    }

    public void addListener(JpaXmlResourceProviderListener listener) {
        if (this.listenerList.isEmpty()) {
            this.engageResource();
        }
        this.listenerList.add((EventListener)listener);
    }

    public void removeListener(JpaXmlResourceProviderListener listener) {
        this.listenerList.remove((EventListener)listener);
        if (this.listenerList.isEmpty()) {
            this.disengageResource();
        }
    }

    private void engageResource() {
        if (this.resource != null) {
            this.resource.eAdapters().add((Object)this.resourceAdapter);
        }
    }

    private void disengageResource() {
        if (this.resource != null) {
            this.resource.eAdapters().remove((Object)this.resourceAdapter);
        }
    }

    protected ProjectResourceSet getResourceSet() {
        return (ProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)this.project);
    }

    public IProject getProject() {
        return this.project;
    }

    protected void resourceIsLoadedChanged(Resource aResource, boolean oldValue, boolean newValue) {
        if (!this.listenerList.isEmpty()) {
            int eventType = newValue ? 1 : 2;
            JpaXmlResourceProviderEvent evt = new JpaXmlResourceProviderEvent(this, eventType);
            this.notifyListeners(evt);
        }
    }

    protected void notifyListeners(JpaXmlResourceProviderEvent event) {
        NotifyRunner notifier = new NotifyRunner(event);
        for (JpaXmlResourceProviderListener listener : this.listenerList.getListeners()) {
            notifier.setListener(listener);
            SafeRunner.run((ISafeRunnable)notifier);
        }
    }

    @Override
    public IStatus validateEdit(Object context) {
        IWorkspace work = ResourcesPlugin.getWorkspace();
        IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
        if (file != null) {
            IFile[] files = new IFile[]{file};
            if (context == null) {
                context = IWorkspace.VALIDATE_PROMPT;
            }
            return work.validateEdit(files, context);
        }
        return Status.OK_STATUS;
    }

    public ResourceStateValidator getStateValidator() {
        if (this.stateValidator == null) {
            this.stateValidator = this.createStateValidator();
        }
        return this.stateValidator;
    }

    private ResourceStateValidator createStateValidator() {
        return new ResourceStateValidatorImpl((ResourceStateInputProvider)this);
    }

    public void checkActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().checkActivation(presenter);
    }

    public void lostActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().lostActivation(presenter);
    }

    public IStatus validateState(ResourceStateValidatorPresenter presenter) throws CoreException {
        if (presenter == null) {
            return Status.OK_STATUS;
        }
        return this.getStateValidator().validateState(presenter);
    }

    public boolean checkSave(ResourceStateValidatorPresenter presenter) throws CoreException {
        return this.getStateValidator().checkSave(presenter);
    }

    public boolean checkReadOnly() {
        return this.getStateValidator().checkReadOnly();
    }

    public boolean isDirty() {
        return this.resource.isModified();
    }

    public List getNonResourceFiles() {
        return Collections.emptyList();
    }

    public List getNonResourceInconsistentFiles() {
        return Collections.emptyList();
    }

    public List getResources() {
        return Collections.singletonList(this.getXmlResource());
    }

    public void cacheNonResourceValidateState(List roNonResourceFiles) {
    }

    public static class NotifyRunner
    implements ISafeRunnable {
        private final JpaXmlResourceProviderEvent event;
        private JpaXmlResourceProviderListener listener;

        public NotifyRunner(JpaXmlResourceProviderEvent event) {
            Assert.isNotNull((Object)event);
            this.event = event;
        }

        public void setListener(JpaXmlResourceProviderListener listener) {
            this.listener = listener;
        }

        public void run() throws Exception {
            if (this.listener != null) {
                this.listener.modelChanged(this.event);
            }
        }

        public void handleException(Throwable exception) {
            JptCorePlugin.log(exception);
        }
    }

    protected class ResourceAdapter
    extends AdapterImpl {
        protected ResourceAdapter() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 1 && notification.getFeatureID(null) == 4) {
                AbstractXmlResourceProvider.this.resourceIsLoadedChanged((Resource)notification.getNotifier(), notification.getOldBooleanValue(), notification.getNewBooleanValue());
            }
        }
    }
}

