/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ui.project.facet;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public final class RuntimeMismatchMarkerResolutions
implements IMarkerResolutionGenerator {
    private static final String ATTR_RUNTIME1 = "runtime1";
    private static final String ATTR_RUNTIME2 = "runtime2";
    private static final String ATTR_MODULE_PROJECT = "moduleProject";

    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>(2);
        try {
            IProject earProject = marker.getResource().getProject();
            IFacetedProject earFacetedProject = ProjectFacetsManager.create((IProject)earProject);
            IProject modProject = RuntimeMismatchMarkerResolutions.getModuleProject(marker);
            IFacetedProject modFacetedProject = ProjectFacetsManager.create((IProject)modProject);
            for (IRuntime runtime : RuntimeMismatchMarkerResolutions.getRuntimes(marker)) {
                if (!earFacetedProject.isTargetable(runtime) || !modFacetedProject.isTargetable(runtime)) continue;
                Resolution resolution = new Resolution(earFacetedProject, modFacetedProject, runtime);
                resolutions.add(resolution);
            }
        }
        catch (CoreException e) {
            J2EEUIPlugin.logError(-1, null, e);
        }
        IMarkerResolution[] array = new IMarkerResolution[resolutions.size()];
        resolutions.toArray(array);
        return array;
    }

    private static IProject getModuleProject(IMarker marker) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        String moduleProjectName = marker.getAttribute(ATTR_MODULE_PROJECT, null);
        return ws.getRoot().getProject(moduleProjectName);
    }

    private static List getRuntimes(IMarker marker) {
        ArrayList<IRuntime> runtimes = new ArrayList<IRuntime>();
        IRuntime r = RuntimeMismatchMarkerResolutions.getRuntimeByName(marker.getAttribute(ATTR_RUNTIME1, null));
        if (r != null) {
            runtimes.add(r);
        }
        if ((r = RuntimeMismatchMarkerResolutions.getRuntimeByName(marker.getAttribute(ATTR_RUNTIME2, null))) != null) {
            runtimes.add(r);
        }
        return runtimes;
    }

    private static IRuntime getRuntimeByName(String name) {
        if (RuntimeManager.isRuntimeDefined((String)name)) {
            return RuntimeManager.getRuntime((String)name);
        }
        return null;
    }

    private static final class Resolution
    implements IMarkerResolution {
        private final IFacetedProject earProject;
        private final IFacetedProject moduleProject;
        private final IRuntime runtime;

        public Resolution(IFacetedProject earProject, IFacetedProject moduleProject, IRuntime runtime) {
            this.earProject = earProject;
            this.moduleProject = moduleProject;
            this.runtime = runtime;
        }

        public String getLabel() {
            return NLS.bind((String)Resources.useSameRuntime, (Object)this.runtime.getLocalizedName());
        }

        public void run(IMarker marker) {
            try {
                this.setRuntime(this.earProject, this.runtime);
                this.setRuntime(this.moduleProject, this.runtime);
            }
            catch (CoreException e) {
                ErrorDialog.openError(null, (String)Resources.errorDialogTitle, (String)Resources.errorDialogMessage, (IStatus)e.getStatus());
            }
        }

        private void setRuntime(IFacetedProject fproj, IRuntime runtime) throws CoreException {
            IRuntime currentPrimaryRuntime = fproj.getPrimaryRuntime();
            if (currentPrimaryRuntime != null && !currentPrimaryRuntime.getName().equals(runtime.getName())) {
                if (!fproj.isTargeted(runtime)) {
                    fproj.addTargetedRuntime(runtime, null);
                }
                fproj.setPrimaryRuntime(runtime, null);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String useSameRuntime;
        public static String errorDialogTitle;
        public static String errorDialogMessage;

        static {
            Resources.initializeMessages((String)RuntimeMismatchMarkerResolutions.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

