/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jst.j2ee.application.internal.operations.AddReferenceToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.RemoveReferenceFromEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEModuleHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.ui.J2EEModuleDependenciesPropertyPage;
import org.eclipse.jst.j2ee.internal.ui.JavaEEComponentDependencyContentProvider;
import org.eclipse.jst.j2ee.internal.ui.preferences.Messages;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.jee.project.facet.EarCreateDeploymentFilesDataModelProvider;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.internal.IModuleHandler;
import org.eclipse.wst.common.componentcore.internal.impl.TaskModel;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.ComponentDependencyContentProvider;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.DependencyPageExtensionManager;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.TaskWizard;
import org.eclipse.wst.common.componentcore.ui.propertypage.AddModuleDependenciesPropertiesPage;
import org.eclipse.wst.common.componentcore.ui.propertypage.IReferenceWizardConstants;
import org.eclipse.wst.common.componentcore.ui.propertypage.ModuleAssemblyRootPage;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarModuleDependenciesPropertyPage
extends AddModuleDependenciesPropertiesPage {
    private String libDir = null;
    private Text libDirText;
    private ControlDecoration libDirTextErrorDecoration = null;
    private static String earDefaultLirDir = new Path("/lib").makeRelative().toString();
    boolean previousLibDirIsValid = true;

    public EarModuleDependenciesPropertyPage(IProject project, ModuleAssemblyRootPage page) {
        super(project, page);
    }

    protected void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gData = new GridData(1808);
        composite.setLayoutData((Object)gData);
        this.fillTableComposite(composite);
        if (JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)this.rootComponent, (int)1) && JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)this.rootComponent, (int)0)) {
            this.addLibDirComposite(composite);
        }
    }

    private String loadLibDirString() {
        return EarUtilities.getEARLibDir((IVirtualComponent)this.rootComponent);
    }

    protected void addLibDirComposite(Composite parent) {
        this.libDir = this.loadLibDirString();
        if (this.libDir != null) {
            Composite c = new Composite(parent, 0);
            GridData mainData = new GridData(768);
            c.setLayoutData((Object)mainData);
            GridLayout gl = new GridLayout(2, false);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            c.setLayout((Layout)gl);
            Label l = new Label(c, 0);
            l.setText(Messages.EarModuleDependenciesPropertyPage_LIBDIR);
            this.libDirText = new Text(c, 2048);
            GridData gd = new GridData(768);
            gd.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
            this.libDirText.setText(this.libDir);
            this.libDirText.setLayoutData((Object)gd);
            this.libDirTextErrorDecoration = new ControlDecoration((Control)this.libDirText, 16512);
            this.libDirTextErrorDecoration.hide();
            this.libDirText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EarModuleDependenciesPropertyPage.this.libDirTextModified();
                }
            });
        }
    }

    protected void libDirTextModified() {
        boolean refresh = this.mustRefreshLibDirValidationMessages(this.libDir, this.libDirText.getText());
        this.libDir = this.libDirText.getText();
        if (refresh) {
            this.propPage.refreshProblemsView();
        }
    }

    protected boolean mustRefreshLibDirValidationMessages(String oldLibDir, String newLibDir) {
        boolean oldIsEmpty;
        boolean newIsEmpty;
        boolean newIsValid = this.isValidLibDir(newLibDir);
        boolean bl = newIsEmpty = newLibDir != null && newLibDir.trim().length() == 0;
        if (this.previousLibDirIsValid && newIsValid && !newIsEmpty) {
            return false;
        }
        boolean oldIsValid = this.isValidLibDir(oldLibDir);
        boolean bl2 = oldIsEmpty = oldLibDir != null && oldLibDir.trim().length() == 0;
        return this.previousLibDirIsValid || oldIsValid != newIsValid || oldIsEmpty != newIsEmpty;
    }

    protected void validatelibDirText() {
        if (this.libDirTextErrorDecoration != null) {
            if (!this.isValidLibDir(this.libDir)) {
                this.libDirTextErrorDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
                this.libDirTextErrorDecoration.setDescriptionText(Messages.EarModuleDependenciesPropertyPage_ERROR_INVALID_LIBDIR);
                this.libDirTextErrorDecoration.show();
                this.previousLibDirIsValid = false;
            } else if (this.libDir != null && this.libDir.trim().length() == 0) {
                this.libDirTextErrorDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage());
                this.libDirTextErrorDecoration.setDescriptionText(Messages.EarModuleDependenciesPropertyPage_WARNING_EMPTY_LIB_DIR);
                this.libDirTextErrorDecoration.show();
                this.previousLibDirIsValid = false;
            } else if (!this.previousLibDirIsValid) {
                this.previousLibDirIsValid = true;
                this.libDirTextErrorDecoration.setImage(null);
                this.libDirTextErrorDecoration.setDescriptionText(null);
                this.libDirTextErrorDecoration.hide();
            }
        }
    }

    private boolean isValidLibDir(String libraryDirectory) {
        return libraryDirectory == null || libraryDirectory.trim().length() <= 0 || !new Path(libraryDirectory.trim()).isAbsolute();
    }

    protected IDataModelOperation generateEARDDOperation() {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EarCreateDeploymentFilesDataModelProvider());
        model.setProperty("ICreateDeploymentFilesDataModelProperties.GENERATE_DD", (Object)this.rootComponent);
        model.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)this.project);
        return model.getDefaultOperation();
    }

    public boolean postHandleChanges(IProgressMonitor monitor) {
        return true;
    }

    protected void handleRemoved(ArrayList<IVirtualReference> removed) {
        super.handleRemoved(removed);
        boolean binariesRemoved = false;
        for (IVirtualReference ref : removed) {
            IVirtualComponent comp = ref.getReferencedComponent();
            if (!comp.isBinary()) continue;
            binariesRemoved = true;
            break;
        }
        if (binariesRemoved) {
            JavaEEBinaryComponentHelper.clearDisconnectedArchivesInEAR((IVirtualComponent)this.rootComponent);
        }
        J2EEComponentClasspathUpdater.getInstance().queueUpdateEAR(this.rootComponent.getProject());
    }

    protected IDataModelProvider getAddReferenceDataModelProvider(IVirtualReference component) {
        return new AddReferenceToEnterpriseApplicationDataModelProvider();
    }

    protected String getModuleAssemblyRootPageDescription() {
        return Messages.EarModuleDependenciesPropertyPage_3;
    }

    protected IDataModelProvider getRemoveReferenceDataModelProvider(IVirtualReference component) {
        return new RemoveReferenceFromEnterpriseApplicationDataModelProvider();
    }

    protected void filterReferenceTypes(List<DependencyPageExtensionManager.ReferenceExtension> extensions) {
        int i = 0;
        int n = extensions.size();
        while (i < n) {
            DependencyPageExtensionManager.ReferenceExtension ext = extensions.get(i);
            if (ext.getId().equals("org.eclipse.wst.common.componentcore.ui.newProjectReference")) {
                extensions.set(i, DependencyPageExtensionManager.getManager().findReferenceExtension("org.eclipse.jst.j2ee.internal.ui.preferences.CustomEARProjectReferenceWizardFragment"));
            }
            ++i;
        }
    }

    protected void createDD(IProgressMonitor monitor) {
        if (this.rootComponent != null) {
            IDataModelOperation op = this.generateEARDDOperation();
            try {
                op.execute(monitor, null);
            }
            catch (ExecutionException e) {
                J2EEUIPlugin.logError(e);
            }
        }
    }

    public void handleEvent(Event event) {
        super.handleEvent(event);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)this.rootComponent, (int)1) && JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)this.rootComponent, (int)0) && this.libDir != null) {
            this.updateLibDir();
        }
        return result;
    }

    private void updateLibDir() {
        IVirtualFile vFile;
        if (!this.libDir.equals(earDefaultLirDir) && !(vFile = this.rootComponent.getRootFolder().getFile((IPath)new Path("META-INF/application.xml"))).exists()) {
            if (!MessageDialog.openQuestion(null, (String)J2EEUIMessages.getResourceString("NO_DD_MSG_TITLE"), (String)J2EEUIMessages.getResourceString("GEN_DD_QUESTION"))) {
                return;
            }
            this.createDD((IProgressMonitor)new NullProgressMonitor());
        }
        final IEARModelProvider earModel = (IEARModelProvider)ModelProviderManager.getModelProvider((IProject)this.project);
        Application app = (Application)earModel.getModelObject();
        String oldLibDir = app.getLibraryDirectory();
        if (this.libDir.equals(earDefaultLirDir)) {
            if (oldLibDir != null) {
                earModel.modify(new Runnable(){

                    public void run() {
                        Application app2 = (Application)earModel.getModelObject();
                        app2.setLibraryDirectory(null);
                    }
                }, null);
            }
        } else if (oldLibDir != null && !oldLibDir.equals(this.libDir) || oldLibDir == null) {
            earModel.modify(new Runnable(){

                public void run() {
                    Application app2 = (Application)earModel.getModelObject();
                    app2.setLibraryDirectory(EarModuleDependenciesPropertyPage.this.libDir);
                }
            }, null);
        }
    }

    protected void setCustomReferenceWizardProperties(TaskModel model) {
        model.putObject("default.library.location", (Object)this.libDir);
        model.putObject("project.converter.operation.provider", (Object)this.getConverterProvider());
    }

    public IReferenceWizardConstants.ProjectConverterOperationProvider getConverterProvider() {
        return new IReferenceWizardConstants.ProjectConverterOperationProvider(){

            public IDataModelOperation getConversionOperation(IProject project) {
                return J2EEProjectUtilities.createFlexJavaProjectForProjectOperation((IProject)project);
            }
        };
    }

    protected IModuleHandler getModuleHandler() {
        if (this.moduleHandler == null) {
            this.moduleHandler = new JavaEEModuleHandler();
        }
        return this.moduleHandler;
    }

    protected ComponentDependencyContentProvider createProvider() {
        JavaEEComponentDependencyContentProvider provider = new JavaEEComponentDependencyContentProvider(this);
        provider.setClasspathEntries(new ArrayList<J2EEModuleDependenciesPropertyPage.ClasspathEntryProxy>());
        return provider;
    }

    protected boolean canRemove(Object selectedObject) {
        return super.canRemove(selectedObject) && !(selectedObject instanceof JavaEEComponentDependencyContentProvider.ConsumedClasspathEntryProxy);
    }

    public IStatus validate() {
        IStatus status = super.validate();
        this.validatelibDirText();
        if (this.libDirTextErrorDecoration != null && this.libDirTextErrorDecoration.getImage() != null) {
            int severity = 4;
            if (this.libDirTextErrorDecoration.getImage().equals((Object)FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage())) {
                severity = 2;
            }
            status = this.appendStatusMessage(status, this.libDirTextErrorDecoration.getDescriptionText(), severity);
        }
        return status;
    }

    public void performDefaults() {
        this.libDir = this.loadLibDirString();
        if (this.libDir != null) {
            this.libDirText.setText(this.libDir);
        }
        super.performDefaults();
    }

    private IStatus appendStatusMessage(IStatus existingStatus, String message, int severity) {
        MultiStatus multiStatus;
        Status newStatus = new Status(severity, "org.eclipse.jst.j2ee.ui", message);
        int newSeverity = severity;
        if (existingStatus.getSeverity() > severity) {
            newSeverity = existingStatus.getSeverity();
        }
        if (existingStatus instanceof MultiStatus) {
            multiStatus = (MultiStatus)existingStatus;
            multiStatus.merge((IStatus)newStatus);
        } else {
            if (!existingStatus.isMultiStatus() && existingStatus.isOK()) {
                return newStatus;
            }
            IStatus[] children = new IStatus[]{existingStatus, newStatus};
            multiStatus = new MultiStatus("org.eclipse.jst.j2ee.ui", newSeverity, children, null, null);
        }
        return multiStatus;
    }

    protected void handleAddDirective(TaskWizard wizard) {
        Object folderMapping = wizard.getTaskModel().getObject("folder.mapping");
        if (folderMapping != null && folderMapping instanceof AddModuleDependenciesPropertiesPage.ComponentResourceProxy || this.libDir == null) {
            super.handleAddDirective(wizard);
        } else {
            Object reference = wizard.getTaskModel().getObject("dependency.reference.final");
            if (reference != null) {
                IVirtualReference[] iVirtualReferenceArray;
                if (reference instanceof IVirtualReference) {
                    IVirtualReference[] iVirtualReferenceArray2 = new IVirtualReference[1];
                    iVirtualReferenceArray = iVirtualReferenceArray2;
                    iVirtualReferenceArray2[0] = (IVirtualReference)reference;
                } else {
                    iVirtualReferenceArray = (IVirtualReference[])reference;
                }
                IVirtualReference[] referenceArray = iVirtualReferenceArray;
                int i = 0;
                while (i < referenceArray.length) {
                    IVirtualComponent component = referenceArray[i].getReferencedComponent();
                    if (component instanceof VirtualArchiveComponent) {
                        JavaEEQuickPeek qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek((IVirtualComponent)component);
                        switch (qp.getType()) {
                            case 0: 
                            case 2: 
                            case 3: 
                            case 4: {
                                referenceArray[i].setRuntimePath((IPath)new Path("/"));
                            }
                        }
                    }
                    this.currentReferences.add(referenceArray[i]);
                    ++i;
                }
            }
        }
    }
}

