/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistenceUnitMetadata;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.jpa.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityMappings
extends AbstractOrmXmlContextNode
implements EntityMappings {
    protected final XmlEntityMappings xmlEntityMappings;
    protected String description;
    protected String package_;
    protected AccessType specifiedAccess;
    protected AccessType defaultAccess;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected final OrmPersistenceUnitMetadata persistenceUnitMetadata;
    protected final Vector<OrmPersistentType> persistentTypes = new Vector();
    protected final PersistentTypeContainerAdapter persistentTypeContainerAdapter = new PersistentTypeContainerAdapter();
    protected final Vector<OrmSequenceGenerator> sequenceGenerators = new Vector();
    protected final SequenceGeneratorContainerAdapter sequenceGeneratorContainerAdapter = new SequenceGeneratorContainerAdapter();
    protected final Vector<OrmTableGenerator> tableGenerators = new Vector();
    protected final TableGeneratorContainerAdapter tableGeneratorContainerAdapter = new TableGeneratorContainerAdapter();
    protected final OrmQueryContainer queryContainer;
    protected static final PersistentTypeLookupAdapter PERSISTENT_TYPE_LOOKUP_ADAPTER = new PersistentTypeLookupAdapter(){

        public Object resolvePersistentType(EntityMappings entityMappings, String className) {
            return entityMappings.getPersistenceUnit().getPersistentType(className);
        }
    };
    protected static final PersistentTypeLookupAdapter RESOURCE_PERSISTENT_TYPE_LOOKUP_ADAPTER = new PersistentTypeLookupAdapter(){

        public Object resolvePersistentType(EntityMappings entityMappings, String className) {
            return entityMappings.getJpaProject().getJavaResourcePersistentType(className);
        }
    };
    protected static final Comparator<OrmPersistentType> MAPPING_COMPARATOR = new Comparator<OrmPersistentType>(){

        @Override
        public int compare(OrmPersistentType o1, OrmPersistentType o2) {
            int o2Sequence;
            int o1Sequence = o1.getMapping().getXmlSequence();
            if (o1Sequence < (o2Sequence = o2.getMapping().getXmlSequence())) {
                return -1;
            }
            if (o1Sequence == o2Sequence) {
                return 0;
            }
            return 1;
        }
    };

    protected AbstractEntityMappings(OrmXml parent, XmlEntityMappings xmlEntityMappings) {
        super(parent);
        this.xmlEntityMappings = xmlEntityMappings;
        this.description = this.xmlEntityMappings.getDescription();
        this.package_ = this.xmlEntityMappings.getPackage();
        this.specifiedAccess = this.buildSpecifiedAccess();
        this.specifiedCatalog = this.xmlEntityMappings.getCatalog();
        this.specifiedSchema = this.xmlEntityMappings.getSchema();
        this.persistenceUnitMetadata = this.buildPersistenceUnitMetadata();
        this.initializePersistentTypes();
        this.initializeSequenceGenerators();
        this.initializeTableGenerators();
        this.queryContainer = this.buildQueryContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setDescription_(this.xmlEntityMappings.getDescription());
        this.setPackage_(this.xmlEntityMappings.getPackage());
        this.setSpecifiedAccess_(this.buildSpecifiedAccess());
        this.setSpecifiedCatalog_(this.xmlEntityMappings.getCatalog());
        this.setSpecifiedSchema_(this.xmlEntityMappings.getSchema());
        this.persistenceUnitMetadata.synchronizeWithResourceModel();
        this.syncPersistentTypes();
        this.syncSequenceGenerators();
        this.syncTableGenerators();
        this.queryContainer.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultAccess(this.buildDefaultAccess());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.persistenceUnitMetadata.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getPersistentTypes());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSequenceGenerators());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getTableGenerators());
        this.queryContainer.update();
    }

    @Override
    public OrmXml getParent() {
        return (OrmXml)super.getParent();
    }

    public OrmXml getOrmXml() {
        return this.getParent();
    }

    @Override
    public EntityMappings getMappingFileRoot() {
        return this;
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.jpa.core.orm.entityMappings";
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (OrmPersistentType persistentType : this.getPersistentTypes()) {
            if (!persistentType.contains(textOffset)) continue;
            return persistentType.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlEntityMappings.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        for (OrmPersistentType ormPersistentType : this.getPersistentTypes()) {
            ormPersistentType.dispose();
        }
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return this.isXmlMappingMetadataComplete() ? this.specifiedAccess : null;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getAccess();
    }

    @Override
    public String getDefaultPersistentTypePackage() {
        return this.getPackage();
    }

    protected boolean isXmlMappingMetadataComplete() {
        return this.getPersistenceUnit().isXmlMappingMetadataComplete();
    }

    @Override
    public OrmPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.persistenceUnitMetadata;
    }

    protected OrmPersistenceUnitMetadata buildPersistenceUnitMetadata() {
        return this.getContextNodeFactory().buildOrmPersistenceUnitMetadata(this);
    }

    @Override
    public XmlEntityMappings getXmlEntityMappings() {
        return this.xmlEntityMappings;
    }

    @Override
    public String getVersion() {
        return this.xmlEntityMappings.getVersion();
    }

    @Override
    public void changeMapping(OrmPersistentType ormPersistentType, OrmTypeMapping oldMapping, OrmTypeMapping newMapping) {
        AccessType savedAccess = ormPersistentType.getSpecifiedAccess();
        int sourceIndex = this.persistentTypes.indexOf(ormPersistentType);
        this.persistentTypes.remove(sourceIndex);
        oldMapping.removeXmlTypeMappingFrom(this.xmlEntityMappings);
        int targetIndex = this.calculateInsertionIndex(ormPersistentType);
        this.persistentTypes.add(targetIndex, ormPersistentType);
        newMapping.addXmlTypeMappingTo(this.xmlEntityMappings);
        newMapping.initializeFrom(oldMapping);
        ormPersistentType.setSpecifiedAccess(savedAccess);
        this.fireItemMoved("persistentTypes", targetIndex, sourceIndex);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlEntityMappings.getValidationTextRange();
        return textRange != null ? textRange : this.getOrmXml().getValidationTextRange();
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlEntityMappings != null && this.xmlEntityMappings.containsOffset(textOffset);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.setDescription_(description);
        this.xmlEntityMappings.setDescription(description);
    }

    protected void setDescription_(String description) {
        String old = this.description;
        this.description = description;
        this.firePropertyChanged("description", old, description);
    }

    @Override
    public String getPackage() {
        return this.package_;
    }

    @Override
    public void setPackage(String package_) {
        this.setPackage_(package_);
        this.xmlEntityMappings.setPackage(package_);
    }

    protected void setPackage_(String package_) {
        String old = this.package_;
        this.package_ = package_;
        this.firePropertyChanged("package", old, package_);
    }

    @Override
    public AccessType getAccess() {
        return this.specifiedAccess != null ? this.specifiedAccess : this.defaultAccess;
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType access) {
        this.setSpecifiedAccess_(access);
        this.xmlEntityMappings.setAccess(AccessType.toOrmResourceModel(access));
    }

    protected void setSpecifiedAccess_(AccessType access) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = access;
        this.firePropertyChanged("specifiedAccess", (Object)old, (Object)access);
    }

    protected AccessType buildSpecifiedAccess() {
        return AccessType.fromOrmResourceModel(this.xmlEntityMappings.getAccess());
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", (Object)old, (Object)access);
    }

    protected AccessType buildDefaultAccess() {
        return this.getPersistenceUnit().getDefaultAccess();
    }

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        this.setSpecifiedCatalog_(catalog);
        this.xmlEntityMappings.setCatalog(catalog);
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected String buildDefaultCatalog() {
        return this.getPersistenceUnit().getDefaultCatalog();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        this.setSpecifiedSchema_(schema);
        this.xmlEntityMappings.setSchema(schema);
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected String buildDefaultSchema() {
        return this.getPersistenceUnit().getDefaultSchema();
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public ListIterable<OrmPersistentType> getPersistentTypes() {
        return new LiveCloneListIterable(this.persistentTypes);
    }

    @Override
    public int getPersistentTypesSize() {
        return this.persistentTypes.size();
    }

    @Override
    public OrmPersistentType getPersistentType(String className) {
        for (OrmPersistentType ormPersistentType : this.getPersistentTypes()) {
            if (!ormPersistentType.isFor(className)) continue;
            return ormPersistentType;
        }
        return null;
    }

    @Override
    public boolean containsPersistentType(String className) {
        return this.getPersistentType(className) != null;
    }

    @Override
    public PersistentType resolvePersistentType(String className) {
        return (PersistentType)this.resolvePersistentType(PERSISTENT_TYPE_LOOKUP_ADAPTER, className);
    }

    @Override
    public JavaResourcePersistentType resolveJavaResourcePersistentType(String className) {
        return (JavaResourcePersistentType)this.resolvePersistentType(RESOURCE_PERSISTENT_TYPE_LOOKUP_ADAPTER, className);
    }

    protected Object resolvePersistentType(PersistentTypeLookupAdapter adapter, String className) {
        if (className == null) {
            return null;
        }
        Object persistentType = adapter.resolvePersistentType(this, className = className.replace('$', '.'));
        if (persistentType != null) {
            return persistentType;
        }
        if (this.getPackage() == null) {
            return null;
        }
        return adapter.resolvePersistentType(this, String.valueOf(this.getPackage()) + '.' + className);
    }

    @Override
    public OrmPersistentType addPersistentType(String mappingKey, String className) {
        OrmTypeMappingDefinition md = this.getMappingFileDefinition().getTypeMappingDefinition(mappingKey);
        XmlTypeMapping xmlTypeMapping = md.buildResourceMapping(this.getResourceNodeFactory());
        OrmPersistentType persistentType = this.buildPersistentType(xmlTypeMapping);
        int index = this.calculateInsertionIndex(persistentType);
        this.addItemToList(index, persistentType, this.persistentTypes, "persistentTypes");
        persistentType.getMapping().addXmlTypeMappingTo(this.xmlEntityMappings);
        className = this.normalizeClassName(className);
        persistentType.getMapping().setClass(className);
        return persistentType;
    }

    protected String normalizeClassName(String className) {
        return this.package_ != null && className.startsWith(this.package_) && className.charAt(this.package_.length()) == '.' ? className.substring(this.package_.length() + 1) : className;
    }

    protected OrmPersistentType buildPersistentType(XmlTypeMapping xmlTypeMapping) {
        return this.getContextNodeFactory().buildOrmPersistentType(this, xmlTypeMapping);
    }

    protected int calculateInsertionIndex(OrmPersistentType ormPersistentType) {
        return CollectionTools.insertionIndexOf(this.persistentTypes, (Object)ormPersistentType, MAPPING_COMPARATOR);
    }

    @Override
    public void removePersistentType(int index) {
        OrmPersistentType persistentType = this.removePersistentType_(index);
        persistentType.getMapping().removeXmlTypeMappingFrom(this.xmlEntityMappings);
    }

    protected OrmPersistentType removePersistentType_(int index) {
        OrmPersistentType persistentType = (OrmPersistentType)this.removeItemFromList(index, this.persistentTypes, "persistentTypes");
        persistentType.dispose();
        return persistentType;
    }

    @Override
    public void removePersistentType(OrmPersistentType persistentType) {
        this.removePersistentType(this.persistentTypes.indexOf(persistentType));
    }

    protected void initializePersistentTypes() {
        for (XmlTypeMapping xmlTypeMapping : this.getXmlTypeMappings()) {
            this.persistentTypes.add(this.buildPersistentType(xmlTypeMapping));
        }
    }

    protected void syncPersistentTypes() {
        ContextContainerTools.synchronizeWithResourceModel(this.persistentTypeContainerAdapter);
    }

    protected Iterable<XmlTypeMapping> getXmlTypeMappings() {
        return new LiveCloneIterable(this.xmlEntityMappings.getTypeMappings());
    }

    protected void movePersistentType_(int index, OrmPersistentType persistentType) {
        this.moveItemInList(index, persistentType, this.persistentTypes, "persistentTypes");
    }

    protected void addPersistentType_(int index, XmlTypeMapping xmlTypeMapping) {
        this.addItemToList(index, this.buildPersistentType(xmlTypeMapping), this.persistentTypes, "persistentTypes");
    }

    protected void removePersistentType_(OrmPersistentType persistentType) {
        this.removePersistentType_(this.persistentTypes.indexOf(persistentType));
    }

    @Override
    public ListIterable<OrmSequenceGenerator> getSequenceGenerators() {
        return new LiveCloneListIterable(this.sequenceGenerators);
    }

    @Override
    public int getSequenceGeneratorsSize() {
        return this.sequenceGenerators.size();
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator() {
        return this.addSequenceGenerator(this.sequenceGenerators.size());
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator(int index) {
        XmlSequenceGenerator xmlGenerator = this.buildXmlSequenceGenerator();
        OrmSequenceGenerator sequenceGenerator = this.addSequenceGenerator_(index, xmlGenerator);
        this.xmlEntityMappings.getSequenceGenerators().add(index, (Object)xmlGenerator);
        return sequenceGenerator;
    }

    protected XmlSequenceGenerator buildXmlSequenceGenerator() {
        return OrmFactory.eINSTANCE.createXmlSequenceGenerator();
    }

    protected OrmSequenceGenerator buildSequenceGenerator(XmlSequenceGenerator xmlSequenceGenerator) {
        return this.getContextNodeFactory().buildOrmSequenceGenerator(this, xmlSequenceGenerator);
    }

    @Override
    public void removeSequenceGenerator(OrmSequenceGenerator sequenceGenerator) {
        this.removeSequenceGenerator(this.sequenceGenerators.indexOf(sequenceGenerator));
    }

    @Override
    public void removeSequenceGenerator(int index) {
        this.removeSequenceGenerator_(index);
        this.xmlEntityMappings.getSequenceGenerators().remove(index);
    }

    protected void removeSequenceGenerator_(int index) {
        this.removeItemFromList(index, this.sequenceGenerators, "sequenceGenerators");
    }

    @Override
    public void moveSequenceGenerator(int targetIndex, int sourceIndex) {
        this.moveItemInList(targetIndex, sourceIndex, this.sequenceGenerators, "sequenceGenerators");
        this.xmlEntityMappings.getSequenceGenerators().move(targetIndex, sourceIndex);
    }

    protected void initializeSequenceGenerators() {
        for (XmlSequenceGenerator sequenceGenerator : this.getXmlSequenceGenerators()) {
            this.sequenceGenerators.add(this.buildSequenceGenerator(sequenceGenerator));
        }
    }

    protected void syncSequenceGenerators() {
        ContextContainerTools.synchronizeWithResourceModel(this.sequenceGeneratorContainerAdapter);
    }

    protected Iterable<XmlSequenceGenerator> getXmlSequenceGenerators() {
        return new LiveCloneIterable(this.xmlEntityMappings.getSequenceGenerators());
    }

    protected void moveSequenceGenerator_(int index, OrmSequenceGenerator sequenceGenerator) {
        this.moveItemInList(index, sequenceGenerator, this.sequenceGenerators, "sequenceGenerators");
    }

    protected OrmSequenceGenerator addSequenceGenerator_(int index, XmlSequenceGenerator xmlSequenceGenerator) {
        OrmSequenceGenerator sequenceGenerator = this.buildSequenceGenerator(xmlSequenceGenerator);
        this.addItemToList(index, sequenceGenerator, this.sequenceGenerators, "sequenceGenerators");
        return sequenceGenerator;
    }

    protected void removeSequenceGenerator_(OrmSequenceGenerator sequenceGenerator) {
        this.removeSequenceGenerator_(this.sequenceGenerators.indexOf(sequenceGenerator));
    }

    @Override
    public ListIterable<OrmTableGenerator> getTableGenerators() {
        return new LiveCloneListIterable(this.tableGenerators);
    }

    @Override
    public int getTableGeneratorsSize() {
        return this.tableGenerators.size();
    }

    @Override
    public OrmTableGenerator addTableGenerator() {
        return this.addTableGenerator(this.tableGenerators.size());
    }

    @Override
    public OrmTableGenerator addTableGenerator(int index) {
        XmlTableGenerator xmlTableGenerator = this.buildXmlTableGenerator();
        OrmTableGenerator tableGenerator = this.addTableGenerator_(index, xmlTableGenerator);
        this.xmlEntityMappings.getTableGenerators().add(index, (Object)xmlTableGenerator);
        return tableGenerator;
    }

    protected XmlTableGenerator buildXmlTableGenerator() {
        return OrmFactory.eINSTANCE.createXmlTableGenerator();
    }

    protected OrmTableGenerator buildTableGenerator(XmlTableGenerator xmlTableGenerator) {
        return this.getContextNodeFactory().buildOrmTableGenerator(this, xmlTableGenerator);
    }

    @Override
    public void removeTableGenerator(OrmTableGenerator tableGenerator) {
        this.removeTableGenerator(this.tableGenerators.indexOf(tableGenerator));
    }

    @Override
    public void removeTableGenerator(int index) {
        this.removeTableGenerator_(index);
        this.xmlEntityMappings.getTableGenerators().remove(index);
    }

    protected void removeTableGenerator_(int index) {
        this.removeItemFromList(index, this.tableGenerators, "tableGenerators");
    }

    @Override
    public void moveTableGenerator(int targetIndex, int sourceIndex) {
        this.moveItemInList(targetIndex, sourceIndex, this.tableGenerators, "tableGenerators");
        this.xmlEntityMappings.getTableGenerators().move(targetIndex, sourceIndex);
    }

    protected void initializeTableGenerators() {
        for (XmlTableGenerator tableGenerator : this.getXmlTableGenerators()) {
            this.tableGenerators.add(this.buildTableGenerator(tableGenerator));
        }
    }

    protected void syncTableGenerators() {
        ContextContainerTools.synchronizeWithResourceModel(this.tableGeneratorContainerAdapter);
    }

    protected Iterable<XmlTableGenerator> getXmlTableGenerators() {
        return new LiveCloneIterable(this.xmlEntityMappings.getTableGenerators());
    }

    protected void moveTableGenerator_(int index, OrmTableGenerator tableGenerator) {
        this.moveItemInList(index, tableGenerator, this.tableGenerators, "tableGenerators");
    }

    protected OrmTableGenerator addTableGenerator_(int index, XmlTableGenerator xmlTableGenerator) {
        OrmTableGenerator tableGenerator = this.buildTableGenerator(xmlTableGenerator);
        this.addItemToList(index, tableGenerator, this.tableGenerators, "tableGenerators");
        return tableGenerator;
    }

    protected void removeTableGenerator_(OrmTableGenerator tableGenerator) {
        this.removeTableGenerator_(this.tableGenerators.indexOf(tableGenerator));
    }

    @Override
    public OrmQueryContainer getQueryContainer() {
        return this.queryContainer;
    }

    protected OrmQueryContainer buildQueryContainer() {
        return this.getContextNodeFactory().buildOrmQueryContainer(this, this.xmlEntityMappings);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateVersion(messages);
        this.queryContainer.validate(messages, reporter);
        for (OrmPersistentType ormPersistentType : this.getPersistentTypes()) {
            this.validatePersistentType(ormPersistentType, messages, reporter);
        }
    }

    protected void validateVersion(List<IMessage> messages) {
        if (!this.getLatestDocumentVersion().equals(this.xmlEntityMappings.getVersion())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(4, "XML_VERSION_NOT_LATEST", this, this.xmlEntityMappings.getVersionTextRange()));
        }
    }

    protected String getLatestDocumentVersion() {
        return this.getJpaPlatform().getMostRecentSupportedResourceType(this.getContentType()).getVersion();
    }

    protected IContentType getContentType() {
        return JptJpaCorePlugin.ORM_XML_CONTENT_TYPE;
    }

    protected void validatePersistentType(OrmPersistentType persistentType, List<IMessage> messages, IReporter reporter) {
        try {
            persistentType.validate(messages, reporter);
        }
        catch (Throwable exception) {
            JptJpaCorePlugin.log(exception);
        }
    }

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(final IType type) {
        return new CompositeIterable((Iterable)new TransformationIterable<OrmPersistentType, Iterable<DeleteEdit>>(this.getPersistentTypes()){

            protected Iterable<DeleteEdit> transform(OrmPersistentType persistentType) {
                return persistentType.createDeleteTypeEdits(type);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(final IType originalType, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<OrmPersistentType, Iterable<ReplaceEdit>>(this.getPersistentTypes()){

            protected Iterable<ReplaceEdit> transform(OrmPersistentType persistentType) {
                return persistentType.createRenameTypeEdits(originalType, newName);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(final IType originalType, final IPackageFragment newPackage) {
        return new CompositeIterable((Iterable)new TransformationIterable<OrmPersistentType, Iterable<ReplaceEdit>>(this.getPersistentTypes()){

            protected Iterable<ReplaceEdit> transform(OrmPersistentType persistentType) {
                return persistentType.createMoveTypeEdits(originalType, newPackage);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return new CompositeIterable(new Iterable[]{this.createPersistentTypeRenamePackageEdits(originalPackage, newName), this.createRenamePackageEdit(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createPersistentTypeRenamePackageEdits(final IPackageFragment originalPackage, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<OrmPersistentType, Iterable<ReplaceEdit>>(this.getPersistentTypes()){

            protected Iterable<ReplaceEdit> transform(OrmPersistentType persistentType) {
                return persistentType.createRenamePackageEdits(originalPackage, newName);
            }
        });
    }

    protected Iterable<ReplaceEdit> createRenamePackageEdit(IPackageFragment originalPackage, String newName) {
        return Tools.valuesAreEqual((Object)this.package_, (Object)originalPackage.getElementName()) ? new SingleElementIterable((Object)this.xmlEntityMappings.createRenamePackageEdit(newName)) : EmptyIterable.instance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PersistentTypeContainerAdapter
    implements ContextContainerTools.Adapter<OrmPersistentType, XmlTypeMapping> {
        protected PersistentTypeContainerAdapter() {
        }

        @Override
        public Iterable<OrmPersistentType> getContextElements() {
            return AbstractEntityMappings.this.getPersistentTypes();
        }

        @Override
        public Iterable<XmlTypeMapping> getResourceElements() {
            return AbstractEntityMappings.this.getXmlTypeMappings();
        }

        @Override
        public XmlTypeMapping getResourceElement(OrmPersistentType contextElement) {
            return contextElement.getMapping().getXmlTypeMapping();
        }

        @Override
        public void moveContextElement(int index, OrmPersistentType element) {
            AbstractEntityMappings.this.movePersistentType_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlTypeMapping resourceElement) {
            AbstractEntityMappings.this.addPersistentType_(index, resourceElement);
        }

        @Override
        public void removeContextElement(OrmPersistentType element) {
            AbstractEntityMappings.this.removePersistentType_(element);
        }
    }

    protected static interface PersistentTypeLookupAdapter {
        public Object resolvePersistentType(EntityMappings var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SequenceGeneratorContainerAdapter
    implements ContextContainerTools.Adapter<OrmSequenceGenerator, XmlSequenceGenerator> {
        protected SequenceGeneratorContainerAdapter() {
        }

        @Override
        public Iterable<OrmSequenceGenerator> getContextElements() {
            return AbstractEntityMappings.this.getSequenceGenerators();
        }

        @Override
        public Iterable<XmlSequenceGenerator> getResourceElements() {
            return AbstractEntityMappings.this.getXmlSequenceGenerators();
        }

        @Override
        public XmlSequenceGenerator getResourceElement(OrmSequenceGenerator contextElement) {
            return contextElement.getXmlGenerator();
        }

        @Override
        public void moveContextElement(int index, OrmSequenceGenerator element) {
            AbstractEntityMappings.this.moveSequenceGenerator_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlSequenceGenerator resourceElement) {
            AbstractEntityMappings.this.addSequenceGenerator_(index, resourceElement);
        }

        @Override
        public void removeContextElement(OrmSequenceGenerator element) {
            AbstractEntityMappings.this.removeSequenceGenerator_(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TableGeneratorContainerAdapter
    implements ContextContainerTools.Adapter<OrmTableGenerator, XmlTableGenerator> {
        protected TableGeneratorContainerAdapter() {
        }

        @Override
        public Iterable<OrmTableGenerator> getContextElements() {
            return AbstractEntityMappings.this.getTableGenerators();
        }

        @Override
        public Iterable<XmlTableGenerator> getResourceElements() {
            return AbstractEntityMappings.this.getXmlTableGenerators();
        }

        @Override
        public XmlTableGenerator getResourceElement(OrmTableGenerator contextElement) {
            return contextElement.getXmlGenerator();
        }

        @Override
        public void moveContextElement(int index, OrmTableGenerator element) {
            AbstractEntityMappings.this.moveTableGenerator_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlTableGenerator resourceElement) {
            AbstractEntityMappings.this.addTableGenerator_(index, resourceElement);
        }

        @Override
        public void removeContextElement(OrmTableGenerator element) {
            AbstractEntityMappings.this.removeTableGenerator_(element);
        }
    }
}

