/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.validation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jpt.common.core.IResourcePart;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.osgi.service.prefs.BackingStoreException;

public class JpaValidationPreferences {
    private static final String PROBLEM_PREFIX = "problem.";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String INFO = "info";
    public static final String IGNORE = "ignore";
    static final int NO_SEVERITY_PREFERENCE = -1;
    public static final String WORKSPACE_PREFERENCES_OVERRIDEN = "workspace_preferences_overriden";

    public static int getProblemSeverityPreference(Object targetObject, String messageId) {
        IProject project = JpaValidationPreferences.getProject(targetObject);
        String problemPreference = JpaValidationPreferences.getPreference(project, messageId);
        if (problemPreference == null) {
            return -1;
        }
        if (problemPreference.equals(ERROR)) {
            return 1;
        }
        if (problemPreference.equals(WARNING)) {
            return 2;
        }
        if (problemPreference.equals(INFO)) {
            return 4;
        }
        return -1;
    }

    private static IProject getProject(Object targetObject) {
        IAdaptable target = (IAdaptable)targetObject;
        IResource resource = ((IResourcePart)target.getAdapter(IResourcePart.class)).getResource();
        IProject project = resource.getProject();
        return project;
    }

    public static boolean isProblemIgnored(IProject project, String messageId) {
        String problemPreference = JpaValidationPreferences.getPreference(project, messageId);
        return problemPreference != null && problemPreference.equals(IGNORE);
    }

    private static String getPreference(IProject project, String messageId) {
        String problemPreference = null;
        problemPreference = JpaValidationPreferences.getProjectLevelProblemPreference(project, messageId);
        if (problemPreference == null) {
            problemPreference = JpaValidationPreferences.getWorkspaceLevelProblemPreference(messageId);
        }
        return problemPreference;
    }

    public static String getProjectLevelProblemPreference(IProject project, String messageId) {
        return JpaValidationPreferences.getPreference(JptJpaCorePlugin.getProjectPreferences(project), messageId);
    }

    public static void setProjectLevelProblemPreference(IProject project, String messageId, String problemPreference) {
        IEclipsePreferences projectPreferences = JptJpaCorePlugin.getProjectPreferences(project);
        JpaValidationPreferences.setPreference(projectPreferences, messageId, problemPreference);
        JpaValidationPreferences.flush(projectPreferences);
    }

    public static String getWorkspaceLevelProblemPreference(String messageId) {
        return JpaValidationPreferences.getPreference(JptJpaCorePlugin.getWorkspacePreferences(), messageId);
    }

    public static void setWorkspaceLevelProblemPreference(String messageId, String problemPreference) {
        IEclipsePreferences workspacePreferences = JptJpaCorePlugin.getWorkspacePreferences();
        JpaValidationPreferences.setPreference(workspacePreferences, messageId, problemPreference);
        JpaValidationPreferences.flush(workspacePreferences);
    }

    private static String getPreference(IEclipsePreferences preferences, String messageId) {
        return preferences.get(JpaValidationPreferences.appendProblemPrefix(messageId), null);
    }

    private static void setPreference(IEclipsePreferences preferences, String messageId, String problemPreference) {
        if (problemPreference == null) {
            preferences.remove(JpaValidationPreferences.appendProblemPrefix(messageId));
        } else {
            preferences.put(JpaValidationPreferences.appendProblemPrefix(messageId), problemPreference);
        }
    }

    private static String appendProblemPrefix(String messageId) {
        return PROBLEM_PREFIX + messageId;
    }

    public static void flush(IEclipsePreferences prefs) {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            JptJpaCorePlugin.log(ex);
        }
    }
}

