/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.NameTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaTable;
import org.eclipse.jpt.jpa.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.TableTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaTableTextRangeResolver;
import org.eclipse.jpt.jpa.core.resource.java.BaseTableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTable<A extends BaseTableAnnotation>
extends AbstractJavaJpaContextNode
implements JavaTable,
UniqueConstraint.Owner {
    protected final Table.Owner owner;
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected final Vector<JavaUniqueConstraint> uniqueConstraints = new Vector();
    protected final UniqueConstraintContainerAdapter uniqueConstraintContainerAdapter = new UniqueConstraintContainerAdapter();

    protected AbstractJavaTable(JavaJpaContextNode parent, Table.Owner owner) {
        this(parent, owner, null);
    }

    protected AbstractJavaTable(JavaJpaContextNode parent, Table.Owner owner, A tableAnnotation) {
        super(parent);
        this.owner = owner;
        this.setTableAnnotation(tableAnnotation);
        this.specifiedName = this.buildSpecifiedName();
        this.specifiedSchema = this.buildSpecifiedSchema();
        this.specifiedCatalog = this.buildSpecifiedCatalog();
        this.initializeUniqueConstraints();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(this.buildSpecifiedName());
        this.setSpecifiedSchema_(this.buildSpecifiedSchema());
        this.setSpecifiedCatalog_(this.buildSpecifiedCatalog());
        this.syncUniqueConstraints();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultName(this.buildDefaultName());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getUniqueConstraints());
    }

    public abstract A getTableAnnotation();

    protected void setTableAnnotation(A tableAnnotation) {
        if (tableAnnotation != null) {
            throw new IllegalArgumentException("this method must be overridden if the table annotation is not null: " + tableAnnotation);
        }
    }

    protected void removeTableAnnotationIfUnset() {
        if (this.getTableAnnotation().isUnset()) {
            this.removeTableAnnotation();
        }
    }

    protected abstract void removeTableAnnotation();

    @Override
    public boolean isSpecifiedInResource() {
        return this.getTableAnnotation().isSpecified();
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        if (this.valuesAreDifferent(this.specifiedName, name)) {
            this.getTableAnnotation().setName(name);
            this.removeTableAnnotationIfUnset();
            this.setSpecifiedName_(name);
        }
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        return this.getTableAnnotation().getName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected abstract String buildDefaultName();

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        if (this.valuesAreDifferent(this.specifiedSchema, schema)) {
            this.getTableAnnotation().setSchema(schema);
            this.removeTableAnnotationIfUnset();
            this.setSpecifiedSchema_(schema);
        }
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    protected String buildSpecifiedSchema() {
        return this.getTableAnnotation().getSchema();
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected abstract String buildDefaultSchema();

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        if (this.valuesAreDifferent(this.specifiedCatalog, catalog)) {
            this.getTableAnnotation().setCatalog(catalog);
            this.removeTableAnnotationIfUnset();
            this.setSpecifiedCatalog_(catalog);
        }
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    protected String buildSpecifiedCatalog() {
        return this.getTableAnnotation().getCatalog();
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected abstract String buildDefaultCatalog();

    @Override
    public ListIterator<JavaUniqueConstraint> uniqueConstraints() {
        return this.getUniqueConstraints().iterator();
    }

    protected ListIterable<JavaUniqueConstraint> getUniqueConstraints() {
        return new LiveCloneListIterable(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public JavaUniqueConstraint getUniqueConstraint(int index) {
        return this.uniqueConstraints.get(index);
    }

    @Override
    public JavaUniqueConstraint addUniqueConstraint() {
        return this.addUniqueConstraint(this.uniqueConstraints.size());
    }

    @Override
    public JavaUniqueConstraint addUniqueConstraint(int index) {
        UniqueConstraintAnnotation annotation = this.getTableAnnotation().addUniqueConstraint(index);
        return this.addUniqueConstraint_(index, annotation);
    }

    @Override
    public void removeUniqueConstraint(UniqueConstraint constraint) {
        this.removeUniqueConstraint(this.uniqueConstraints.indexOf(constraint));
    }

    @Override
    public void removeUniqueConstraint(int index) {
        this.getTableAnnotation().removeUniqueConstraint(index);
        this.removeTableAnnotationIfUnset();
        this.removeUniqueConstraint_(index);
    }

    protected void removeUniqueConstraint_(int index) {
        this.removeItemFromList(index, this.uniqueConstraints, "uniqueConstraints");
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        this.getTableAnnotation().moveUniqueConstraint(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.uniqueConstraints, "uniqueConstraints");
    }

    protected void initializeUniqueConstraints() {
        ListIterator<UniqueConstraintAnnotation> stream = this.getTableAnnotation().uniqueConstraints();
        while (stream.hasNext()) {
            this.uniqueConstraints.add(this.buildUniqueConstraint((UniqueConstraintAnnotation)stream.next()));
        }
    }

    protected JavaUniqueConstraint buildUniqueConstraint(UniqueConstraintAnnotation constraintAnnotation) {
        return this.getJpaFactory().buildJavaUniqueConstraint(this, this, constraintAnnotation);
    }

    protected void syncUniqueConstraints() {
        ContextContainerTools.synchronizeWithResourceModel(this.uniqueConstraintContainerAdapter);
    }

    protected Iterable<UniqueConstraintAnnotation> getUniqueConstraintAnnotations() {
        return CollectionTools.iterable(this.getTableAnnotation().uniqueConstraints());
    }

    protected void moveUniqueConstraint_(int index, JavaUniqueConstraint constraint) {
        this.moveItemInList(index, constraint, this.uniqueConstraints, "uniqueConstraints");
    }

    protected JavaUniqueConstraint addUniqueConstraint_(int index, UniqueConstraintAnnotation constraintAnnotation) {
        JavaUniqueConstraint constraint = this.buildUniqueConstraint(constraintAnnotation);
        this.addItemToList(index, constraint, this.uniqueConstraints, "uniqueConstraints");
        return constraint;
    }

    protected void removeUniqueConstraint_(JavaUniqueConstraint constraint) {
        this.removeUniqueConstraint_(this.uniqueConstraints.indexOf(constraint));
    }

    @Override
    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getName());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    @Override
    public boolean isResolved() {
        return this.getDbTable() != null;
    }

    @Override
    public boolean schemaIsResolved() {
        return this.getDbSchema() != null;
    }

    @Override
    public boolean catalogIsResolved() {
        String catalog = this.getCatalog();
        return catalog == null || this.resolveDbCatalog(catalog) != null;
    }

    @Override
    public Iterator<String> candidateUniqueConstraintColumnNames() {
        Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.getSortedColumnIdentifiers().iterator() : EmptyIterator.instance();
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaUniqueConstraint constraint : CollectionTools.iterable(this.uniqueConstraints())) {
            result = constraint.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected Iterator<String> connectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos, astRoot)) {
            return this.getJavaCandidateNames(filter).iterator();
        }
        if (this.schemaTouches(pos, astRoot)) {
            return this.getJavaCandidateSchemata(filter).iterator();
        }
        if (this.catalogTouches(pos, astRoot)) {
            return this.getJavaCandidateCatalogs(filter).iterator();
        }
        return null;
    }

    protected boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.getTableAnnotation().nameTouches(pos, astRoot);
    }

    protected Iterable<String> getJavaCandidateNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateNames(filter));
    }

    protected Iterable<String> getCandidateNames(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateNames(), filter);
    }

    protected Iterable<String> getCandidateNames() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.getSortedTableIdentifiers() : EmptyIterable.instance();
    }

    protected boolean schemaTouches(int pos, CompilationUnit astRoot) {
        return this.getTableAnnotation().schemaTouches(pos, astRoot);
    }

    protected Iterable<String> getJavaCandidateSchemata(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateSchemata(filter));
    }

    protected Iterable<String> getCandidateSchemata(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateSchemata(), filter);
    }

    protected Iterable<String> getCandidateSchemata() {
        return this.getDbSchemaContainer().getSortedSchemaIdentifiers();
    }

    protected boolean catalogTouches(int pos, CompilationUnit astRoot) {
        return this.getTableAnnotation().catalogTouches(pos, astRoot);
    }

    protected Iterable<String> getJavaCandidateCatalogs(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateCatalogs(filter));
    }

    protected Iterable<String> getCandidateCatalogs(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateCatalogs(), filter);
    }

    protected Iterable<String> getCandidateCatalogs() {
        Database db = this.getDatabase();
        return db != null ? db.getSortedCatalogIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.buildTableValidator(astRoot).validate(messages, reporter);
    }

    protected JptValidator buildTableValidator(CompilationUnit astRoot) {
        return this.owner.buildTableValidator(this, this.buildTextRangeResolver(astRoot));
    }

    protected TableTextRangeResolver buildTextRangeResolver(CompilationUnit astRoot) {
        return new JavaTableTextRangeResolver(this, astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getTableAnnotation().getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getTableAnnotation().getNameTextRange(astRoot), astRoot);
    }

    @Override
    public TextRange getSchemaTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getTableAnnotation().getSchemaTextRange(astRoot), astRoot);
    }

    @Override
    public TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getTableAnnotation().getCatalogTextRange(astRoot), astRoot);
    }

    @Override
    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    protected void initializeFrom(ReadOnlyTable oldTable) {
        this.setSpecifiedName(oldTable.getSpecifiedName());
        this.setSpecifiedCatalog(oldTable.getSpecifiedCatalog());
        this.setSpecifiedSchema(oldTable.getSpecifiedSchema());
        for (ReadOnlyUniqueConstraint constraint : CollectionTools.iterable(oldTable.uniqueConstraints())) {
            this.addUniqueConstraint().initializeFrom(constraint);
        }
    }

    protected void initializeFromVirtual(ReadOnlyTable virtualTable) {
        this.setSpecifiedName(virtualTable.getName());
    }

    public void toString(StringBuilder sb) {
        sb.append(this.buildQualifiedName());
    }

    protected String buildQualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName((String)this.getCatalog(), (String)this.getSchema(), (String)this.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UniqueConstraintContainerAdapter
    implements ContextContainerTools.Adapter<JavaUniqueConstraint, UniqueConstraintAnnotation> {
        protected UniqueConstraintContainerAdapter() {
        }

        @Override
        public Iterable<JavaUniqueConstraint> getContextElements() {
            return AbstractJavaTable.this.getUniqueConstraints();
        }

        @Override
        public Iterable<UniqueConstraintAnnotation> getResourceElements() {
            return AbstractJavaTable.this.getUniqueConstraintAnnotations();
        }

        @Override
        public UniqueConstraintAnnotation getResourceElement(JavaUniqueConstraint contextElement) {
            return contextElement.getUniqueConstraintAnnotation();
        }

        @Override
        public void moveContextElement(int index, JavaUniqueConstraint element) {
            AbstractJavaTable.this.moveUniqueConstraint_(index, element);
        }

        @Override
        public void addContextElement(int index, UniqueConstraintAnnotation resourceElement) {
            AbstractJavaTable.this.addUniqueConstraint_(index, resourceElement);
        }

        @Override
        public void removeContextElement(JavaUniqueConstraint element) {
            AbstractJavaTable.this.removeUniqueConstraint_(element);
        }
    }
}

