/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.common.utility.internal.iterators.SingleElementIterator;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.ColumnMapping;
import org.eclipse.jpt.jpa.core.context.Relationship;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.SimpleMetamodelField;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.AttributeMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaPersistentAttribute2_0;
import org.eclipse.jpt.jpa.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaAttributeMapping<A extends Annotation>
extends AbstractJavaJpaContextNode
implements JavaAttributeMapping,
AttributeMapping2_0 {
    protected boolean default_ = this.buildDefault();

    protected AbstractJavaAttributeMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.updateDefault();
    }

    @Override
    public void update() {
        super.update();
    }

    @Override
    public String getName() {
        return this.getPersistentAttribute().getName();
    }

    public A getMappingAnnotation() {
        return (A)this.getAnnotation_();
    }

    protected Annotation getAnnotation_() {
        return this.getResourcePersistentAttribute().getAnnotation(this.getAnnotationName());
    }

    protected abstract String getAnnotationName();

    public A getAnnotationForUpdate() {
        A annotation = this.getMappingAnnotation();
        if (annotation == null) {
            this.getPersistentAttribute().setMappingKey(this.getKey());
            annotation = this.getMappingAnnotation();
            if (annotation == null) {
                throw new IllegalStateException("missing annotation: " + this);
            }
        }
        return annotation;
    }

    @Override
    public boolean isDefault() {
        return this.default_;
    }

    protected void setDefault(boolean default_) {
        boolean old = this.default_;
        this.default_ = default_;
        this.firePropertyChanged("default", old, default_);
    }

    @Override
    public void updateDefault() {
        this.setDefault(this.buildDefault());
    }

    protected boolean buildDefault() {
        return this.getMappingAnnotation() == null;
    }

    @Override
    public JavaPersistentAttribute getParent() {
        return (JavaPersistentAttribute)super.getParent();
    }

    @Override
    public JavaPersistentAttribute getPersistentAttribute() {
        return this.getParent();
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.getPersistentAttribute().getOwningTypeMapping();
    }

    @Override
    public JavaResourcePersistentAttribute getResourcePersistentAttribute() {
        return this.getPersistentAttribute().getResourcePersistentAttribute();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return null;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return false;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return false;
    }

    @Override
    public boolean isRelationshipOwner() {
        return false;
    }

    @Override
    public boolean isOwnedBy(AttributeMapping mapping) {
        return false;
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getTypeMapping().validatesAgainstDatabase();
    }

    public Table resolveDbTable(String tableName) {
        return this.getTypeMapping().resolveDbTable(tableName);
    }

    protected JavaPersistentAttribute getJavaPersistentAttribute() {
        return this.getPersistentAttribute().getJavaPersistentAttribute();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public Iterator<String> allMappingNames() {
        return new SingleElementIterator((Object)this.getName());
    }

    @Override
    public Iterator<String> allOverridableAttributeMappingNames() {
        return this.isOverridableAttributeMapping() ? new SingleElementIterator((Object)this.getName()) : EmptyIterator.instance();
    }

    @Override
    public Iterator<String> allOverridableAssociationMappingNames() {
        return this.isOverridableAssociationMapping() ? new SingleElementIterator((Object)this.getName()) : EmptyIterator.instance();
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        ColumnMapping mapping = this.resolveColumnMapping(attributeName);
        return mapping == null ? null : mapping.getColumn();
    }

    protected ColumnMapping resolveColumnMapping(String name) {
        AttributeMapping mapping = this.resolveAttributeMapping(name);
        return mapping != null && mapping.isOverridableAttributeMapping() ? (ColumnMapping)mapping : null;
    }

    @Override
    public Relationship resolveOverriddenRelationship(String attributeName) {
        RelationshipMapping mapping = this.resolveRelationshipMapping(attributeName);
        return mapping == null ? null : mapping.getRelationship();
    }

    protected RelationshipMapping resolveRelationshipMapping(String name) {
        AttributeMapping mapping = this.resolveAttributeMapping(name);
        return mapping != null && mapping.isOverridableAssociationMapping() ? (RelationshipMapping)mapping : null;
    }

    @Override
    public AttributeMapping resolveAttributeMapping(String attributeName) {
        return this.getName().equals(attributeName) ? this : null;
    }

    protected Transformer<String, String> buildQualifierTransformer() {
        return new MappingTools.QualifierTransformer(this.getName());
    }

    protected String unqualify(String attributeName) {
        return MappingTools.unqualify(this.getName(), attributeName);
    }

    @Override
    public MetamodelField getMetamodelField() {
        return new SimpleMetamodelField(this.getMetamodelFieldModifiers(), this.getMetamodelFieldTypeName(), this.getMetamodelFieldTypeArgumentNames(), this.getMetamodelFieldName());
    }

    protected Iterable<String> getMetamodelFieldModifiers() {
        return STANDARD_METAMODEL_FIELD_MODIFIERS;
    }

    protected String getMetamodelFieldTypeName() {
        return "javax.persistence.metamodel.SingularAttribute";
    }

    protected final Iterable<String> getMetamodelFieldTypeArgumentNames() {
        ArrayList<String> typeArgumentNames = new ArrayList<String>(3);
        typeArgumentNames.add(this.getTypeMapping().getPersistentType().getName());
        this.addMetamodelFieldTypeArgumentNamesTo(typeArgumentNames);
        return typeArgumentNames;
    }

    protected void addMetamodelFieldTypeArgumentNamesTo(ArrayList<String> typeArgumentNames) {
        typeArgumentNames.add(this.getMetamodelTypeName());
    }

    @Override
    public String getMetamodelTypeName() {
        return ((JavaPersistentAttribute2_0)this.getPersistentAttribute()).getMetamodelTypeName();
    }

    protected String getMetamodelFieldName() {
        return this.getName();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateMappingType(messages, astRoot);
    }

    protected void validateMappingType(List<IMessage> messages, CompilationUnit astRoot) {
        if (!this.getTypeMapping().attributeMappingKeyAllowed(this.getKey())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_INVALID_MAPPING", new String[]{this.getName()}, this, this.getValidationTextRange(astRoot)));
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getMappingAnnotationTextRange(astRoot);
        return textRange != null ? textRange : this.getPersistentAttribute().getValidationTextRange(astRoot);
    }

    protected TextRange getMappingAnnotationTextRange(CompilationUnit astRoot) {
        A annotation = this.getMappingAnnotation();
        return annotation == null ? null : annotation.getTextRange(astRoot);
    }
}

