/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.operations;

import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.operations.AbstractJpaFileCreationOperation;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationDataModelProperties;
import org.eclipse.jpt.jpa.core.internal.resource.orm.OrmXmlResourceProvider;
import org.eclipse.jpt.jpa.core.resource.AbstractXmlResourceProvider;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class OrmFileCreationOperation
extends AbstractJpaFileCreationOperation
implements OrmFileCreationDataModelProperties {
    public OrmFileCreationOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        IStatus status = super.execute((IProgressMonitor)sm.newChild(4), info);
        if (status.isOK()) {
            this.addMappingFileToPersistenceXml();
            sm.worked(1);
        }
        return OK_STATUS;
    }

    protected PersistenceUnit getPersistenceUnit() throws ExecutionException {
        String pUnitName = this.getDataModel().getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        JpaProject jpaProject = this.getJpaProject();
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            throw new ExecutionException("Project does not have a persistence.xml file");
        }
        Persistence persistence = persistenceXml.getPersistence();
        if (persistence == null) {
            throw new ExecutionException("persistence.xml does not have a persistence node.");
        }
        ListIterator<PersistenceUnit> stream = persistence.persistenceUnits();
        while (stream.hasNext()) {
            PersistenceUnit pUnit = (PersistenceUnit)stream.next();
            if (!pUnitName.equals(pUnit.getName())) continue;
            return pUnit;
        }
        throw new ExecutionException("persistence.xml does not have persistence unit named '" + pUnitName + "'");
    }

    protected void addMappingFileToPersistenceXml() throws ExecutionException {
        if (!this.getDataModel().getBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT")) {
            return;
        }
        JpaProject jpaProject = JptJpaCorePlugin.getJpaProject(this.file.getProject());
        JpaXmlResource resource = jpaProject.getPersistenceXmlResource();
        final PersistenceUnit pUnit = this.getPersistenceUnit();
        resource.modify(new Runnable(){

            public void run() {
                IPath containerPath = (IPath)OrmFileCreationOperation.this.getDataModel().getProperty("JptFileCreationDataModelProperties.CONTAINER_PATH");
                String fileName = OrmFileCreationOperation.this.getDataModel().getStringProperty("JptFileCreationDataModelProperties.FILE_NAME");
                IContainer container = PlatformTools.getContainer((IPath)containerPath);
                IPath filePath = container.getFullPath().append(fileName);
                IProject project = container.getProject();
                IPath runtimePath = JptCommonCorePlugin.getResourceLocator((IProject)project).getRuntimePath(project, filePath);
                ListIterator<MappingFileRef> stream = pUnit.specifiedMappingFileRefs();
                while (stream.hasNext()) {
                    if (!runtimePath.equals((Object)((MappingFileRef)stream.next()).getFileName())) continue;
                    return;
                }
                pUnit.addSpecifiedMappingFileRef(runtimePath.toString());
            }
        });
    }

    protected AbstractXmlResourceProvider getXmlResourceProvider(IFile file) {
        return OrmXmlResourceProvider.getXmlResourceProvider(file);
    }
}

