/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverridesAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.NestableAttributeOverrideAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceAttributeOverridesAnnotation
extends SourceAnnotation<Member>
implements AttributeOverridesAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AttributeOverrides");
    private final Vector<NestableAttributeOverrideAnnotation> attributeOverrides = new Vector();

    public SourceAttributeOverridesAnnotation(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.AttributeOverrides";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        AnnotationContainerTools.initialize(this, astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        AnnotationContainerTools.synchronize(this, astRoot);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.attributeOverrides.isEmpty();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.attributeOverrides);
    }

    @Override
    public String getElementName() {
        return "value";
    }

    @Override
    public String getNestedAnnotationName() {
        return "javax.persistence.AttributeOverride";
    }

    @Override
    public Iterable<NestableAttributeOverrideAnnotation> getNestedAnnotations() {
        return new LiveCloneIterable(this.attributeOverrides);
    }

    @Override
    public int getNestedAnnotationsSize() {
        return this.attributeOverrides.size();
    }

    @Override
    public void nestStandAloneAnnotation(NestableAnnotation standAloneAnnotation) {
        this.nestStandAloneAnnotation(standAloneAnnotation, this.attributeOverrides.size());
    }

    private void nestStandAloneAnnotation(NestableAnnotation standAloneAnnotation, int index) {
        standAloneAnnotation.convertToNested(this, this.daa, index);
    }

    @Override
    public void addNestedAnnotation(int index, NestableAnnotation annotation) {
        this.attributeOverrides.add(index, (NestableAttributeOverrideAnnotation)annotation);
    }

    @Override
    public void convertLastNestedAnnotationToStandAlone() {
        this.attributeOverrides.remove(0).convertToStandAlone();
    }

    @Override
    public NestableAttributeOverrideAnnotation addNestedAnnotation() {
        return this.addNestedAnnotation(this.attributeOverrides.size());
    }

    private NestableAttributeOverrideAnnotation addNestedAnnotation(int index) {
        NestableAttributeOverrideAnnotation attributeOverride = this.buildAttributeOverride(index);
        this.attributeOverrides.add(index, attributeOverride);
        return attributeOverride;
    }

    @Override
    public void syncAddNestedAnnotation(Annotation astAnnotation) {
        int index = this.attributeOverrides.size();
        NestableAttributeOverrideAnnotation attributeOverride = this.addNestedAnnotation(index);
        attributeOverride.initialize((CompilationUnit)astAnnotation.getRoot());
        this.fireItemAdded("attributeOverrides", index, attributeOverride);
    }

    private NestableAttributeOverrideAnnotation buildAttributeOverride(int index) {
        return SourceAttributeOverrideAnnotation.buildNestedAttributeOverride(this.parent, (Member)this.annotatedElement, index, this.daa);
    }

    @Override
    public NestableAttributeOverrideAnnotation moveNestedAnnotation(int targetIndex, int sourceIndex) {
        return (NestableAttributeOverrideAnnotation)CollectionTools.move(this.attributeOverrides, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    @Override
    public NestableAttributeOverrideAnnotation removeNestedAnnotation(int index) {
        return this.attributeOverrides.remove(index);
    }

    @Override
    public void syncRemoveNestedAnnotations(int index) {
        this.removeItemsFromList(index, this.attributeOverrides, "attributeOverrides");
    }
}

