/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaNamedColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.OrderColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.java.GenericJavaOrderColumn2_0;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOrderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OrderColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.OrderByAnnotation;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaOrderable
extends AbstractJavaJpaContextNode
implements JavaOrderable2_0 {
    protected String specifiedOrderBy = this.buildSpecifiedOrderBy();
    protected boolean noOrdering = this.buildNoOrdering();
    protected boolean pkOrdering = this.buildPkOrdering();
    protected boolean customOrdering = this.buildCustomOrdering();
    protected final Orderable2_0.Owner owner;
    protected boolean orderColumnOrdering = false;
    protected final JavaOrderColumn2_0 orderColumn;

    public GenericJavaOrderable(JavaAttributeMapping parent) {
        this(parent, null);
    }

    public GenericJavaOrderable(JavaAttributeMapping parent, Orderable2_0.Owner owner) {
        super(parent);
        this.owner = owner;
        this.orderColumnOrdering = this.buildOrderColumnOrdering();
        this.orderColumn = this.buildOrderColumn();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedOrderBy_(this.buildSpecifiedOrderBy());
        this.setNoOrdering_(this.buildNoOrdering());
        this.setPkOrdering_(this.buildPkOrdering());
        this.setCustomOrdering_(this.buildCustomOrdering());
        this.setOrderColumnOrdering_(this.buildOrderColumnOrdering());
        this.orderColumn.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.orderColumn.update();
    }

    @Override
    public String getSpecifiedOrderBy() {
        return this.specifiedOrderBy;
    }

    @Override
    public void setSpecifiedOrderBy(String orderBy) {
        if (orderBy != null) {
            this.removeOrderColumnAnnotation();
            this.getOrderByAnnotationForUpdate().setValue(orderBy);
            this.setSpecifiedOrderBy_(orderBy);
            this.setNoOrdering_(false);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(true);
            this.setOrderColumnOrdering_(false);
        } else {
            this.setNoOrdering(true);
        }
    }

    protected void setSpecifiedOrderBy_(String orderBy) {
        String old = this.specifiedOrderBy;
        this.specifiedOrderBy = orderBy;
        this.firePropertyChanged("specifiedOrderBy", old, orderBy);
    }

    protected String buildSpecifiedOrderBy() {
        if (this.orderColumnAnnotationIsPresent()) {
            return null;
        }
        OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
        return orderByAnnotation == null ? null : orderByAnnotation.getValue();
    }

    @Override
    public boolean isNoOrdering() {
        return this.noOrdering;
    }

    @Override
    public void setNoOrdering(boolean noOrdering) {
        if (noOrdering) {
            this.removeOrderColumnAnnotation();
            if (this.getOrderByAnnotation() != null) {
                this.removeOrderByAnnotation();
            }
            this.setSpecifiedOrderBy_(null);
            this.setNoOrdering_(true);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
            this.setOrderColumnOrdering_(false);
        } else {
            this.setPkOrdering(true);
        }
    }

    protected void setNoOrdering_(boolean noOrdering) {
        boolean old = this.noOrdering;
        this.noOrdering = noOrdering;
        this.firePropertyChanged("noOrdering", old, noOrdering);
    }

    protected boolean buildNoOrdering() {
        return this.isJpa2_0Compatible() ? this.buildNoOrdering2_0() : this.buildNoOrdering1_0();
    }

    protected boolean buildNoOrdering2_0() {
        boolean orderColumnPresent;
        boolean orderByMissing = this.getOrderByAnnotation() == null;
        boolean orderByPresent = !orderByMissing;
        boolean orderColumnMissing = this.getOrderColumnAnnotation() == null;
        boolean bl = orderColumnPresent = !orderColumnMissing;
        return orderByMissing && orderColumnMissing || orderByPresent && orderColumnPresent;
    }

    protected boolean buildNoOrdering1_0() {
        return this.getOrderByAnnotation() == null;
    }

    @Override
    public boolean isPkOrdering() {
        return this.pkOrdering;
    }

    @Override
    public void setPkOrdering(boolean pkOrdering) {
        if (pkOrdering) {
            this.removeOrderColumnAnnotation();
            OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
            if (orderByAnnotation == null) {
                this.addOrderByAnnotation();
            } else {
                orderByAnnotation.setValue(null);
            }
            this.setSpecifiedOrderBy_(null);
            this.setNoOrdering_(false);
            this.setPkOrdering_(true);
            this.setCustomOrdering_(false);
            this.setOrderColumnOrdering_(false);
        } else {
            this.setNoOrdering(true);
        }
    }

    protected void setPkOrdering_(boolean pkOrdering) {
        boolean old = this.pkOrdering;
        this.pkOrdering = pkOrdering;
        this.firePropertyChanged("pkOrdering", old, pkOrdering);
    }

    protected boolean buildPkOrdering() {
        if (this.orderColumnAnnotationIsPresent()) {
            return false;
        }
        OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
        return orderByAnnotation != null && orderByAnnotation.getValue() == null;
    }

    @Override
    public boolean isCustomOrdering() {
        return this.customOrdering;
    }

    @Override
    public void setCustomOrdering(boolean customOrdering) {
        if (customOrdering) {
            this.setSpecifiedOrderBy("");
        } else {
            this.setNoOrdering(true);
        }
    }

    protected void setCustomOrdering_(boolean customOrdering) {
        boolean old = this.customOrdering;
        this.customOrdering = customOrdering;
        this.firePropertyChanged("customOrdering", old, customOrdering);
    }

    protected boolean buildCustomOrdering() {
        if (this.orderColumnAnnotationIsPresent()) {
            return false;
        }
        OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
        return orderByAnnotation != null && orderByAnnotation.getValue() != null;
    }

    @Override
    public boolean isOrderColumnOrdering() {
        return this.orderColumnOrdering;
    }

    @Override
    public void setOrderColumnOrdering(boolean orderColumnOrdering) {
        if (orderColumnOrdering) {
            this.removeOrderByAnnotation();
            if (this.getOrderColumnAnnotation() == null) {
                this.addOrderColumnAnnotation();
            }
            this.setSpecifiedOrderBy_(null);
            this.setNoOrdering_(false);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
            this.setOrderColumnOrdering_(true);
        } else {
            this.setNoOrdering(true);
        }
    }

    protected void setOrderColumnOrdering_(boolean orderColumnOrdering) {
        boolean old = this.orderColumnOrdering;
        this.orderColumnOrdering = orderColumnOrdering;
        this.firePropertyChanged("orderColumnOrdering", old, orderColumnOrdering);
    }

    protected boolean buildOrderColumnOrdering() {
        return this.orderColumnAnnotationIsPresent() && this.getOrderByAnnotation() == null;
    }

    @Override
    public JavaOrderColumn2_0 getOrderColumn() {
        return this.orderColumn;
    }

    protected JavaOrderColumn2_0 buildOrderColumn() {
        OrderColumnOwner columnOwner = new OrderColumnOwner();
        return this.isJpa2_0Compatible() ? this.getJpaFactory2_0().buildJavaOrderColumn(this, columnOwner) : new GenericJavaOrderColumn2_0(this, columnOwner);
    }

    protected OrderByAnnotation getOrderByAnnotation() {
        return (OrderByAnnotation)this.getResourcePersistentAttribute().getAnnotation("javax.persistence.OrderBy");
    }

    protected OrderByAnnotation getOrderByAnnotationForUpdate() {
        OrderByAnnotation annotation = this.getOrderByAnnotation();
        return annotation != null ? annotation : this.addOrderByAnnotation();
    }

    protected OrderByAnnotation addOrderByAnnotation() {
        return (OrderByAnnotation)this.getResourcePersistentAttribute().addAnnotation("javax.persistence.OrderBy");
    }

    protected void removeOrderByAnnotation() {
        this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.OrderBy");
    }

    protected OrderColumn2_0Annotation getOrderColumnAnnotation() {
        return (OrderColumn2_0Annotation)this.getResourcePersistentAttribute().getAnnotation("javax.persistence.OrderColumn");
    }

    protected boolean orderColumnAnnotationIsPresent() {
        return this.isJpa2_0Compatible() && this.getOrderColumnAnnotation() != null;
    }

    protected OrderColumn2_0Annotation addOrderColumnAnnotation() {
        return (OrderColumn2_0Annotation)this.getResourcePersistentAttribute().addAnnotation("javax.persistence.OrderColumn");
    }

    protected void removeOrderColumnAnnotation() {
        if (this.orderColumnAnnotationIsPresent()) {
            this.removeOrderColumnAnnotation_();
        }
    }

    protected void removeOrderColumnAnnotation_() {
        this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.OrderColumn");
    }

    @Override
    public JavaAttributeMapping getParent() {
        return (JavaAttributeMapping)super.getParent();
    }

    protected JavaAttributeMapping getAttributeMapping() {
        return this.getParent();
    }

    protected JavaPersistentAttribute getPersistentAttribute() {
        return this.getAttributeMapping().getPersistentAttribute();
    }

    @Override
    public JavaResourcePersistentAttribute getResourcePersistentAttribute() {
        return this.getPersistentAttribute().getResourcePersistentAttribute();
    }

    @Override
    public String getDefaultTableName() {
        return this.owner.getTableName();
    }

    protected Table resolveDbTable(String tableName) {
        return this.owner.resolveDbTable(tableName);
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return this.orderColumn.javaCompletionProposals(pos, filter, astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getOrderByAnnotationTextRange(astRoot);
        return textRange != null ? textRange : this.getAttributeMapping().getValidationTextRange(astRoot);
    }

    protected TextRange getOrderByAnnotationTextRange(CompilationUnit astRoot) {
        OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
        return orderByAnnotation == null ? null : orderByAnnotation.getTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.orderColumnAnnotationIsPresent() && this.getOrderByAnnotation() != null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ORDER_COLUMN_AND_ORDER_BY_BOTH_SPECIFIED", new String[]{this.getPersistentAttribute().getName()}, this.getAttributeMapping(), this.getOrderByAnnotationTextRange(astRoot)));
        }
        if (this.orderColumnOrdering) {
            this.orderColumn.validate(messages, reporter, astRoot);
        }
    }

    protected class OrderColumnOwner
    implements JavaNamedColumn.Owner {
        protected OrderColumnOwner() {
        }

        public String getDefaultTableName() {
            return GenericJavaOrderable.this.getDefaultTableName();
        }

        public Table resolveDbTable(String tableName) {
            return GenericJavaOrderable.this.resolveDbTable(tableName);
        }

        public String getDefaultColumnName() {
            return String.valueOf(this.getPersistentAttribute().getName()) + "_ORDER";
        }

        public TypeMapping getTypeMapping() {
            return this.getPersistentAttribute().getOwningTypeMapping();
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return GenericJavaOrderable.this.getValidationTextRange(astRoot);
        }

        public JptValidator buildColumnValidator(NamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return new OrderColumnValidator((PersistentAttribute)this.getPersistentAttribute(), (OrderColumn2_0)column, textRangeResolver);
        }

        protected JavaPersistentAttribute getPersistentAttribute() {
            return GenericJavaOrderable.this.getPersistentAttribute();
        }
    }
}

