/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.tasks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.tasks.IFileTaskScanner;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;
import org.eclipse.wst.sse.core.internal.tasks.FileTaskScannerRegistryReader;
import org.eclipse.wst.sse.core.utils.StringUtils;

class WorkspaceTaskScanner {
    private static WorkspaceTaskScanner _instance = null;
    static final String SYNTHETIC_TASK = "org.eclipse.wst.sse.task-synthetic";
    static final String MODIFICATION_STAMP = "org.eclipse.wst.sse.modification-stamp";
    private boolean proceed = false;
    static final String DEFAULT_MARKER_TYPE = "org.eclipse.wst.sse.core.task";
    private List fActiveScanners = null;
    private IContentType[] fCurrentIgnoreContentTypes = null;
    private TaskTag[] fCurrentTaskTags = null;
    private FileTaskScannerRegistryReader registry = FileTaskScannerRegistryReader.getInstance();
    private long time0;

    static synchronized WorkspaceTaskScanner getInstance() {
        if (_instance == null) {
            _instance = new WorkspaceTaskScanner();
        }
        return _instance;
    }

    private WorkspaceTaskScanner() {
        this.fActiveScanners = new ArrayList();
        this.fCurrentTaskTags = new TaskTag[0];
        this.fCurrentIgnoreContentTypes = new IContentType[0];
    }

    private IContentType[] detectContentTypes(IResource resource) {
        IContentType[] types = null;
        if (resource.getType() == 1 && resource.isAccessible()) {
            types = Platform.getContentTypeManager().findContentTypesFor(resource.getName());
            if (types.length == 0) {
                IContentDescription d = null;
                try {
                    d = ((IFile)resource).getContentDescription();
                    if (d != null) {
                        types = new IContentType[]{d.getContentType()};
                    }
                }
                catch (CoreException coreException) {}
            }
            if (types == null) {
                types = Platform.getContentTypeManager().findContentTypesFor(resource.getName());
            }
            if (Logger.DEBUG_TASKSCONTENTTYPE && types.length > 0) {
                if (types.length > 1) {
                    System.out.println(resource.getFullPath() + ": " + "multiple based on name (probably hierarchical)");
                }
                int i = 0;
                while (i < types.length) {
                    System.out.println(resource.getFullPath() + " matched: " + types[i].getId());
                    ++i;
                }
            }
        }
        return types;
    }

    private IProject getProject(IResource resource) {
        IProject project = null;
        project = resource.getType() == 4 ? (IProject)resource : resource.getProject();
        return project;
    }

    private boolean init(IResource resource) {
        IProject project = this.getProject(resource);
        IPreferencesService preferencesService = Platform.getPreferencesService();
        IScopeContext[] lookupOrder = new IScopeContext[]{new ProjectScope(project), new InstanceScope(), new DefaultScope()};
        boolean proceed = preferencesService.getBoolean("org.eclipse.wst.sse.core/task-tags", "enabled", false, lookupOrder);
        if (Logger.DEBUG_TASKSPREFS) {
            System.out.println(String.valueOf(this.getClass().getName()) + " scan of " + resource.getFullPath() + ":" + proceed);
        }
        if (proceed) {
            String[] tags = StringUtils.unpack(preferencesService.getString("org.eclipse.wst.sse.core/task-tags", "taskTags", null, lookupOrder));
            String[] priorities = StringUtils.unpack(preferencesService.getString("org.eclipse.wst.sse.core/task-tags", "taskPriorities", null, lookupOrder));
            String[] currentIgnoreContentTypeIDs = StringUtils.unpack(preferencesService.getString("org.eclipse.wst.sse.core/task-tags", "ignored-contentTypes", null, lookupOrder));
            if (Logger.DEBUG_TASKSPREFS) {
                System.out.print(String.valueOf(this.getClass().getName()) + " tags: ");
                int i = 0;
                while (i < tags.length) {
                    if (i > 0) {
                        System.out.print(",");
                    }
                    System.out.print(tags[i]);
                    ++i;
                }
                System.out.println();
                System.out.print(String.valueOf(this.getClass().getName()) + " priorities: ");
                i = 0;
                while (i < priorities.length) {
                    if (i > 0) {
                        System.out.print(",");
                    }
                    System.out.print(priorities[i]);
                    ++i;
                }
                System.out.println();
                System.out.print(String.valueOf(this.getClass().getName()) + " ignored content types: ");
                i = 0;
                while (i < currentIgnoreContentTypeIDs.length) {
                    if (i > 0) {
                        System.out.print(",");
                    }
                    System.out.print(currentIgnoreContentTypeIDs[i]);
                    ++i;
                }
                System.out.println();
            }
            this.fCurrentIgnoreContentTypes = new IContentType[currentIgnoreContentTypeIDs.length];
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            int i = 0;
            while (i < currentIgnoreContentTypeIDs.length) {
                this.fCurrentIgnoreContentTypes[i] = contentTypeManager.getContentType(currentIgnoreContentTypeIDs[i]);
                ++i;
            }
            int max = Math.min(tags.length, priorities.length);
            this.fCurrentTaskTags = new TaskTag[max];
            int i2 = 0;
            while (i2 < max) {
                int priority = 1;
                try {
                    priority = Integer.parseInt(priorities[i2]);
                }
                catch (NumberFormatException numberFormatException) {}
                this.fCurrentTaskTags[i2] = new TaskTag(tags[i2], priority);
                ++i2;
            }
        }
        return proceed;
    }

    void internalScan(IProject project, IResource resource, IProgressMonitor scanMonitor) {
        if (scanMonitor.isCanceled()) {
            return;
        }
        try {
            String name = resource.getName();
            if (resource.isAccessible() && !resource.isDerived() && !resource.isPhantom() && !resource.isTeamPrivateMember() && name.length() != 0 && name.charAt(0) != '.') {
                if ((resource.getType() & 2) > 0 || (resource.getType() & 4) > 0) {
                    IResource[] children = ((IContainer)resource).members();
                    scanMonitor.beginTask("", children.length);
                    int i = 0;
                    while (i < children.length) {
                        this.internalScan(project, children[i], (IProgressMonitor)new SubProgressMonitor(scanMonitor, 1, 4));
                        ++i;
                    }
                    scanMonitor.done();
                } else if ((resource.getType() & 1) > 0) {
                    this.scanFile(project, this.fCurrentTaskTags, (IFile)resource, scanMonitor);
                }
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    void internalScan(IResourceDelta delta, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        try {
            String name = delta.getFullPath().lastSegment();
            IResource resource = delta.getResource();
            if (!(resource.isDerived() || resource.isPhantom() || resource.isTeamPrivateMember() || name.length() == 0 || name.charAt(0) == '.')) {
                if ((resource.getType() & 2) > 0 || (resource.getType() & 4) > 0) {
                    IResourceDelta[] children = delta.getAffectedChildren();
                    monitor.beginTask("", children.length);
                    if (name.length() != 0 && name.charAt(0) != '.' && children.length > 0) {
                        int i = children.length - 1;
                        while (i >= 0) {
                            this.internalScan(children[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
                            --i;
                        }
                    }
                    monitor.done();
                } else if ((resource.getType() & 1) > 0 && ((delta.getKind() & 1) > 0 || (delta.getKind() & 4) > 0 && (delta.getFlags() & 0x100) > 0)) {
                    IFile file = (IFile)resource;
                    this.scanFile(file.getProject(), this.fCurrentTaskTags, file, monitor);
                }
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    private void replaceTaskMarkers(final IFile file, final String[] markerTypes, final Map[] markerAttributeMaps, IProgressMonitor monitor) {
        final IFile finalFile = file;
        if (file.isAccessible()) {
            try {
                IWorkspaceRunnable r = new IWorkspaceRunnable(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor progressMonitor) throws CoreException {
                        progressMonitor.beginTask("", 2);
                        try {
                            try {
                                int i = 0;
                                while (i < markerTypes.length) {
                                    if ("org.eclipse.core.resources.taskmarker".equals(markerTypes[i])) {
                                        IMarker[] foundMarkers = file.findMarkers(markerTypes[i], true, 0);
                                        int j = 0;
                                        while (j < foundMarkers.length) {
                                            if (foundMarkers[j].getAttribute(WorkspaceTaskScanner.SYNTHETIC_TASK) != null) {
                                                foundMarkers[j].delete();
                                            }
                                            ++j;
                                        }
                                    } else {
                                        file.deleteMarkers(markerTypes[i], true, 0);
                                    }
                                    ++i;
                                }
                            }
                            catch (CoreException e) {
                                Logger.logException("exception deleting old tasks", e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var5_10 = null;
                            progressMonitor.worked(1);
                            throw throwable;
                        }
                        {
                            Object var5_11 = null;
                        }
                        progressMonitor.worked(1);
                        if (WorkspaceTaskScanner.this.proceed && markerAttributeMaps != null && markerAttributeMaps.length > 0) {
                            if (Logger.DEBUG_TASKS) {
                                System.out.println(markerAttributeMaps.length + " tasks for " + file.getFullPath());
                            }
                            int i = 0;
                            while (i < markerAttributeMaps.length) {
                                String specifiedMarkerType = (String)markerAttributeMaps[i].get("org.eclipse.core.resources.taskmarker");
                                IMarker marker = finalFile.createMarker(specifiedMarkerType);
                                marker.setAttributes(markerAttributeMaps[i]);
                                marker.setAttribute("userEditable", (Object)Boolean.FALSE);
                                marker.setAttribute(WorkspaceTaskScanner.MODIFICATION_STAMP, (Object)Long.toString(file.getModificationStamp()));
                                if ("org.eclipse.core.resources.taskmarker".equals(specifiedMarkerType)) {
                                    marker.setAttribute(WorkspaceTaskScanner.SYNTHETIC_TASK, true);
                                }
                                ++i;
                            }
                        }
                        progressMonitor.worked(1);
                        progressMonitor.done();
                    }
                };
                if (file.isAccessible()) {
                    finalFile.getWorkspace().run(r, ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)file), 1, monitor);
                }
            }
            catch (CoreException e1) {
                Logger.logException(e1);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
    }

    void scan(IProject project, IProgressMonitor scanMonitor) {
        if (scanMonitor.isCanceled()) {
            return;
        }
        if (Logger.DEBUG_TASKS) {
            System.out.println(String.valueOf(this.getClass().getName()) + " scanning project " + project.getName());
        }
        if (!project.isAccessible()) {
            if (Logger.DEBUG_TASKS) {
                System.out.println(String.valueOf(this.getClass().getName()) + " skipping inaccessible project " + project.getName());
            }
            return;
        }
        if (Logger.DEBUG_TASKSOVERALLPERF) {
            this.time0 = System.currentTimeMillis();
        }
        this.proceed = this.init((IResource)project);
        this.internalScan(project, (IResource)project, scanMonitor);
        this.shutdownDelegates(project);
        if (Logger.DEBUG_TASKSOVERALLPERF) {
            System.out.println(System.currentTimeMillis() - this.time0 + "ms for " + project.getFullPath());
        }
    }

    void scan(IResourceDelta delta, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        if (Logger.DEBUG_TASKSOVERALLPERF) {
            this.time0 = System.currentTimeMillis();
        }
        if (this.init(delta.getResource())) {
            this.internalScan(delta, monitor);
            this.shutdownDelegates(delta.getResource().getProject());
        }
        if (Logger.DEBUG_TASKSOVERALLPERF) {
            System.out.println(System.currentTimeMillis() - this.time0 + "ms for " + delta.getFullPath());
        }
    }

    void scanFile(IProject project, TaskTag[] taskTags, IFile file, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.beginTask("", 8);
        monitor.subTask(file.getFullPath().toString().substring(1));
        ArrayList<Map> markerAttributes = new ArrayList<Map>();
        IContentType[] types = this.detectContentTypes((IResource)file);
        HashSet<String> markerTypes = new HashSet<String>(3);
        markerTypes.add(DEFAULT_MARKER_TYPE);
        monitor.worked(1);
        IFileTaskScanner[] fileScanners = null;
        IFileTaskScanner[] ignoredFileScanners = null;
        if (types != null) {
            if (this.fCurrentIgnoreContentTypes.length == 0) {
                fileScanners = this.registry.getFileTaskScanners(types);
            } else {
                ArrayList<IContentType> validTypes = new ArrayList<IContentType>();
                int i = 0;
                while (i < types.length) {
                    boolean ignoreContentType = false;
                    int j = 0;
                    while (j < this.fCurrentIgnoreContentTypes.length) {
                        ignoreContentType = ignoreContentType || types[i].isKindOf(this.fCurrentIgnoreContentTypes[j]);
                        ++j;
                    }
                    if (!ignoreContentType) {
                        validTypes.add(types[i]);
                    } else {
                        ignoredFileScanners = this.registry.getFileTaskScanners(new IContentType[]{types[i]});
                    }
                    ++i;
                }
                fileScanners = this.registry.getFileTaskScanners(validTypes.toArray(new IContentType[validTypes.size()]));
            }
            monitor.worked(1);
            if (ignoredFileScanners != null && ignoredFileScanners.length > 0) {
                int i = 0;
                while (i < ignoredFileScanners.length) {
                    markerTypes.add(ignoredFileScanners[i].getMarkerType());
                    ++i;
                }
            }
            if (fileScanners.length > 0) {
                SubProgressMonitor scannerMonitor = new SubProgressMonitor(monitor, 3, 4);
                scannerMonitor.beginTask("", fileScanners.length);
                int j = 0;
                while (fileScanners != null && j < fileScanners.length) {
                    if (!monitor.isCanceled()) {
                        try {
                            if (!this.fActiveScanners.contains(fileScanners[j]) && !monitor.isCanceled()) {
                                fileScanners[j].startup(file.getProject());
                                this.fActiveScanners.add(fileScanners[j]);
                            }
                            markerTypes.add(fileScanners[j].getMarkerType());
                            Map[] taskMarkerAttributes = fileScanners[j].scan(file, taskTags, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)scannerMonitor, 1, 4));
                            int i = 0;
                            while (i < taskMarkerAttributes.length) {
                                if (!taskMarkerAttributes[i].containsKey("org.eclipse.core.resources.taskmarker")) {
                                    taskMarkerAttributes[i].put("org.eclipse.core.resources.taskmarker", fileScanners[j].getMarkerType());
                                }
                                taskMarkerAttributes[i].put("sourceId", fileScanners[j].getClass().getName());
                                markerAttributes.add(taskMarkerAttributes[i]);
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            Logger.logException(file.getFullPath().toString(), e);
                        }
                    }
                    ++j;
                }
                scannerMonitor.done();
            }
        } else {
            monitor.worked(4);
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (fileScanners != null && fileScanners.length > 0 || ignoredFileScanners != null && ignoredFileScanners.length > 0) {
            SubProgressMonitor markerUpdateMonitor = new SubProgressMonitor(monitor, 3, 4);
            if (markerAttributes != null) {
                this.replaceTaskMarkers(file, markerTypes.toArray(new String[markerTypes.size()]), markerAttributes.toArray(new Map[markerAttributes.size()]), (IProgressMonitor)markerUpdateMonitor);
            }
        } else {
            monitor.worked(3);
        }
        monitor.done();
    }

    private void shutdownDelegates(IProject project) {
        int j = 0;
        while (j < this.fActiveScanners.size()) {
            try {
                ((IFileTaskScanner)this.fActiveScanners.get(j)).shutdown(project);
            }
            catch (Exception e) {
                Logger.logException(project.getFullPath().toString(), e);
            }
            ++j;
        }
        this.fActiveScanners = new ArrayList(1);
    }
}

